/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import org.jf.dexlib.DexFile;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.ReadContext;
import org.jf.dexlib.StringIdItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.TypeListItem;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.Input;

public class ProtoIdItem
extends Item<ProtoIdItem> {
    private int hashCode = 0;
    private StringIdItem shortyDescriptor;
    private TypeIdItem returnType;
    private TypeListItem parameters;
    private String cachedPrototypeString = null;

    protected ProtoIdItem(DexFile dexFile) {
        super(dexFile);
    }

    private ProtoIdItem(DexFile dexFile, TypeIdItem typeIdItem, TypeListItem typeListItem) {
        this(dexFile);
        String string = typeIdItem.toShorty();
        if (typeListItem != null) {
            string = string + typeListItem.getShortyString();
        }
        this.shortyDescriptor = StringIdItem.internStringIdItem(dexFile, string);
        this.returnType = typeIdItem;
        this.parameters = typeListItem;
    }

    public static ProtoIdItem internProtoIdItem(DexFile dexFile, TypeIdItem typeIdItem, TypeListItem typeListItem) {
        ProtoIdItem protoIdItem = new ProtoIdItem(dexFile, typeIdItem, typeListItem);
        return dexFile.ProtoIdsSection.intern(protoIdItem);
    }

    public static ProtoIdItem lookupProtoIdItem(DexFile dexFile, TypeIdItem typeIdItem, TypeListItem typeListItem) {
        ProtoIdItem protoIdItem = new ProtoIdItem(dexFile, typeIdItem, typeListItem);
        return dexFile.ProtoIdsSection.getInternedItem(protoIdItem);
    }

    @Override
    protected void readItem(Input input, ReadContext readContext) {
        this.shortyDescriptor = this.dexFile.StringIdsSection.getItemByIndex(input.readInt());
        this.returnType = this.dexFile.TypeIdsSection.getItemByIndex(input.readInt());
        this.parameters = (TypeListItem)readContext.getOptionalOffsettedItemByOffset(ItemType.TYPE_TYPE_LIST, input.readInt());
    }

    @Override
    protected int placeItem(int n) {
        return n + 12;
    }

    @Override
    protected void writeItem(AnnotatedOutput annotatedOutput) {
        if (annotatedOutput.annotates()) {
            annotatedOutput.annotate(4, "shorty_descriptor: " + this.shortyDescriptor.getStringValue());
            annotatedOutput.annotate(4, "return_type: " + this.returnType.getTypeDescriptor());
            if (this.parameters == null) {
                annotatedOutput.annotate(4, "parameters:");
            } else {
                annotatedOutput.annotate(4, "parameters: " + this.parameters.getTypeListString(""));
            }
        }
        annotatedOutput.writeInt(this.shortyDescriptor.getIndex());
        annotatedOutput.writeInt(this.returnType.getIndex());
        annotatedOutput.writeInt(this.parameters == null ? 0 : this.parameters.getOffset());
    }

    @Override
    public ItemType getItemType() {
        return ItemType.TYPE_PROTO_ID_ITEM;
    }

    @Override
    public int compareTo(ProtoIdItem protoIdItem) {
        int n = this.returnType.compareTo(protoIdItem.returnType);
        if (n != 0) {
            return n;
        }
        if (this.parameters == null) {
            if (protoIdItem.parameters == null) {
                return 0;
            }
            return -1;
        }
        if (protoIdItem.parameters == null) {
            return 1;
        }
        return this.parameters.compareTo(protoIdItem.parameters);
    }

    @Override
    public String getConciseIdentity() {
        return "proto_id_item: " + this.getPrototypeString();
    }

    public String getPrototypeString() {
        if (this.cachedPrototypeString == null) {
            StringBuilder stringBuilder = new StringBuilder("(");
            if (this.parameters != null) {
                stringBuilder.append(this.parameters.getTypeListString(""));
            }
            stringBuilder.append(")");
            stringBuilder.append(this.returnType.getTypeDescriptor());
            this.cachedPrototypeString = stringBuilder.toString();
        }
        return this.cachedPrototypeString;
    }

    public TypeIdItem getReturnType() {
        return this.returnType;
    }

    public TypeListItem getParameters() {
        return this.parameters;
    }

    public int getParameterRegisterCount() {
        if (this.parameters == null) {
            return 0;
        }
        return this.parameters.getRegisterCount();
    }

    private void calcHashCode() {
        this.hashCode = this.returnType.hashCode();
        this.hashCode = 31 * this.hashCode + (this.parameters == null ? 0 : this.parameters.hashCode());
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.calcHashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ProtoIdItem protoIdItem = (ProtoIdItem)object;
        return this.returnType == protoIdItem.returnType && this.parameters == protoIdItem.parameters;
    }
}

