/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import org.jf.dexlib.DexFile;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.ReadContext;
import org.jf.dexlib.Util.AlignmentUtils;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.ExceptionWithContext;
import org.jf.dexlib.Util.Input;

public abstract class Item<T extends Item>
implements Comparable<T> {
    protected int offset = -1;
    protected int index = -1;
    protected final DexFile dexFile;

    protected Item(DexFile dexFile) {
        assert (dexFile != null);
        this.dexFile = dexFile;
    }

    protected void readFrom(Input input, int n, ReadContext readContext) {
        try {
            assert (AlignmentUtils.isAligned(input.getCursor(), this.getItemType().ItemAlignment));
            this.offset = input.getCursor();
            this.index = n;
            this.readItem(input, readContext);
        }
        catch (Exception exception) {
            throw this.addExceptionContext(exception);
        }
    }

    protected int placeAt(int n, int n2) {
        try {
            assert (AlignmentUtils.isAligned(n, this.getItemType().ItemAlignment));
            assert (!this.dexFile.getInplace() || n == this.offset && this.index == n2);
            this.offset = n;
            this.index = n2;
            return this.placeItem(n);
        }
        catch (Exception exception) {
            throw this.addExceptionContext(exception);
        }
    }

    protected void writeTo(AnnotatedOutput annotatedOutput) {
        try {
            assert (AlignmentUtils.isAligned(this.offset, this.getItemType().ItemAlignment));
            assert (annotatedOutput.getCursor() == this.offset);
            if (annotatedOutput.annotates()) {
                annotatedOutput.annotate(0, "[" + this.index + "] " + this.getItemType().TypeName);
            }
            annotatedOutput.indent();
            this.writeItem(annotatedOutput);
            annotatedOutput.deindent();
        }
        catch (Exception exception) {
            throw this.addExceptionContext(exception);
        }
    }

    public String toString() {
        return this.getConciseIdentity();
    }

    protected abstract void readItem(Input var1, ReadContext var2);

    protected abstract int placeItem(int var1);

    protected abstract void writeItem(AnnotatedOutput var1);

    protected final RuntimeException addExceptionContext(Exception exception) {
        return ExceptionWithContext.withContext(exception, this.getConciseIdentity());
    }

    public abstract ItemType getItemType();

    public abstract String getConciseIdentity();

    public int getOffset() {
        return this.offset;
    }

    public int getIndex() {
        return this.index;
    }

    public DexFile getDexFile() {
        return this.dexFile;
    }
}

