/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import org.jf.dexlib.DexFile;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.ReadContext;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.Input;
import org.jf.dexlib.Util.Utf8Utils;

public class HeaderItem
extends Item<HeaderItem> {
    public static final byte[] MAGIC = new byte[]{100, 101, 120, 10, 48, 51, 53, 0};
    private static final int HEADER_SIZE = 112;
    private static final int LITTLE_ENDIAN = 305419896;
    private static final int BIG_ENDIAN = 2018910994;

    protected HeaderItem(DexFile dexFile) {
        super(dexFile);
    }

    @Override
    protected void readItem(Input input, ReadContext readContext) {
        int n;
        byte[] byArray = input.readBytes(8);
        for (n = 0; n < 8; ++n) {
            if (MAGIC[n] == byArray[n]) continue;
            throw new RuntimeException("The magic value is not the expected value");
        }
        input.readBytes(20);
        input.readInt();
        input.readInt();
        if (input.readInt() != 112) {
            throw new RuntimeException("The header size is not the expected value (0x70)");
        }
        n = input.readInt();
        if (n == 2018910994) {
            throw new RuntimeException("This dex file is big endian. Only little endian is currently supported.");
        }
        if (n != 305419896) {
            throw new RuntimeException("The endian tag is not 0x12345678 or 0x78563412");
        }
        if (input.readInt() != 0) {
            throw new RuntimeException("This dex file has a link section, which is not supported");
        }
        if (input.readInt() != 0) {
            throw new RuntimeException("This dex file has a link section, which is not supported");
        }
        int n2 = input.readInt();
        readContext.addSection(ItemType.TYPE_MAP_LIST, 1, n2);
        int n3 = input.readInt();
        n2 = input.readInt();
        readContext.addSection(ItemType.TYPE_STRING_ID_ITEM, n3, n2);
        n3 = input.readInt();
        n2 = input.readInt();
        readContext.addSection(ItemType.TYPE_TYPE_ID_ITEM, n3, n2);
        n3 = input.readInt();
        n2 = input.readInt();
        readContext.addSection(ItemType.TYPE_PROTO_ID_ITEM, n3, n2);
        n3 = input.readInt();
        n2 = input.readInt();
        readContext.addSection(ItemType.TYPE_FIELD_ID_ITEM, n3, n2);
        n3 = input.readInt();
        n2 = input.readInt();
        readContext.addSection(ItemType.TYPE_METHOD_ID_ITEM, n3, n2);
        n3 = input.readInt();
        n2 = input.readInt();
        readContext.addSection(ItemType.TYPE_CLASS_DEF_ITEM, n3, n2);
        input.readInt();
        input.readInt();
    }

    @Override
    protected int placeItem(int n) {
        return 112;
    }

    @Override
    protected void writeItem(AnnotatedOutput annotatedOutput) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 8; ++i) {
            stringBuilder.append((char)MAGIC[i]);
        }
        annotatedOutput.annotate("magic: " + Utf8Utils.escapeString(stringBuilder.toString()));
        annotatedOutput.write(MAGIC);
        annotatedOutput.annotate("checksum");
        annotatedOutput.writeInt(0);
        annotatedOutput.annotate("signature");
        annotatedOutput.write(new byte[20]);
        annotatedOutput.annotate("file_size: 0x" + Integer.toHexString(this.dexFile.getFileSize()) + " (" + this.dexFile.getFileSize() + " bytes)");
        annotatedOutput.writeInt(this.dexFile.getFileSize());
        annotatedOutput.annotate("header_size: 0x" + Integer.toHexString(112));
        annotatedOutput.writeInt(112);
        annotatedOutput.annotate("endian_tag: 0x" + Integer.toHexString(305419896));
        annotatedOutput.writeInt(305419896);
        annotatedOutput.annotate("link_size: 0");
        annotatedOutput.writeInt(0);
        annotatedOutput.annotate("link_off: 0");
        annotatedOutput.writeInt(0);
        annotatedOutput.annotate("map_off: 0x" + Integer.toHexString(this.dexFile.MapItem.getOffset()));
        annotatedOutput.writeInt(this.dexFile.MapItem.getOffset());
        annotatedOutput.annotate("string_ids_size: " + this.dexFile.StringIdsSection.getItems().size());
        annotatedOutput.writeInt(this.dexFile.StringIdsSection.getItems().size());
        annotatedOutput.annotate("string_ids_off: 0x" + Integer.toHexString(this.dexFile.StringIdsSection.getOffset()));
        annotatedOutput.writeInt(this.dexFile.StringIdsSection.getOffset());
        annotatedOutput.annotate("type_ids_size: " + this.dexFile.TypeIdsSection.getItems().size());
        annotatedOutput.writeInt(this.dexFile.TypeIdsSection.getItems().size());
        annotatedOutput.annotate("type_ids_off: 0x" + Integer.toHexString(this.dexFile.TypeIdsSection.getOffset()));
        annotatedOutput.writeInt(this.dexFile.TypeIdsSection.getOffset());
        annotatedOutput.annotate("proto_ids_size: " + this.dexFile.ProtoIdsSection.getItems().size());
        annotatedOutput.writeInt(this.dexFile.ProtoIdsSection.getItems().size());
        annotatedOutput.annotate("proto_ids_off: 0x" + Integer.toHexString(this.dexFile.ProtoIdsSection.getOffset()));
        annotatedOutput.writeInt(this.dexFile.ProtoIdsSection.getOffset());
        annotatedOutput.annotate("field_ids_size: " + this.dexFile.FieldIdsSection.getItems().size());
        annotatedOutput.writeInt(this.dexFile.FieldIdsSection.getItems().size());
        annotatedOutput.annotate("field_ids_off: 0x" + Integer.toHexString(this.dexFile.FieldIdsSection.getOffset()));
        annotatedOutput.writeInt(this.dexFile.FieldIdsSection.getOffset());
        annotatedOutput.annotate("method_ids_size: " + this.dexFile.MethodIdsSection.getItems().size());
        annotatedOutput.writeInt(this.dexFile.MethodIdsSection.getItems().size());
        annotatedOutput.annotate("method_ids_off: 0x" + Integer.toHexString(this.dexFile.MethodIdsSection.getOffset()));
        annotatedOutput.writeInt(this.dexFile.MethodIdsSection.getOffset());
        annotatedOutput.annotate("class_defs_size: " + this.dexFile.ClassDefsSection.getItems().size());
        annotatedOutput.writeInt(this.dexFile.ClassDefsSection.getItems().size());
        annotatedOutput.annotate("class_defs_off: 0x" + Integer.toHexString(this.dexFile.ClassDefsSection.getOffset()));
        annotatedOutput.writeInt(this.dexFile.ClassDefsSection.getOffset());
        annotatedOutput.annotate("data_size: 0x" + Integer.toHexString(this.dexFile.getDataSize()) + " (" + this.dexFile.getDataSize() + " bytes)");
        annotatedOutput.writeInt(this.dexFile.getDataSize());
        annotatedOutput.annotate("data_off: 0x" + Integer.toHexString(this.dexFile.getDataOffset()));
        annotatedOutput.writeInt(this.dexFile.getDataOffset());
    }

    @Override
    public ItemType getItemType() {
        return ItemType.TYPE_HEADER_ITEM;
    }

    @Override
    public String getConciseIdentity() {
        return "header_item";
    }

    @Override
    public int compareTo(HeaderItem headerItem) {
        return 0;
    }
}

