/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import org.jf.dexlib.DexFile;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.ReadContext;
import org.jf.dexlib.StringIdItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.Input;

public class FieldIdItem
extends Item<FieldIdItem> {
    private int hashCode = 0;
    private TypeIdItem classType;
    private TypeIdItem fieldType;
    private StringIdItem fieldName;
    String cachedFieldString = null;

    protected FieldIdItem(DexFile dexFile) {
        super(dexFile);
    }

    private FieldIdItem(DexFile dexFile, TypeIdItem typeIdItem, TypeIdItem typeIdItem2, StringIdItem stringIdItem) {
        this(dexFile);
        assert (typeIdItem.dexFile == dexFile);
        assert (typeIdItem2.dexFile == dexFile);
        assert (stringIdItem.dexFile == dexFile);
        this.classType = typeIdItem;
        this.fieldType = typeIdItem2;
        this.fieldName = stringIdItem;
    }

    public static FieldIdItem internFieldIdItem(DexFile dexFile, TypeIdItem typeIdItem, TypeIdItem typeIdItem2, StringIdItem stringIdItem) {
        FieldIdItem fieldIdItem = new FieldIdItem(dexFile, typeIdItem, typeIdItem2, stringIdItem);
        return dexFile.FieldIdsSection.intern(fieldIdItem);
    }

    public static FieldIdItem lookupFieldIdItem(DexFile dexFile, TypeIdItem typeIdItem, TypeIdItem typeIdItem2, StringIdItem stringIdItem) {
        FieldIdItem fieldIdItem = new FieldIdItem(dexFile, typeIdItem, typeIdItem2, stringIdItem);
        return dexFile.FieldIdsSection.getInternedItem(fieldIdItem);
    }

    @Override
    protected void readItem(Input input, ReadContext readContext) {
        this.classType = this.dexFile.TypeIdsSection.getItemByIndex(input.readShort());
        this.fieldType = this.dexFile.TypeIdsSection.getItemByIndex(input.readShort());
        this.fieldName = this.dexFile.StringIdsSection.getItemByIndex(input.readInt());
    }

    @Override
    protected int placeItem(int n) {
        return n + 8;
    }

    @Override
    protected void writeItem(AnnotatedOutput annotatedOutput) {
        if (annotatedOutput.annotates()) {
            annotatedOutput.annotate(2, "class_type: " + this.classType.getTypeDescriptor());
            annotatedOutput.annotate(2, "field_type: " + this.fieldType.getTypeDescriptor());
            annotatedOutput.annotate(4, "field_name: " + this.fieldName.getStringValue());
        }
        annotatedOutput.writeShort(this.classType.getIndex());
        annotatedOutput.writeShort(this.fieldType.getIndex());
        annotatedOutput.writeInt(this.fieldName.getIndex());
    }

    @Override
    public ItemType getItemType() {
        return ItemType.TYPE_FIELD_ID_ITEM;
    }

    @Override
    public String getConciseIdentity() {
        return this.getFieldString();
    }

    @Override
    public int compareTo(FieldIdItem fieldIdItem) {
        int n = this.classType.compareTo(fieldIdItem.classType);
        if (n != 0) {
            return n;
        }
        n = this.fieldName.compareTo(fieldIdItem.fieldName);
        if (n != 0) {
            return n;
        }
        return this.fieldType.compareTo(fieldIdItem.fieldType);
    }

    public TypeIdItem getContainingClass() {
        return this.classType;
    }

    public TypeIdItem getFieldType() {
        return this.fieldType;
    }

    public StringIdItem getFieldName() {
        return this.fieldName;
    }

    public String getFieldString() {
        if (this.cachedFieldString == null) {
            String string = this.classType.getTypeDescriptor();
            String string2 = this.fieldName.getStringValue();
            String string3 = this.fieldType.getTypeDescriptor();
            StringBuffer stringBuffer = new StringBuffer(string.length() + string2.length() + string3.length() + 3);
            stringBuffer.append(string);
            stringBuffer.append("->");
            stringBuffer.append(string2);
            stringBuffer.append(":");
            stringBuffer.append(string3);
            this.cachedFieldString = stringBuffer.toString();
        }
        return this.cachedFieldString;
    }

    private void calcHashCode() {
        this.hashCode = this.classType.hashCode();
        this.hashCode = 31 * this.hashCode + this.fieldType.hashCode();
        this.hashCode = 31 * this.hashCode + this.fieldName.hashCode();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.calcHashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        FieldIdItem fieldIdItem = (FieldIdItem)object;
        return this.classType == fieldIdItem.classType && this.fieldType == fieldIdItem.fieldType && this.fieldName == fieldIdItem.fieldName;
    }
}

