/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import org.jf.dexlib.DexFile;
import org.jf.dexlib.EncodedValue.ArrayEncodedSubValue;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.ReadContext;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.Input;

public class EncodedArrayItem
extends Item<EncodedArrayItem> {
    private int hashCode = 0;
    private ArrayEncodedSubValue encodedArray;

    protected EncodedArrayItem(DexFile dexFile) {
        super(dexFile);
    }

    private EncodedArrayItem(DexFile dexFile, ArrayEncodedSubValue arrayEncodedSubValue) {
        super(dexFile);
        this.encodedArray = arrayEncodedSubValue;
    }

    public static EncodedArrayItem internEncodedArrayItem(DexFile dexFile, ArrayEncodedSubValue arrayEncodedSubValue) {
        EncodedArrayItem encodedArrayItem = new EncodedArrayItem(dexFile, arrayEncodedSubValue);
        return dexFile.EncodedArraysSection.intern(encodedArrayItem);
    }

    @Override
    protected void readItem(Input input, ReadContext readContext) {
        this.encodedArray = new ArrayEncodedSubValue(this.dexFile, input);
    }

    @Override
    protected int placeItem(int n) {
        return this.encodedArray.placeValue(n);
    }

    @Override
    protected void writeItem(AnnotatedOutput annotatedOutput) {
        this.encodedArray.writeValue(annotatedOutput);
    }

    @Override
    public ItemType getItemType() {
        return ItemType.TYPE_ENCODED_ARRAY_ITEM;
    }

    @Override
    public String getConciseIdentity() {
        return "encoded_array @0x" + Integer.toHexString(this.getOffset());
    }

    @Override
    public int compareTo(EncodedArrayItem encodedArrayItem) {
        return this.encodedArray.compareTo(encodedArrayItem.encodedArray);
    }

    public ArrayEncodedSubValue getEncodedArray() {
        return this.encodedArray;
    }

    private void calcHashCode() {
        this.hashCode = this.encodedArray.hashCode();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.calcHashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        EncodedArrayItem encodedArrayItem = (EncodedArrayItem)object;
        return this.encodedArray.compareTo(encodedArrayItem.encodedArray) == 0;
    }
}

