/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code;

import org.jf.dexlib.Code.Format.ArrayDataPseudoInstruction;
import org.jf.dexlib.Code.Format.Instruction10x;
import org.jf.dexlib.Code.Format.PackedSwitchDataPseudoInstruction;
import org.jf.dexlib.Code.Format.SparseSwitchDataPseudoInstruction;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Util.ExceptionWithContext;
import org.jf.dexlib.Util.Hex;

public class InstructionIterator {
    public static void IterateInstructions(DexFile dexFile, byte[] byArray, ProcessInstructionDelegate processInstructionDelegate) {
        Instruction instruction;
        for (int i = 0; i < byArray.length; i += instruction.getSize(i / 2) * 2) {
            try {
                Opcode opcode = Opcode.getOpcodeByValue(byArray[i]);
                instruction = null;
                if (opcode == null) {
                    throw new RuntimeException("Unknown opcode: " + Hex.u1(byArray[i]));
                }
                if (opcode == Opcode.NOP) {
                    byte by = byArray[i + 1];
                    switch (by) {
                        case 0: {
                            instruction = new Instruction10x(Opcode.NOP, byArray, i);
                            break;
                        }
                        case 1: {
                            instruction = new PackedSwitchDataPseudoInstruction(byArray, i);
                            break;
                        }
                        case 2: {
                            instruction = new SparseSwitchDataPseudoInstruction(byArray, i);
                            break;
                        }
                        case 3: {
                            instruction = new ArrayDataPseudoInstruction(byArray, i);
                        }
                    }
                } else {
                    instruction = opcode.format.Factory.makeInstruction(dexFile, opcode, byArray, i);
                }
                assert (instruction != null);
                processInstructionDelegate.ProcessInstruction(i / 2, instruction);
                continue;
            }
            catch (Exception exception) {
                throw ExceptionWithContext.withContext(exception, "Error occured at code address " + i * 2);
            }
        }
    }

    public static interface ProcessInstructionDelegate {
        public void ProcessInstruction(int var1, Instruction var2);
    }
}

