/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code;

import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Util.AnnotatedOutput;

public abstract class Instruction {
    public final Opcode opcode;

    public int getSize(int n) {
        return this.opcode.format.size / 2;
    }

    protected Instruction(Opcode opcode) {
        this.opcode = opcode;
    }

    public abstract Format getFormat();

    public int write(AnnotatedOutput annotatedOutput, int n) {
        if (annotatedOutput.annotates()) {
            this.annotateInstruction(annotatedOutput, n);
        }
        this.writeInstruction(annotatedOutput, n);
        return n + this.getSize(n);
    }

    protected void annotateInstruction(AnnotatedOutput annotatedOutput, int n) {
        annotatedOutput.annotate(this.getSize(n) * 2, "[0x" + Integer.toHexString(n) + "] " + this.opcode.name + " instruction");
    }

    protected abstract void writeInstruction(AnnotatedOutput var1, int var2);

    public static interface InstructionFactory {
        public Instruction makeInstruction(DexFile var1, Opcode var2, byte[] var3, int var4);
    }
}

