/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.Code.TwoRegisterInstruction;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.NumberUtils;

public class Instruction32x
extends Instruction
implements TwoRegisterInstruction {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private short regA;
    private short regB;

    public Instruction32x(Opcode opcode, int n, int n2) {
        super(opcode);
        if (n >= 65536 || n2 >= 65536) {
            throw new RuntimeException("The register number must be less than v65536");
        }
        this.regA = (short)n;
        this.regB = (short)n2;
    }

    private Instruction32x(Opcode opcode, byte[] byArray, int n) {
        super(opcode);
        this.regA = (short)NumberUtils.decodeUnsignedShort(byArray, n + 2);
        this.regB = (short)NumberUtils.decodeUnsignedShort(byArray, n + 4);
    }

    @Override
    protected void writeInstruction(AnnotatedOutput annotatedOutput, int n) {
        annotatedOutput.writeByte(this.opcode.value);
        annotatedOutput.writeByte(0);
        annotatedOutput.writeShort(this.regA);
        annotatedOutput.writeShort(this.regB);
    }

    @Override
    public Format getFormat() {
        return Format.Format32x;
    }

    @Override
    public int getRegisterA() {
        return this.regA & 0xFFFF;
    }

    @Override
    public int getRegisterB() {
        return this.regB & 0xFFFF;
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        @Override
        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] byArray, int n) {
            return new Instruction32x(opcode, byArray, n);
        }
    }
}

