/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.InstructionWithReference;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.Code.SingleRegisterInstruction;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Item;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.NumberUtils;

public class Instruction31c
extends InstructionWithReference
implements SingleRegisterInstruction {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private byte regA;

    public Instruction31c(Opcode opcode, short s, Item item) {
        super(opcode, item);
        if (s >= 256) {
            throw new RuntimeException("The register number must be less than v256");
        }
        this.regA = (byte)s;
    }

    private Instruction31c(DexFile dexFile, Opcode opcode, byte[] byArray, int n) {
        super(dexFile, opcode, byArray, n);
        this.regA = byArray[n + 1];
    }

    @Override
    protected void writeInstruction(AnnotatedOutput annotatedOutput, int n) {
        annotatedOutput.writeByte(this.opcode.value);
        annotatedOutput.writeByte(this.regA);
        annotatedOutput.writeInt(this.getReferencedItem().getIndex());
    }

    @Override
    protected int getReferencedItemIndex(byte[] byArray, int n) {
        return NumberUtils.decodeInt(byArray, n + 2);
    }

    @Override
    public Format getFormat() {
        return Format.Format31c;
    }

    @Override
    public int getRegisterA() {
        return this.regA & 0xFF;
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        @Override
        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] byArray, int n) {
            return new Instruction31c(dexFile, opcode, byArray, n);
        }
    }
}

