/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import java.util.List;
import org.jf.dexlib.AnnotationItem;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.ReadContext;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.Input;

public class AnnotationSetItem
extends Item<AnnotationSetItem> {
    private int hashCode = 0;
    private AnnotationItem[] annotations;

    protected AnnotationSetItem(DexFile dexFile) {
        super(dexFile);
    }

    private AnnotationSetItem(DexFile dexFile, AnnotationItem[] annotationItemArray) {
        super(dexFile);
        this.annotations = annotationItemArray;
    }

    public static AnnotationSetItem internAnnotationSetItem(DexFile dexFile, List<AnnotationItem> list) {
        AnnotationItem[] annotationItemArray = new AnnotationItem[list.size()];
        list.toArray(annotationItemArray);
        AnnotationSetItem annotationSetItem = new AnnotationSetItem(dexFile, annotationItemArray);
        return dexFile.AnnotationSetsSection.intern(annotationSetItem);
    }

    @Override
    protected void readItem(Input input, ReadContext readContext) {
        this.annotations = new AnnotationItem[input.readInt()];
        for (int i = 0; i < this.annotations.length; ++i) {
            this.annotations[i] = (AnnotationItem)readContext.getOffsettedItemByOffset(ItemType.TYPE_ANNOTATION_ITEM, input.readInt());
        }
    }

    @Override
    protected int placeItem(int n) {
        return n + 4 + this.annotations.length * 4;
    }

    @Override
    protected void writeItem(AnnotatedOutput annotatedOutput) {
        if (annotatedOutput.annotates()) {
            annotatedOutput.annotate(4, "size: 0x" + Integer.toHexString(this.annotations.length) + " (" + this.annotations.length + ")");
            for (AnnotationItem annotationItem : this.annotations) {
                annotatedOutput.annotate(4, "annotation_off: 0x" + Integer.toHexString(annotationItem.getOffset()) + " - " + annotationItem.getEncodedAnnotation().annotationType.getTypeDescriptor());
            }
        }
        annotatedOutput.writeInt(this.annotations.length);
        for (AnnotationItem annotationItem : this.annotations) {
            annotatedOutput.writeInt(annotationItem.getOffset());
        }
    }

    @Override
    public ItemType getItemType() {
        return ItemType.TYPE_ANNOTATION_SET_ITEM;
    }

    @Override
    public String getConciseIdentity() {
        return "annotation_set_item @0x" + Integer.toHexString(this.getOffset());
    }

    @Override
    public int compareTo(AnnotationSetItem annotationSetItem) {
        if (annotationSetItem == null) {
            return 1;
        }
        int n = this.annotations.length - annotationSetItem.annotations.length;
        if (n == 0) {
            for (int i = 0; i < this.annotations.length; ++i) {
                n = this.annotations[i].compareTo(annotationSetItem.annotations[i]);
                if (n == 0) continue;
                return n;
            }
        }
        return n;
    }

    public AnnotationItem[] getAnnotations() {
        return this.annotations;
    }

    private void calcHashCode() {
        this.hashCode = 0;
        for (AnnotationItem annotationItem : this.annotations) {
            this.hashCode = this.hashCode * 31 + annotationItem.hashCode();
        }
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.calcHashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AnnotationSetItem annotationSetItem = (AnnotationSetItem)object;
        return this.compareTo(annotationSetItem) == 0;
    }
}

