/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import org.jf.dexlib.AnnotationVisibility;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.EncodedValue.AnnotationEncodedSubValue;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.ReadContext;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.Input;

public class AnnotationItem
extends Item<AnnotationItem> {
    private int hashCode = 0;
    private AnnotationVisibility visibility;
    private AnnotationEncodedSubValue annotationValue;

    protected AnnotationItem(DexFile dexFile) {
        super(dexFile);
    }

    private AnnotationItem(DexFile dexFile, AnnotationVisibility annotationVisibility, AnnotationEncodedSubValue annotationEncodedSubValue) {
        super(dexFile);
        this.visibility = annotationVisibility;
        this.annotationValue = annotationEncodedSubValue;
    }

    public static AnnotationItem internAnnotationItem(DexFile dexFile, AnnotationVisibility annotationVisibility, AnnotationEncodedSubValue annotationEncodedSubValue) {
        AnnotationItem annotationItem = new AnnotationItem(dexFile, annotationVisibility, annotationEncodedSubValue);
        return dexFile.AnnotationsSection.intern(annotationItem);
    }

    @Override
    protected void readItem(Input input, ReadContext readContext) {
        this.visibility = AnnotationVisibility.fromByte(input.readByte());
        this.annotationValue = new AnnotationEncodedSubValue(this.dexFile, input);
    }

    @Override
    protected int placeItem(int n) {
        return this.annotationValue.placeValue(n + 1);
    }

    @Override
    protected void writeItem(AnnotatedOutput annotatedOutput) {
        if (annotatedOutput.annotates()) {
            annotatedOutput.annotate("visibility: " + this.visibility.name());
            annotatedOutput.writeByte(this.visibility.value);
            this.annotationValue.writeValue(annotatedOutput);
        } else {
            annotatedOutput.writeByte(this.visibility.value);
            this.annotationValue.writeValue(annotatedOutput);
        }
    }

    @Override
    public ItemType getItemType() {
        return ItemType.TYPE_ANNOTATION_ITEM;
    }

    @Override
    public String getConciseIdentity() {
        return "annotation_item @0x" + Integer.toHexString(this.getOffset());
    }

    @Override
    public int compareTo(AnnotationItem annotationItem) {
        int n = this.visibility.value - annotationItem.visibility.value;
        if (n == 0) {
            n = this.annotationValue.compareTo(annotationItem.annotationValue);
        }
        return n;
    }

    public AnnotationVisibility getVisibility() {
        return this.visibility;
    }

    public AnnotationEncodedSubValue getEncodedAnnotation() {
        return this.annotationValue;
    }

    private void calcHashCode() {
        this.hashCode = this.visibility.value;
        this.hashCode = this.hashCode * 31 + this.annotationValue.hashCode();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.calcHashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AnnotationItem annotationItem = (AnnotationItem)object;
        return this.visibility == annotationItem.visibility && this.annotationValue.equals(annotationItem.annotationValue);
    }
}

