/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.jf.baksmali.Adaptors.AnnotationAdaptor;
import org.jf.baksmali.Adaptors.BlankMethodItem;
import org.jf.baksmali.Adaptors.CatchMethodItem;
import org.jf.baksmali.Adaptors.CommentMethodItem;
import org.jf.baksmali.Adaptors.CommentedOutMethodItem;
import org.jf.baksmali.Adaptors.DebugMethodItem;
import org.jf.baksmali.Adaptors.Format.InstructionMethodItem;
import org.jf.baksmali.Adaptors.Format.InstructionMethodItemFactory;
import org.jf.baksmali.Adaptors.LabelMethodItem;
import org.jf.baksmali.Adaptors.LocalDebugMethodItem;
import org.jf.baksmali.Adaptors.MethodItem;
import org.jf.baksmali.Adaptors.ParameterAdaptor;
import org.jf.baksmali.Adaptors.RegisterFormatter;
import org.jf.baksmali.baksmali;
import org.jf.dexlib.AnnotationItem;
import org.jf.dexlib.AnnotationSetItem;
import org.jf.dexlib.AnnotationSetRefList;
import org.jf.dexlib.ClassDataItem;
import org.jf.dexlib.Code.Analysis.AnalyzedInstruction;
import org.jf.dexlib.Code.Analysis.MethodAnalyzer;
import org.jf.dexlib.Code.Analysis.RegisterType;
import org.jf.dexlib.Code.Analysis.ValidationException;
import org.jf.dexlib.Code.FiveRegisterInstruction;
import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.OffsetInstruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.Code.RegisterRangeInstruction;
import org.jf.dexlib.Code.SingleRegisterInstruction;
import org.jf.dexlib.Code.ThreeRegisterInstruction;
import org.jf.dexlib.Code.TwoRegisterInstruction;
import org.jf.dexlib.CodeItem;
import org.jf.dexlib.Debug.DebugInstructionIterator;
import org.jf.dexlib.DebugInfoItem;
import org.jf.dexlib.StringIdItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.Util.AccessFlags;
import org.jf.dexlib.Util.SparseIntArray;

public class MethodDefinition {
    private final StringTemplateGroup stg;
    private final ClassDataItem.EncodedMethod encodedMethod;
    private final MethodAnalyzer methodAnalyzer;
    private final LabelCache labelCache = new LabelCache();
    private final SparseIntArray packedSwitchMap;
    private final SparseIntArray sparseSwitchMap;
    private final SparseIntArray instructionMap;
    private final int registerCount;

    public MethodDefinition(StringTemplateGroup stringTemplateGroup, ClassDataItem.EncodedMethod encodedMethod) {
        this.stg = stringTemplateGroup;
        this.encodedMethod = encodedMethod;
        if (encodedMethod.codeItem != null) {
            this.methodAnalyzer = new MethodAnalyzer(encodedMethod, baksmali.deodex);
            List<AnalyzedInstruction> list = this.methodAnalyzer.getInstructions();
            this.packedSwitchMap = new SparseIntArray(1);
            this.sparseSwitchMap = new SparseIntArray(1);
            this.instructionMap = new SparseIntArray(list.size());
            this.registerCount = encodedMethod.codeItem.getRegisterCount();
            int n = 0;
            for (int i = 0; i < list.size(); ++i) {
                AnalyzedInstruction analyzedInstruction = list.get(i);
                if (analyzedInstruction.getInstruction().opcode == Opcode.PACKED_SWITCH) {
                    this.packedSwitchMap.append(n + ((OffsetInstruction)((Object)analyzedInstruction.getInstruction())).getTargetAddressOffset(), n);
                } else if (analyzedInstruction.getInstruction().opcode == Opcode.SPARSE_SWITCH) {
                    this.sparseSwitchMap.append(n + ((OffsetInstruction)((Object)analyzedInstruction.getInstruction())).getTargetAddressOffset(), n);
                }
                this.instructionMap.append(n, i);
                n += analyzedInstruction.getInstruction().getSize(n);
            }
        } else {
            this.packedSwitchMap = null;
            this.sparseSwitchMap = null;
            this.instructionMap = null;
            this.methodAnalyzer = null;
            this.registerCount = 0;
        }
    }

    public StringTemplate createTemplate(AnnotationSetItem annotationSetItem, AnnotationSetRefList annotationSetRefList) {
        CodeItem codeItem = this.encodedMethod.codeItem;
        StringTemplate stringTemplate = this.stg.getInstanceOf("method");
        stringTemplate.setAttribute("AccessFlags", MethodDefinition.getAccessFlags(this.encodedMethod));
        stringTemplate.setAttribute("MethodName", this.encodedMethod.method.getMethodName().getStringValue());
        stringTemplate.setAttribute("Prototype", this.encodedMethod.method.getPrototype().getPrototypeString());
        stringTemplate.setAttribute("HasCode", codeItem != null);
        stringTemplate.setAttribute("RegistersDirective", baksmali.useLocalsDirective ? ".locals" : ".registers");
        stringTemplate.setAttribute("RegisterCount", codeItem == null ? "0" : Integer.toString(MethodDefinition.getRegisterCount(this.encodedMethod)));
        stringTemplate.setAttribute("Parameters", MethodDefinition.getParameters(this.stg, codeItem, annotationSetRefList));
        stringTemplate.setAttribute("Annotations", MethodDefinition.getAnnotations(this.stg, annotationSetItem));
        stringTemplate.setAttribute("MethodItems", this.getMethodItems());
        return stringTemplate;
    }

    private static int getRegisterCount(ClassDataItem.EncodedMethod encodedMethod) {
        int n = encodedMethod.codeItem.getRegisterCount();
        if (baksmali.useLocalsDirective) {
            int n2 = encodedMethod.method.getPrototype().getParameterRegisterCount();
            if ((encodedMethod.accessFlags & AccessFlags.STATIC.getValue()) == 0) {
                ++n2;
            }
            return n - n2;
        }
        return n;
    }

    private static List<String> getAccessFlags(ClassDataItem.EncodedMethod encodedMethod) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (AccessFlags accessFlags : AccessFlags.getAccessFlagsForMethod(encodedMethod.accessFlags)) {
            arrayList.add(accessFlags.toString());
        }
        return arrayList;
    }

    private static List<StringTemplate> getParameters(StringTemplateGroup stringTemplateGroup, CodeItem codeItem, AnnotationSetRefList annotationSetRefList) {
        Object object;
        Object object2;
        DebugInfoItem debugInfoItem = null;
        if (baksmali.outputDebugInfo && codeItem != null) {
            debugInfoItem = codeItem.getDebugInfo();
        }
        int n = 0;
        ArrayList<AnnotationSetItem> arrayList = new ArrayList<AnnotationSetItem>();
        if (annotationSetRefList != null) {
            object2 = annotationSetRefList.getAnnotationSets();
            if (object2 != null) {
                arrayList.addAll(Arrays.asList(object2));
            }
            n = arrayList.size();
        }
        object2 = new ArrayList();
        if (debugInfoItem != null) {
            object = debugInfoItem.getParameterNames();
            if (object != null) {
                for (StringIdItem stringIdItem : object) {
                    object2.add(stringIdItem == null ? null : stringIdItem.getStringValue());
                }
            }
            if (n < object2.size()) {
                n = object2.size();
            }
        }
        object = new ArrayList();
        for (int i = 0; i < n; ++i) {
            AnnotationSetItem annotationSetItem = null;
            if (i < arrayList.size()) {
                annotationSetItem = (AnnotationSetItem)arrayList.get(i);
            }
            String string = null;
            if (i < object2.size()) {
                string = (String)object2.get(i);
            }
            object.add(ParameterAdaptor.createTemplate(stringTemplateGroup, string, annotationSetItem));
        }
        return object;
    }

    public LabelCache getLabelCache() {
        return this.labelCache;
    }

    public ValidationException getValidationException() {
        if (this.methodAnalyzer == null) {
            return null;
        }
        return this.methodAnalyzer.getValidationException();
    }

    public int getPackedSwitchBaseAddress(int n) {
        int n2 = this.packedSwitchMap.get(n, -1);
        if (n2 == -1) {
            throw new RuntimeException("Could not find the packed switch statement corresponding to the packed switch data at address " + n);
        }
        return n2;
    }

    public int getSparseSwitchBaseAddress(int n) {
        int n2 = this.sparseSwitchMap.get(n, -1);
        if (n2 == -1) {
            throw new RuntimeException("Could not find the sparse switch statement corresponding to the sparse switch data at address " + n);
        }
        return n2;
    }

    private static List<StringTemplate> getAnnotations(StringTemplateGroup stringTemplateGroup, AnnotationSetItem annotationSetItem) {
        if (annotationSetItem == null) {
            return null;
        }
        ArrayList<StringTemplate> arrayList = new ArrayList<StringTemplate>();
        for (AnnotationItem annotationItem : annotationSetItem.getAnnotations()) {
            arrayList.add(AnnotationAdaptor.createTemplate(stringTemplateGroup, annotationItem));
        }
        return arrayList;
    }

    private List<MethodItem> getMethodItems() {
        Object object;
        Object object2;
        ArrayList<MethodItem> arrayList = new ArrayList<MethodItem>();
        if (this.encodedMethod.codeItem == null) {
            return arrayList;
        }
        if (baksmali.registerInfo != 0 || baksmali.deodex || baksmali.verify) {
            this.methodAnalyzer.analyze();
            object2 = this.methodAnalyzer.getValidationException();
            if (object2 != null) {
                arrayList.add(new CommentMethodItem(this.stg, String.format("ValidationException: %s", ((Throwable)object2).getMessage()), ((ValidationException)object2).getCodeAddress(), -2.147483648E9));
            } else if (baksmali.verify) {
                this.methodAnalyzer.verify();
                object2 = this.methodAnalyzer.getValidationException();
                if (object2 != null) {
                    arrayList.add(new CommentMethodItem(this.stg, String.format("ValidationException: %s", ((Throwable)object2).getMessage()), ((ValidationException)object2).getCodeAddress(), -2.147483648E9));
                }
            }
        }
        object2 = this.methodAnalyzer.getInstructions();
        AnalyzedInstruction analyzedInstruction = null;
        for (int i = object2.size() - 1; i >= 0; --i) {
            object = (AnalyzedInstruction)object2.get(i);
            if (((AnalyzedInstruction)object).isDead()) continue;
            analyzedInstruction = object;
            break;
        }
        BitSet bitSet = new BitSet(this.registerCount);
        object = new BitSet(this.registerCount);
        int n = 0;
        for (int i = 0; i < object2.size(); ++i) {
            AnalyzedInstruction comparable = (AnalyzedInstruction)object2.get(i);
            InstructionMethodItem instructionMethodItem = InstructionMethodItemFactory.makeInstructionFormatMethodItem(this, this.encodedMethod.codeItem, n, this.stg, comparable.getInstruction(), comparable == analyzedInstruction);
            if (comparable.isDead()) {
                arrayList.add(new CommentedOutMethodItem(this.stg, instructionMethodItem));
            } else {
                arrayList.add(instructionMethodItem);
            }
            if (comparable.getInstruction().getFormat() == Format.UnresolvedNullReference) {
                arrayList.add(new CommentedOutMethodItem(this.stg, InstructionMethodItemFactory.makeInstructionFormatMethodItem(this, this.encodedMethod.codeItem, n, this.stg, comparable.getOriginalInstruction(), false)));
            }
            if (i != object2.size() - 1) {
                arrayList.add(new BlankMethodItem(this.stg, n));
            }
            if (baksmali.addCodeOffsets) {
                arrayList.add(new CommentMethodItem(this.stg, String.format("@%x", n), n, -1000.0));
            }
            if (baksmali.registerInfo != 0 && !comparable.getInstruction().getFormat().variableSizeFormat) {
                String string;
                bitSet.clear();
                ((BitSet)object).clear();
                if ((baksmali.registerInfo & 1) != 0) {
                    bitSet.set(0, this.registerCount);
                    ((BitSet)object).set(0, this.registerCount);
                } else {
                    if ((baksmali.registerInfo & 2) != 0) {
                        bitSet.set(0, this.registerCount);
                    } else {
                        if ((baksmali.registerInfo & 8) != 0) {
                            this.addArgsRegs(bitSet, comparable);
                        }
                        if ((baksmali.registerInfo & 0x20) != 0) {
                            this.addMergeRegs(bitSet, comparable);
                        } else if ((baksmali.registerInfo & 0x40) != 0 && (i == 0 || comparable.isBeginningInstruction())) {
                            this.addParamRegs(bitSet);
                        }
                    }
                    if ((baksmali.registerInfo & 4) != 0) {
                        ((BitSet)object).set(0, this.registerCount);
                    } else if ((baksmali.registerInfo & 0x10) != 0) {
                        this.addDestRegs((BitSet)object, comparable);
                    }
                }
                if ((baksmali.registerInfo & 0x40) != 0) {
                    this.addFullMergeRegs(bitSet, arrayList, this.methodAnalyzer, comparable, n);
                }
                if (!bitSet.isEmpty() && (string = this.getPreInstructionRegisterString(comparable, bitSet)) != null && string.length() > 0) {
                    arrayList.add(new CommentMethodItem(this.stg, string, n, 99.9));
                }
                if (!((BitSet)object).isEmpty() && (string = this.getPostInstructionRegisterString(comparable, (BitSet)object)) != null && string.length() > 0) {
                    arrayList.add(new CommentMethodItem(this.stg, string, n, 100.1));
                }
            }
            n += comparable.getInstruction().getSize(n);
        }
        this.addTries(arrayList);
        this.addDebugInfo(arrayList);
        if (baksmali.useSequentialLabels) {
            this.setLabelSequentialNumbers();
        }
        for (LabelMethodItem labelMethodItem : this.labelCache.getLabels()) {
            if (labelMethodItem.isCommentedOut()) {
                arrayList.add(new CommentedOutMethodItem(this.stg, labelMethodItem));
                continue;
            }
            arrayList.add(labelMethodItem);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    private void addArgsRegs(BitSet bitSet, AnalyzedInstruction analyzedInstruction) {
        if (analyzedInstruction.getInstruction() instanceof RegisterRangeInstruction) {
            RegisterRangeInstruction registerRangeInstruction = (RegisterRangeInstruction)((Object)analyzedInstruction.getInstruction());
            bitSet.set(registerRangeInstruction.getStartRegister(), registerRangeInstruction.getStartRegister() + registerRangeInstruction.getRegCount());
        } else if (analyzedInstruction.getInstruction() instanceof FiveRegisterInstruction) {
            FiveRegisterInstruction fiveRegisterInstruction = (FiveRegisterInstruction)((Object)analyzedInstruction.getInstruction());
            byte by = fiveRegisterInstruction.getRegCount();
            switch (by) {
                case 5: {
                    bitSet.set(fiveRegisterInstruction.getRegisterA());
                }
                case 4: {
                    bitSet.set(fiveRegisterInstruction.getRegisterG());
                }
                case 3: {
                    bitSet.set(fiveRegisterInstruction.getRegisterF());
                }
                case 2: {
                    bitSet.set(fiveRegisterInstruction.getRegisterE());
                }
                case 1: {
                    bitSet.set(fiveRegisterInstruction.getRegisterD());
                }
            }
        } else if (analyzedInstruction.getInstruction() instanceof ThreeRegisterInstruction) {
            ThreeRegisterInstruction threeRegisterInstruction = (ThreeRegisterInstruction)((Object)analyzedInstruction.getInstruction());
            bitSet.set(threeRegisterInstruction.getRegisterA());
            bitSet.set(threeRegisterInstruction.getRegisterB());
            bitSet.set(threeRegisterInstruction.getRegisterC());
        } else if (analyzedInstruction.getInstruction() instanceof TwoRegisterInstruction) {
            TwoRegisterInstruction twoRegisterInstruction = (TwoRegisterInstruction)((Object)analyzedInstruction.getInstruction());
            bitSet.set(twoRegisterInstruction.getRegisterA());
            bitSet.set(twoRegisterInstruction.getRegisterB());
        } else if (analyzedInstruction.getInstruction() instanceof SingleRegisterInstruction) {
            SingleRegisterInstruction singleRegisterInstruction = (SingleRegisterInstruction)((Object)analyzedInstruction.getInstruction());
            bitSet.set(singleRegisterInstruction.getRegisterA());
        }
    }

    private void addFullMergeRegs(BitSet bitSet, List<MethodItem> list, MethodAnalyzer methodAnalyzer, AnalyzedInstruction analyzedInstruction, int n) {
        if (analyzedInstruction.getPredecessorCount() <= 1) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.registerCount; ++i) {
            stringBuffer.setLength(0);
            stringBuffer.append(RegisterFormatter.formatRegister(this.encodedMethod.codeItem, i));
            stringBuffer.append('=');
            stringBuffer.append(analyzedInstruction.getPreInstructionRegisterType(i));
            stringBuffer.append(":merge{");
            RegisterType registerType = null;
            boolean bl = false;
            boolean bl2 = true;
            for (AnalyzedInstruction analyzedInstruction2 : analyzedInstruction.getPredecessors()) {
                RegisterType registerType2 = analyzedInstruction2.getPostInstructionRegisterType(i);
                if (!bl2) {
                    if (!bl) {
                        stringBuffer.append(',');
                        if (registerType != registerType2) {
                            bl = true;
                        }
                        registerType = registerType.merge(registerType2);
                    }
                } else {
                    registerType = registerType2;
                }
                if (analyzedInstruction2.getInstructionIndex() == -1) {
                    stringBuffer.append("Start:");
                } else {
                    stringBuffer.append("0x");
                    stringBuffer.append(Integer.toHexString(methodAnalyzer.getInstructionAddress(analyzedInstruction2)));
                    stringBuffer.append(':');
                }
                stringBuffer.append(registerType2.toString());
                bl2 = false;
            }
            if (!bl) continue;
            stringBuffer.append("}");
            list.add(new CommentMethodItem(this.stg, stringBuffer.toString(), n, 99.8));
            bitSet.clear(i);
        }
    }

    private void addMergeRegs(BitSet bitSet, AnalyzedInstruction analyzedInstruction) {
        if (analyzedInstruction.isBeginningInstruction()) {
            this.addParamRegs(bitSet);
        }
        if (analyzedInstruction.getPredecessorCount() <= 1) {
            return;
        }
        for (int i = 0; i < this.registerCount; ++i) {
            RegisterType registerType = analyzedInstruction.getPreInstructionRegisterType(i);
            for (AnalyzedInstruction analyzedInstruction2 : analyzedInstruction.getPredecessors()) {
                if (analyzedInstruction2.getPostInstructionRegisterType(i) == registerType) continue;
                bitSet.set(i);
            }
        }
    }

    private void addParamRegs(BitSet bitSet) {
        int n = this.encodedMethod.codeItem.getRegisterCount();
        int n2 = this.encodedMethod.method.getPrototype().getParameterRegisterCount();
        if ((this.encodedMethod.accessFlags & AccessFlags.STATIC.getValue()) == 0) {
            ++n2;
        }
        bitSet.set(n - n2, n);
    }

    private void addDestRegs(BitSet bitSet, AnalyzedInstruction analyzedInstruction) {
        for (int i = 0; i < this.registerCount; ++i) {
            if (analyzedInstruction.getPreInstructionRegisterType(i) == analyzedInstruction.getPostInstructionRegisterType(i)) continue;
            bitSet.set(i);
        }
    }

    private String getPreInstructionRegisterString(AnalyzedInstruction analyzedInstruction, BitSet bitSet) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            RegisterType registerType = analyzedInstruction.getPreInstructionRegisterType(n);
            stringBuilder.append(RegisterFormatter.formatRegister(this.encodedMethod.codeItem, n));
            stringBuilder.append("=");
            if (registerType == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append(registerType.toString());
            }
            stringBuilder.append(";");
            n = bitSet.nextSetBit(n + 1);
        }
        return stringBuilder.toString();
    }

    private String getPostInstructionRegisterString(AnalyzedInstruction analyzedInstruction, BitSet bitSet) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            RegisterType registerType = analyzedInstruction.getPostInstructionRegisterType(n);
            stringBuilder.append(RegisterFormatter.formatRegister(this.encodedMethod.codeItem, n));
            stringBuilder.append("=");
            if (registerType == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append(registerType.toString());
            }
            stringBuilder.append(";");
            n = bitSet.nextSetBit(n + 1);
        }
        return stringBuilder.toString();
    }

    private void addTries(List<MethodItem> list) {
        if (this.encodedMethod.codeItem == null || this.encodedMethod.codeItem.getTries() == null) {
            return;
        }
        Instruction[] instructionArray = this.encodedMethod.codeItem.getInstructions();
        for (CodeItem.TryItem tryItem : this.encodedMethod.codeItem.getTries()) {
            int n;
            int n2;
            Instruction instruction;
            int n3 = tryItem.getStartCodeAddress();
            int n4 = tryItem.getStartCodeAddress() + tryItem.getTryLength();
            int n5 = this.instructionMap.get(n4, -1);
            if (n5 == -1) {
                instruction = instructionArray[instructionArray.length - 1];
                n2 = this.instructionMap.keyAt(this.instructionMap.size() - 1);
                if (n4 != n2 + instruction.getSize(n2)) {
                    throw new RuntimeException("Invalid code offset " + n4 + " for the try block end address");
                }
            } else {
                if (n5 == 0) {
                    throw new RuntimeException("Unexpected instruction index");
                }
                instruction = instructionArray[n5 - 1];
                if (instruction.getFormat().variableSizeFormat) {
                    throw new RuntimeException("This try block unexpectedly ends on a switch/array data block.");
                }
                n2 = n4 - instruction.getSize(0);
            }
            if ((n = tryItem.encodedCatchHandler.getCatchAllHandlerAddress()) != -1) {
                CatchMethodItem catchMethodItem = new CatchMethodItem(this.labelCache, n2, this.stg, null, n3, n4, n);
                list.add(catchMethodItem);
            }
            for (CodeItem.EncodedTypeAddrPair encodedTypeAddrPair : tryItem.encodedCatchHandler.handlers) {
                CatchMethodItem catchMethodItem = new CatchMethodItem(this.labelCache, n2, this.stg, encodedTypeAddrPair.exceptionType, n3, n4, encodedTypeAddrPair.getHandlerAddress());
                list.add(catchMethodItem);
            }
        }
    }

    private void addDebugInfo(final List<MethodItem> list) {
        if (this.encodedMethod.codeItem == null || this.encodedMethod.codeItem.getDebugInfo() == null) {
            return;
        }
        final CodeItem codeItem = this.encodedMethod.codeItem;
        DebugInfoItem debugInfoItem = codeItem.getDebugInfo();
        DebugInstructionIterator.DecodeInstructions(debugInfoItem, codeItem.getRegisterCount(), new DebugInstructionIterator.ProcessDecodedDebugInstructionDelegate(){

            @Override
            public void ProcessStartLocal(int n, int n2, int n3, StringIdItem stringIdItem, TypeIdItem typeIdItem) {
                list.add(new LocalDebugMethodItem(codeItem, n, MethodDefinition.this.stg, "StartLocal", -1.0, n3, stringIdItem, typeIdItem, null));
            }

            @Override
            public void ProcessStartLocalExtended(int n, int n2, int n3, StringIdItem stringIdItem, TypeIdItem typeIdItem, StringIdItem stringIdItem2) {
                list.add(new LocalDebugMethodItem(codeItem, n, MethodDefinition.this.stg, "StartLocal", -1.0, n3, stringIdItem, typeIdItem, stringIdItem2));
            }

            @Override
            public void ProcessEndLocal(int n, int n2, int n3, StringIdItem stringIdItem, TypeIdItem typeIdItem, StringIdItem stringIdItem2) {
                list.add(new LocalDebugMethodItem(codeItem, n, MethodDefinition.this.stg, "EndLocal", -1.0, n3, stringIdItem, typeIdItem, stringIdItem2));
            }

            @Override
            public void ProcessRestartLocal(int n, int n2, int n3, StringIdItem stringIdItem, TypeIdItem typeIdItem, StringIdItem stringIdItem2) {
                list.add(new LocalDebugMethodItem(codeItem, n, MethodDefinition.this.stg, "RestartLocal", -1.0, n3, stringIdItem, typeIdItem, stringIdItem2));
            }

            @Override
            public void ProcessSetPrologueEnd(int n) {
                list.add(new DebugMethodItem(n, MethodDefinition.this.stg, "EndPrologue", -4.0));
            }

            @Override
            public void ProcessSetEpilogueBegin(int n) {
                list.add(new DebugMethodItem(n, MethodDefinition.this.stg, "StartEpilogue", -4.0));
            }

            @Override
            public void ProcessSetFile(int n, int n2, final StringIdItem stringIdItem) {
                list.add(new DebugMethodItem(n, MethodDefinition.this.stg, "SetFile", -3.0){

                    @Override
                    protected void setAttributes(StringTemplate stringTemplate) {
                        stringTemplate.setAttribute("FileName", stringIdItem.getStringValue());
                    }
                });
            }

            @Override
            public void ProcessLineEmit(int n, final int n2) {
                list.add(new DebugMethodItem(n, MethodDefinition.this.stg, "Line", -2.0){

                    @Override
                    protected void setAttributes(StringTemplate stringTemplate) {
                        stringTemplate.setAttribute("Line", n2);
                    }
                });
            }
        });
    }

    private void setLabelSequentialNumbers() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        ArrayList<LabelMethodItem> arrayList = new ArrayList<LabelMethodItem>(this.labelCache.getLabels());
        Collections.sort(arrayList);
        for (LabelMethodItem labelMethodItem : arrayList) {
            Integer n = (Integer)hashMap.get(labelMethodItem.getLabelPrefix());
            if (n == null) {
                n = 0;
            }
            labelMethodItem.setLabelSequence(n);
            hashMap.put(labelMethodItem.getLabelPrefix(), n + 1);
        }
    }

    public static class LabelCache {
        protected HashMap<LabelMethodItem, LabelMethodItem> labels = new HashMap();

        public LabelMethodItem internLabel(LabelMethodItem labelMethodItem) {
            LabelMethodItem labelMethodItem2 = this.labels.get(labelMethodItem);
            if (labelMethodItem2 != null) {
                if (!labelMethodItem.isCommentedOut()) {
                    labelMethodItem2.setUncommented();
                }
                return labelMethodItem2;
            }
            this.labels.put(labelMethodItem, labelMethodItem);
            return labelMethodItem;
        }

        public Collection<LabelMethodItem> getLabels() {
            return this.labels.values();
        }
    }
}

