/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors.Format;

import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.jf.baksmali.Adaptors.MethodItem;
import org.jf.baksmali.Adaptors.Reference.Reference;
import org.jf.baksmali.Adaptors.RegisterFormatter;
import org.jf.dexlib.Code.FiveRegisterInstruction;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.InstructionWithReference;
import org.jf.dexlib.Code.LiteralInstruction;
import org.jf.dexlib.Code.OdexedFieldAccess;
import org.jf.dexlib.Code.OdexedInvokeVirtual;
import org.jf.dexlib.Code.RegisterRangeInstruction;
import org.jf.dexlib.Code.SingleRegisterInstruction;
import org.jf.dexlib.Code.ThreeRegisterInstruction;
import org.jf.dexlib.Code.TwoRegisterInstruction;
import org.jf.dexlib.CodeItem;

public class InstructionMethodItem<T extends Instruction>
extends MethodItem {
    protected final CodeItem codeItem;
    protected final StringTemplateGroup stg;
    protected final T instruction;

    public InstructionMethodItem(CodeItem codeItem, int n, StringTemplateGroup stringTemplateGroup, T t) {
        super(n);
        this.codeItem = codeItem;
        this.stg = stringTemplateGroup;
        this.instruction = t;
    }

    @Override
    public double getSortOrder() {
        return 100.0;
    }

    protected String formatRegister(int n) {
        return RegisterFormatter.formatRegister(this.codeItem, n);
    }

    public String toString() {
        StringTemplate stringTemplate = this.stg.getInstanceOf(((Instruction)this.instruction).getFormat().name());
        stringTemplate.setAttribute("Opcode", ((Instruction)this.instruction).opcode.name);
        this.setAttributes(stringTemplate);
        return stringTemplate.toString();
    }

    protected void setAttributes(StringTemplate stringTemplate) {
        if (this.instruction instanceof LiteralInstruction) {
            this.setLiteralAttributes((LiteralInstruction)this.instruction, stringTemplate);
        }
        if (this.instruction instanceof SingleRegisterInstruction) {
            this.setSingleRegisterAttributes((SingleRegisterInstruction)this.instruction, stringTemplate);
        }
        if (this.instruction instanceof FiveRegisterInstruction) {
            this.setFiveRegisterAttributes((FiveRegisterInstruction)this.instruction, stringTemplate);
        }
        if (this.instruction instanceof RegisterRangeInstruction) {
            this.setRegisterRangeAttributes((RegisterRangeInstruction)this.instruction, stringTemplate);
        }
        if (this.instruction instanceof InstructionWithReference) {
            this.setInstructionWithReferenceAttributes((InstructionWithReference)this.instruction, stringTemplate);
        }
        if (this.instruction instanceof OdexedInvokeVirtual) {
            this.setOdexedInvokeVirtualAttributes((OdexedInvokeVirtual)this.instruction, stringTemplate);
        }
        if (this.instruction instanceof OdexedFieldAccess) {
            this.setOdexedFieldAccessAttributes((OdexedFieldAccess)this.instruction, stringTemplate);
        }
    }

    private void setLiteralAttributes(LiteralInstruction literalInstruction, StringTemplate stringTemplate) {
        long l = literalInstruction.getLiteral();
        if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
            stringTemplate.setAttribute("Literal", (int)l);
        } else {
            stringTemplate.setAttribute("Literal", l);
        }
    }

    private void setSingleRegisterAttributes(SingleRegisterInstruction singleRegisterInstruction, StringTemplate stringTemplate) {
        stringTemplate.setAttribute("RegisterA", this.formatRegister(singleRegisterInstruction.getRegisterA()));
        if (singleRegisterInstruction instanceof TwoRegisterInstruction) {
            this.setTwoRegisterAttributes((TwoRegisterInstruction)singleRegisterInstruction, stringTemplate);
        }
    }

    private void setTwoRegisterAttributes(TwoRegisterInstruction twoRegisterInstruction, StringTemplate stringTemplate) {
        stringTemplate.setAttribute("RegisterB", this.formatRegister(twoRegisterInstruction.getRegisterB()));
        if (twoRegisterInstruction instanceof ThreeRegisterInstruction) {
            this.setThreeRegisterAttributes((ThreeRegisterInstruction)twoRegisterInstruction, stringTemplate);
        }
    }

    private void setThreeRegisterAttributes(ThreeRegisterInstruction threeRegisterInstruction, StringTemplate stringTemplate) {
        stringTemplate.setAttribute("RegisterC", this.formatRegister(threeRegisterInstruction.getRegisterC()));
    }

    private void setFiveRegisterAttributes(FiveRegisterInstruction fiveRegisterInstruction, StringTemplate stringTemplate) {
        switch (fiveRegisterInstruction.getRegCount()) {
            case 1: {
                stringTemplate.setAttribute("Registers", this.formatRegister(fiveRegisterInstruction.getRegisterD()));
                return;
            }
            case 2: {
                stringTemplate.setAttribute("Registers", this.formatRegister(fiveRegisterInstruction.getRegisterD()));
                stringTemplate.setAttribute("Registers", this.formatRegister(fiveRegisterInstruction.getRegisterE()));
                return;
            }
            case 3: {
                stringTemplate.setAttribute("Registers", this.formatRegister(fiveRegisterInstruction.getRegisterD()));
                stringTemplate.setAttribute("Registers", this.formatRegister(fiveRegisterInstruction.getRegisterE()));
                stringTemplate.setAttribute("Registers", this.formatRegister(fiveRegisterInstruction.getRegisterF()));
                return;
            }
            case 4: {
                stringTemplate.setAttribute("Registers", this.formatRegister(fiveRegisterInstruction.getRegisterD()));
                stringTemplate.setAttribute("Registers", this.formatRegister(fiveRegisterInstruction.getRegisterE()));
                stringTemplate.setAttribute("Registers", this.formatRegister(fiveRegisterInstruction.getRegisterF()));
                stringTemplate.setAttribute("Registers", this.formatRegister(fiveRegisterInstruction.getRegisterG()));
                return;
            }
            case 5: {
                stringTemplate.setAttribute("Registers", this.formatRegister(fiveRegisterInstruction.getRegisterD()));
                stringTemplate.setAttribute("Registers", this.formatRegister(fiveRegisterInstruction.getRegisterE()));
                stringTemplate.setAttribute("Registers", this.formatRegister(fiveRegisterInstruction.getRegisterF()));
                stringTemplate.setAttribute("Registers", this.formatRegister(fiveRegisterInstruction.getRegisterG()));
                stringTemplate.setAttribute("Registers", this.formatRegister(fiveRegisterInstruction.getRegisterA()));
            }
        }
    }

    private void setRegisterRangeAttributes(RegisterRangeInstruction registerRangeInstruction, StringTemplate stringTemplate) {
        String[] stringArray = RegisterFormatter.formatFormat3rcRegisters(this.codeItem, registerRangeInstruction.getStartRegister(), registerRangeInstruction.getStartRegister() + registerRangeInstruction.getRegCount() - 1);
        stringTemplate.setAttribute("StartRegister", stringArray[0]);
        stringTemplate.setAttribute("LastRegister", stringArray[1]);
    }

    private void setInstructionWithReferenceAttributes(InstructionWithReference instructionWithReference, StringTemplate stringTemplate) {
        stringTemplate.setAttribute("Reference", Reference.createReference(stringTemplate.getGroup(), instructionWithReference.getReferencedItem()));
    }

    private void setOdexedInvokeVirtualAttributes(OdexedInvokeVirtual odexedInvokeVirtual, StringTemplate stringTemplate) {
        stringTemplate.setAttribute("MethodIndex", odexedInvokeVirtual.getMethodIndex());
    }

    private void setOdexedFieldAccessAttributes(OdexedFieldAccess odexedFieldAccess, StringTemplate stringTemplate) {
        stringTemplate.setAttribute("FieldOffset", odexedFieldAccess.getFieldOffset());
    }
}

