/*
 * Decompiled with CFR 0.152.
 */
package brut.util;

import brut.common.BrutException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;

public class OS {
    public static void rmdir(File file) throws BrutException {
        if (!file.exists()) {
            return;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                OS.rmdir(file2);
                continue;
            }
            file2.delete();
        }
        file.delete();
    }

    public static void rmdir(String string) throws BrutException {
        OS.rmdir(new File(string));
    }

    public static void cpdir(File file, File file2) throws BrutException {
        file2.mkdirs();
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file3 = fileArray[i];
            File file4 = new File(file2.getPath() + File.separatorChar + file3.getName());
            if (file3.isDirectory()) {
                OS.cpdir(file3, file4);
                continue;
            }
            try {
                FileInputStream fileInputStream = new FileInputStream(file3);
                FileOutputStream fileOutputStream = new FileOutputStream(file4);
                IOUtils.copy((InputStream)fileInputStream, (OutputStream)fileOutputStream);
                ((InputStream)fileInputStream).close();
                ((OutputStream)fileOutputStream).close();
                continue;
            }
            catch (IOException iOException) {
                throw new BrutException("Could not copy file: " + file3, iOException);
            }
        }
    }

    public static void cpdir(String string, String string2) throws BrutException {
        OS.cpdir(new File(string), new File(string2));
    }

    public static void exec(String[] stringArray) throws BrutException {
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(stringArray);
            if (process.waitFor() != 0) {
                IOUtils.copy(process.getInputStream(), (OutputStream)System.out);
                IOUtils.copy(process.getErrorStream(), (OutputStream)System.out);
                throw new BrutException("could not exec command: " + Arrays.toString(stringArray));
            }
        }
        catch (IOException iOException) {
            throw new BrutException("could not exec command: " + Arrays.toString(stringArray), iOException);
        }
        catch (InterruptedException interruptedException) {
            throw new BrutException("could not exec command: " + Arrays.toString(stringArray), interruptedException);
        }
    }

    public static File createTempDirectory() throws BrutException {
        try {
            File file = File.createTempFile("BRUT", null);
            if (!file.delete()) {
                throw new BrutException("Could not delete tmp file: " + file.getAbsolutePath());
            }
            if (!file.mkdir()) {
                throw new BrutException("Could not create tmp dir: " + file.getAbsolutePath());
            }
            return file;
        }
        catch (IOException iOException) {
            throw new BrutException("Could not create tmp dir", iOException);
        }
    }
}

