/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import brut.androlib.AndrolibException;
import brut.androlib.res.decoder.ResStreamDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;
import org.xmlpull.v1.wrapper.XmlPullParserWrapper;
import org.xmlpull.v1.wrapper.XmlPullWrapperFactory;
import org.xmlpull.v1.wrapper.XmlSerializerWrapper;

public class XmlPullStreamDecoder
implements ResStreamDecoder {
    private final XmlPullParser mParser;
    private final XmlSerializer mSerial;
    private static final Logger LOGGER = Logger.getLogger(XmlPullStreamDecoder.class.getName());

    public XmlPullStreamDecoder(XmlPullParser xmlPullParser, XmlSerializer xmlSerializer) {
        this.mParser = xmlPullParser;
        this.mSerial = xmlSerializer;
    }

    @Override
    public void decode(InputStream inputStream, OutputStream outputStream) throws AndrolibException {
        try {
            XmlPullWrapperFactory xmlPullWrapperFactory = XmlPullWrapperFactory.newInstance();
            XmlPullParserWrapper xmlPullParserWrapper = xmlPullWrapperFactory.newPullParserWrapper(this.mParser);
            XmlSerializerWrapper xmlSerializerWrapper = xmlPullWrapperFactory.newSerializerWrapper(this.mSerial);
            xmlPullParserWrapper.setInput(inputStream, null);
            xmlSerializerWrapper.setOutput(outputStream, null);
            while (xmlPullParserWrapper.nextToken() != 1) {
                xmlSerializerWrapper.event(xmlPullParserWrapper);
            }
            xmlSerializerWrapper.flush();
            inputStream.close();
            outputStream.close();
        }
        catch (XmlPullParserException xmlPullParserException) {
            LOGGER.log(Level.SEVERE, "Could not decode XML", xmlPullParserException);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, "Could not decode XML", iOException);
        }
    }
}

