/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import brut.util.ExtDataInput;
import java.io.IOException;

public class StringBlock {
    private int[] m_stringOffsets;
    private int[] m_strings;
    private int[] m_styleOffsets;
    private int[] m_styles;
    private static final int CHUNK_TYPE = 0x1C0001;

    public static StringBlock read(ExtDataInput extDataInput) throws IOException {
        int n;
        extDataInput.skipCheckInt(0x1C0001);
        int n2 = extDataInput.readInt();
        int n3 = extDataInput.readInt();
        int n4 = extDataInput.readInt();
        extDataInput.readInt();
        int n5 = extDataInput.readInt();
        int n6 = extDataInput.readInt();
        StringBlock stringBlock = new StringBlock();
        stringBlock.m_stringOffsets = extDataInput.readIntArray(n3);
        if (n4 != 0) {
            stringBlock.m_styleOffsets = extDataInput.readIntArray(n4);
        }
        if ((n = (n6 == 0 ? n2 : n6) - n5) % 4 != 0) {
            throw new IOException("String data size is not multiple of 4 (" + n + ").");
        }
        stringBlock.m_strings = extDataInput.readIntArray(n / 4);
        if (n6 != 0) {
            n = n2 - n6;
            if (n % 4 != 0) {
                throw new IOException("Style data size is not multiple of 4 (" + n + ").");
            }
            stringBlock.m_styles = extDataInput.readIntArray(n / 4);
        }
        return stringBlock;
    }

    public int getCount() {
        return this.m_stringOffsets != null ? this.m_stringOffsets.length : 0;
    }

    public String getString(int n) {
        int n2;
        if (n < 0 || this.m_stringOffsets == null || n >= this.m_stringOffsets.length) {
            return null;
        }
        int n3 = this.m_stringOffsets[n];
        StringBuilder stringBuilder = new StringBuilder(n2);
        for (n2 = StringBlock.getShort(this.m_strings, n3); n2 != 0; --n2) {
            stringBuilder.append((char)StringBlock.getShort(this.m_strings, n3 += 2));
        }
        return stringBuilder.toString();
    }

    public CharSequence get(int n) {
        return this.getString(n);
    }

    public String getHTML(int n) {
        String string = this.getString(n);
        if (string == null) {
            return string;
        }
        int[] nArray = this.getStyle(n);
        if (nArray == null) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + 32);
        int n2 = 0;
        while (true) {
            int n3;
            int n4 = -1;
            for (n3 = 0; n3 != nArray.length; n3 += 3) {
                if (nArray[n3 + 1] == -1 || n4 != -1 && nArray[n4 + 1] <= nArray[n3 + 1]) continue;
                n4 = n3;
            }
            n3 = n4 != -1 ? nArray[n4 + 1] : string.length();
            for (int i = 0; i != nArray.length; i += 3) {
                int n5 = nArray[i + 2];
                if (n5 == -1 || n5 >= n3) continue;
                if (n2 <= n5) {
                    stringBuilder.append(string, n2, n5 + 1);
                    n2 = n5 + 1;
                }
                nArray[i + 2] = -1;
                stringBuilder.append('<');
                stringBuilder.append('/');
                stringBuilder.append(this.getString(nArray[i]));
                stringBuilder.append('>');
            }
            if (n2 < n3) {
                stringBuilder.append(string, n2, n3);
                n2 = n3;
            }
            if (n4 == -1) break;
            stringBuilder.append('<');
            stringBuilder.append(this.getString(nArray[n4]));
            stringBuilder.append('>');
            nArray[n4 + 1] = -1;
        }
        return stringBuilder.toString();
    }

    public int find(String string) {
        if (string == null) {
            return -1;
        }
        for (int i = 0; i != this.m_stringOffsets.length; ++i) {
            int n;
            int n2 = this.m_stringOffsets[i];
            int n3 = StringBlock.getShort(this.m_strings, n2);
            if (n3 != string.length()) continue;
            for (n = 0; n != n3 && string.charAt(n) == StringBlock.getShort(this.m_strings, n2 += 2); ++n) {
            }
            if (n != n3) continue;
            return i;
        }
        return -1;
    }

    private StringBlock() {
    }

    private int[] getStyle(int n) {
        int n2;
        if (this.m_styleOffsets == null || this.m_styles == null || n >= this.m_styleOffsets.length) {
            return null;
        }
        int n3 = this.m_styleOffsets[n] / 4;
        int n4 = 0;
        for (n2 = n3; n2 < this.m_styles.length && this.m_styles[n2] != -1; ++n2) {
            ++n4;
        }
        if (n4 == 0 || n4 % 3 != 0) {
            return null;
        }
        int[] nArray = new int[n4];
        n4 = n3;
        n2 = 0;
        while (n4 < this.m_styles.length && this.m_styles[n4] != -1) {
            nArray[n2++] = this.m_styles[n4++];
        }
        return nArray;
    }

    private static final int getShort(int[] nArray, int n) {
        int n2 = nArray[n / 4];
        if (n % 4 / 2 == 0) {
            return n2 & 0xFFFF;
        }
        return n2 >>> 16;
    }
}

