/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data.value;

import brut.androlib.AndrolibException;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.data.value.ResIdValue;
import brut.androlib.res.data.value.ResIntValue;

public class ResReferenceValue
extends ResIntValue {
    private final ResPackage mPackage;
    private final boolean mTheme;

    public ResReferenceValue(ResPackage resPackage, int n) {
        this(resPackage, n, false);
    }

    public ResReferenceValue(ResPackage resPackage, int n, boolean bl) {
        super(n, "reference");
        this.mPackage = resPackage;
        this.mTheme = bl;
    }

    @Override
    public String toResXmlFormat() throws AndrolibException {
        if (this.isNull()) {
            return "@null";
        }
        ResResSpec resResSpec = this.getReferent();
        boolean bl = resResSpec.hasDefaultResource() && resResSpec.getDefaultResource().getValue() instanceof ResIdValue;
        return (this.mTheme ? (char)'?' : '@') + (bl ? "+" : "") + resResSpec.getFullName(this.mPackage, this.mTheme);
    }

    public ResResSpec getReferent() throws AndrolibException {
        return this.mPackage.getResTable().getResSpec(this.getValue());
    }

    public boolean isNull() {
        return this.mValue == 0;
    }
}

