/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data.value;

import brut.androlib.AndrolibException;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.value.ResBagValue;
import brut.androlib.res.data.value.ResReferenceValue;
import brut.androlib.res.data.value.ResScalarValue;
import brut.androlib.res.data.value.ResStringValue;
import brut.androlib.res.data.value.ResXmlSerializable;
import brut.util.Duo;
import java.io.IOException;
import org.xmlpull.v1.XmlSerializer;

public class ResPluralsValue
extends ResBagValue
implements ResXmlSerializable {
    private final String[] mItems;
    public static final int BAG_KEY_PLURALS_START = 0x1000004;
    public static final int BAG_KEY_PLURALS_END = 0x1000009;
    private static final String[] QUANTITY_MAP = new String[]{"other", "zero", "one", "two", "few", "many"};

    ResPluralsValue(ResReferenceValue resReferenceValue, Duo<Integer, ResScalarValue>[] duoArray) {
        super(resReferenceValue);
        this.mItems = new String[6];
        for (int i = 0; i < duoArray.length; ++i) {
            this.mItems[((Integer)duoArray[i].m1).intValue() - 0x1000004] = ((ResStringValue)duoArray[i].m2).toResXmlFormat();
        }
    }

    public ResPluralsValue(ResReferenceValue resReferenceValue, String[] stringArray) {
        super(resReferenceValue);
        this.mItems = stringArray;
    }

    @Override
    public void serializeToXml(XmlSerializer xmlSerializer, ResResource resResource) throws IOException, AndrolibException {
        xmlSerializer.startTag(null, "plurals");
        xmlSerializer.attribute(null, "name", resResource.getResSpec().getName());
        for (int i = 0; i < this.mItems.length; ++i) {
            String string = this.mItems[i];
            if (string == null) continue;
            xmlSerializer.startTag(null, "item");
            xmlSerializer.attribute(null, "quantity", QUANTITY_MAP[i]);
            xmlSerializer.text(string);
            xmlSerializer.endTag(null, "item");
        }
        xmlSerializer.endTag(null, "plurals");
    }
}

