/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data.value;

import brut.androlib.AndrolibException;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.value.ResAttr;
import brut.androlib.res.data.value.ResIntValue;
import brut.androlib.res.data.value.ResReferenceValue;
import brut.androlib.res.data.value.ResScalarValue;
import brut.util.Duo;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.xmlpull.v1.XmlSerializer;

public class ResFlagsAttr
extends ResAttr {
    private final FlagItem[] mItems;
    private FlagItem[] mZeroFlags;
    private FlagItem[] mFlags;

    ResFlagsAttr(ResReferenceValue resReferenceValue, int n, Integer n2, Integer n3, Boolean bl, Duo<ResReferenceValue, ResIntValue>[] duoArray) {
        super(resReferenceValue, n, n2, n3, bl);
        this.mItems = new FlagItem[duoArray.length];
        for (int i = 0; i < duoArray.length; ++i) {
            this.mItems[i] = new FlagItem((ResReferenceValue)duoArray[i].m1, ((ResIntValue)duoArray[i].m2).getValue());
        }
    }

    @Override
    public String convertToResXmlFormat(ResScalarValue resScalarValue) throws AndrolibException {
        if (!(resScalarValue instanceof ResIntValue)) {
            return super.convertToResXmlFormat(resScalarValue);
        }
        this.loadFlags();
        int n = ((ResIntValue)resScalarValue).getValue();
        if (n == 0) {
            return this.renderFlags(this.mZeroFlags);
        }
        FlagItem[] flagItemArray = new FlagItem[this.mFlags.length];
        int[] nArray = new int[this.mFlags.length];
        int n2 = 0;
        for (int i = 0; i < this.mFlags.length; ++i) {
            FlagItem flagItem = this.mFlags[i];
            int n3 = flagItem.flag;
            if ((n & n3) != n3 || this.isSubpartOf(n3, nArray)) continue;
            nArray[n2] = n3;
            flagItemArray[n2++] = flagItem;
        }
        return this.renderFlags(Arrays.copyOf(flagItemArray, n2));
    }

    @Override
    protected void serializeBody(XmlSerializer xmlSerializer, ResResource resResource) throws AndrolibException, IOException {
        for (int i = 0; i < this.mItems.length; ++i) {
            FlagItem flagItem = this.mItems[i];
            xmlSerializer.startTag(null, "flag");
            xmlSerializer.attribute(null, "name", flagItem.getValue());
            xmlSerializer.attribute(null, "value", String.format("0x%08x", flagItem.flag));
            xmlSerializer.endTag(null, "flag");
        }
    }

    private boolean isSubpartOf(int n, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if ((nArray[i] & n) != n) continue;
            return true;
        }
        return false;
    }

    private String renderFlags(FlagItem[] flagItemArray) throws AndrolibException {
        String string = "";
        for (int i = 0; i < flagItemArray.length; ++i) {
            string = string + "|" + flagItemArray[i].getValue();
        }
        if (string.isEmpty()) {
            return string;
        }
        return string.substring(1);
    }

    private void loadFlags() {
        if (this.mFlags != null) {
            return;
        }
        FlagItem[] flagItemArray = new FlagItem[this.mItems.length];
        int n = 0;
        FlagItem[] flagItemArray2 = new FlagItem[this.mItems.length];
        int n2 = 0;
        for (int i = 0; i < this.mItems.length; ++i) {
            FlagItem flagItem = this.mItems[i];
            if (flagItem.flag == 0) {
                flagItemArray[n++] = flagItem;
                continue;
            }
            flagItemArray2[n2++] = flagItem;
        }
        this.mZeroFlags = Arrays.copyOf(flagItemArray, n);
        this.mFlags = Arrays.copyOf(flagItemArray2, n2);
        Arrays.sort(this.mFlags, new Comparator<FlagItem>(){

            @Override
            public int compare(FlagItem flagItem, FlagItem flagItem2) {
                return Integer.valueOf(Integer.bitCount(flagItem2.flag)).compareTo(Integer.bitCount(flagItem.flag));
            }
        });
    }

    private static class FlagItem {
        public final ResReferenceValue ref;
        public final int flag;
        public String value;

        public FlagItem(ResReferenceValue resReferenceValue, int n) {
            this.ref = resReferenceValue;
            this.flag = n;
        }

        public String getValue() throws AndrolibException {
            if (this.value == null) {
                this.value = this.ref.getReferent().getName();
            }
            return this.value;
        }
    }
}

