/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data.value;

import brut.androlib.AndrolibException;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.value.ResAttr;
import brut.androlib.res.data.value.ResIntValue;
import brut.androlib.res.data.value.ResReferenceValue;
import brut.androlib.res.data.value.ResScalarValue;
import brut.util.Duo;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.xmlpull.v1.XmlSerializer;

public class ResEnumAttr
extends ResAttr {
    private final Map<Integer, ResReferenceValue> mItems;
    private final Map<Integer, String> mItemsCache = new HashMap<Integer, String>();

    ResEnumAttr(ResReferenceValue resReferenceValue, int n, Integer n2, Integer n3, Boolean bl, Duo<ResReferenceValue, ResIntValue>[] duoArray) {
        super(resReferenceValue, n, n2, n3, bl);
        this.mItems = new LinkedHashMap<Integer, ResReferenceValue>();
        for (int i = 0; i < duoArray.length; ++i) {
            this.mItems.put(((ResIntValue)duoArray[i].m2).getValue(), (ResReferenceValue)duoArray[i].m1);
        }
    }

    @Override
    public String convertToResXmlFormat(ResScalarValue resScalarValue) throws AndrolibException {
        String string;
        if (resScalarValue instanceof ResIntValue && (string = this.decodeValue(((ResIntValue)resScalarValue).getValue())) != null) {
            return string;
        }
        return super.convertToResXmlFormat(resScalarValue);
    }

    @Override
    protected void serializeBody(XmlSerializer xmlSerializer, ResResource resResource) throws AndrolibException, IOException {
        for (int n : this.mItems.keySet()) {
            xmlSerializer.startTag(null, "enum");
            xmlSerializer.attribute(null, "name", this.decodeValue(n));
            xmlSerializer.attribute(null, "value", String.valueOf(n));
            xmlSerializer.endTag(null, "enum");
        }
    }

    private String decodeValue(int n) throws AndrolibException {
        ResReferenceValue resReferenceValue;
        String string = this.mItemsCache.get(n);
        if (string == null && (resReferenceValue = this.mItems.get(n)) != null) {
            string = resReferenceValue.getReferent().getName();
            this.mItemsCache.put(n, string);
        }
        return string;
    }
}

