/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data;

import brut.androlib.AndrolibException;
import brut.androlib.err.UndefinedResObject;
import brut.androlib.res.data.ResConfig;
import brut.androlib.res.data.ResConfigFlags;
import brut.androlib.res.data.ResID;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.ResTable;
import brut.androlib.res.data.ResType;
import brut.androlib.res.data.ResValuesFile;
import brut.androlib.res.data.value.ResFileValue;
import brut.androlib.res.data.value.ResValue;
import brut.androlib.res.data.value.ResValueFactory;
import brut.androlib.res.data.value.ResXmlSerializable;
import brut.util.Duo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ResPackage {
    private final ResTable mResTable;
    private final int mId;
    private final String mName;
    private final Map<ResID, ResResSpec> mResSpecs = new LinkedHashMap<ResID, ResResSpec>();
    private final Map<ResConfigFlags, ResConfig> mConfigs = new LinkedHashMap<ResConfigFlags, ResConfig>();
    private final Map<String, ResType> mTypes = new LinkedHashMap<String, ResType>();
    private final Set<ResResource> mFiles = new LinkedHashSet<ResResource>();
    private final Map<Duo<ResType, ResConfig>, ResValuesFile> mValuesFiles = new LinkedHashMap<Duo<ResType, ResConfig>, ResValuesFile>();
    private final Set<ResID> mSynthesizedRes = new HashSet<ResID>();
    private ResValueFactory mValueFactory;

    public ResPackage(ResTable resTable, int n, String string) {
        this.mResTable = resTable;
        this.mId = n;
        this.mName = string;
    }

    public List<ResResSpec> listResSpecs() {
        return new ArrayList<ResResSpec>(this.mResSpecs.values());
    }

    public boolean hasResSpec(ResID resID) {
        return this.mResSpecs.containsKey(resID);
    }

    public ResResSpec getResSpec(ResID resID) throws UndefinedResObject {
        ResResSpec resResSpec = this.mResSpecs.get(resID);
        if (resResSpec == null) {
            throw new UndefinedResObject("resource spec: " + resID.toString());
        }
        return resResSpec;
    }

    public List<ResConfig> getConfigs() {
        return new ArrayList<ResConfig>(this.mConfigs.values());
    }

    public boolean hasConfig(ResConfigFlags resConfigFlags) {
        return this.mConfigs.containsKey(resConfigFlags);
    }

    public ResConfig getConfig(ResConfigFlags resConfigFlags) throws AndrolibException {
        ResConfig resConfig = this.mConfigs.get(resConfigFlags);
        if (resConfig == null) {
            throw new UndefinedResObject("config: " + resConfigFlags);
        }
        return resConfig;
    }

    public List<ResType> listTypes() {
        return new ArrayList<ResType>(this.mTypes.values());
    }

    public boolean hasType(String string) {
        return this.mTypes.containsKey(string);
    }

    public ResType getType(String string) throws AndrolibException {
        ResType resType = this.mTypes.get(string);
        if (resType == null) {
            throw new UndefinedResObject("type: " + string);
        }
        return resType;
    }

    public Set<ResResource> listFiles() {
        return this.mFiles;
    }

    public Collection<ResValuesFile> listValuesFiles() {
        return this.mValuesFiles.values();
    }

    public ResTable getResTable() {
        return this.mResTable;
    }

    public int getId() {
        return this.mId;
    }

    public String getName() {
        return this.mName;
    }

    boolean isSynthesized(ResID resID) {
        return this.mSynthesizedRes.contains(resID);
    }

    public void addResSpec(ResResSpec resResSpec) throws AndrolibException {
        if (this.mResSpecs.put(resResSpec.getId(), resResSpec) != null) {
            throw new AndrolibException("Multiple resource specs: " + resResSpec);
        }
    }

    public void addConfig(ResConfig resConfig) throws AndrolibException {
        if (this.mConfigs.put(resConfig.getFlags(), resConfig) != null) {
            throw new AndrolibException("Multiple configs: " + resConfig);
        }
    }

    public void addType(ResType resType) throws AndrolibException {
        if (this.mTypes.put(resType.getName(), resType) != null) {
            throw new AndrolibException("Multiple types: " + resType);
        }
    }

    public void addResource(ResResource resResource) {
        ResValue resValue = resResource.getValue();
        if (resValue instanceof ResFileValue) {
            this.mFiles.add(resResource);
        }
        if (resValue instanceof ResXmlSerializable) {
            ResConfig resConfig;
            ResType resType = resResource.getResSpec().getType();
            Duo<ResType, ResConfig> duo = new Duo<ResType, ResConfig>(resType, resConfig = resResource.getConfig());
            ResValuesFile resValuesFile = this.mValuesFiles.get(duo);
            if (resValuesFile == null) {
                resValuesFile = new ResValuesFile(this, resType, resConfig);
                this.mValuesFiles.put(duo, resValuesFile);
            }
            resValuesFile.addResource(resResource);
        }
    }

    public void addSynthesizedRes(int n) {
        this.mSynthesizedRes.add(new ResID(n));
    }

    public String toString() {
        return this.mName;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ResPackage resPackage = (ResPackage)object;
        if (!(this.mResTable == resPackage.mResTable || this.mResTable != null && this.mResTable.equals(resPackage.mResTable))) {
            return false;
        }
        return this.mId == resPackage.mId;
    }

    public int hashCode() {
        int n = 7;
        n = 37 * n + (this.mResTable != null ? this.mResTable.hashCode() : 0);
        n = 37 * n + this.mId;
        return n;
    }

    public ResValueFactory getValueFactory() {
        if (this.mValueFactory == null) {
            this.mValueFactory = new ResValueFactory(this);
        }
        return this.mValueFactory;
    }
}

