/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data;

import brut.androlib.AndrolibException;
import brut.androlib.err.UndefinedResObject;
import brut.androlib.res.data.ResConfigFlags;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.data.ResResource;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ResConfig {
    private final ResConfigFlags mFlags;
    private final Map<ResResSpec, ResResource> mResources = new LinkedHashMap<ResResSpec, ResResource>();

    public ResConfig(ResConfigFlags resConfigFlags) {
        this.mFlags = resConfigFlags;
    }

    public Set<ResResource> listResources() {
        return new LinkedHashSet<ResResource>(this.mResources.values());
    }

    public ResResource getResource(ResResSpec resResSpec) throws AndrolibException {
        ResResource resResource = this.mResources.get(resResSpec);
        if (resResource == null) {
            throw new UndefinedResObject(String.format("resource: spec=%s, config=%s", resResSpec, this));
        }
        return resResource;
    }

    public Set<ResResSpec> listResSpecs() {
        return this.mResources.keySet();
    }

    public ResConfigFlags getFlags() {
        return this.mFlags;
    }

    public void addResource(ResResource resResource) throws AndrolibException {
        ResResSpec resResSpec = resResource.getResSpec();
        if (this.mResources.put(resResSpec, resResource) != null) {
            throw new AndrolibException(String.format("Multiple resources: spec=%s, config=%s", resResSpec, this));
        }
    }

    public String toString() {
        return this.mFlags.toString();
    }
}

