/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res;

import brut.androlib.AndrolibException;
import brut.androlib.err.UndefinedResObject;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.data.ResTable;
import brut.directory.Directory;
import brut.directory.DirectoryException;
import brut.directory.FileDirectory;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;

public class ResSmaliUpdater {
    private static final String RES_ID_FORMAT_FIELD = ".field %s:I = 0x%08x";
    private static final String RES_ID_FORMAT_CONST = "    const %s, 0x%08x";
    private static final Pattern RES_ID_PATTERN = Pattern.compile("^(?:\\.field (.+?):I =|    const(?:|/(?:|high)16) ([pv]\\d+?),) 0x(7[a-f]0[1-9a-f](?:|[0-9a-f]{4}))$");
    private static final String RES_NAME_FORMAT = "# APKTOOL/RES_NAME: %s";
    private static final Pattern RES_NAME_PATTERN = Pattern.compile("^# APKTOOL/RES_NAME: ([a-zA-Z0-9.]+):([a-z]+)/([a-zA-Z0-9._]+)$");
    private static final Pattern R_FILE_PATTERN = Pattern.compile(".*R\\$[a-z]+\\.smali$");
    private static final Logger LOGGER = Logger.getLogger(ResSmaliUpdater.class.getName());

    public void tagResIDs(ResTable resTable, File file) throws AndrolibException {
        FileDirectory fileDirectory = null;
        try {
            fileDirectory = new FileDirectory(file);
        }
        catch (DirectoryException directoryException) {
            throw new AndrolibException("Could not tag res IDs", directoryException);
        }
        for (String string : fileDirectory.getFiles(true)) {
            try {
                this.tagResIdsForFile(resTable, fileDirectory, string);
            }
            catch (IOException iOException) {
                throw new AndrolibException("Could not tag resIDs for file: " + string, iOException);
            }
            catch (DirectoryException directoryException) {
                throw new AndrolibException("Could not tag resIDs for file: " + string, directoryException);
            }
            catch (AndrolibException androlibException) {
                throw new AndrolibException("Could not tag resIDs for file: " + string, androlibException);
            }
        }
    }

    public void updateResIDs(ResTable resTable, File file) throws AndrolibException {
        try {
            FileDirectory fileDirectory = new FileDirectory(file);
            for (String string : fileDirectory.getFiles(true)) {
                Iterator iterator = IOUtils.readLines(fileDirectory.getFileInput(string)).iterator();
                PrintWriter printWriter = new PrintWriter(fileDirectory.getFileOutput(string));
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    printWriter.println(string2);
                    Matcher matcher = RES_NAME_PATTERN.matcher(string2);
                    if (!matcher.matches()) continue;
                    Matcher matcher2 = RES_ID_PATTERN.matcher((CharSequence)iterator.next());
                    if (!matcher2.matches()) {
                        throw new AndrolibException();
                    }
                    int n = resTable.getPackage((String)matcher.group((int)1)).getType((String)matcher.group((int)2)).getResSpec((String)matcher.group((int)3)).getId().id;
                    if (matcher2.group(1) != null) {
                        printWriter.println(String.format(RES_ID_FORMAT_FIELD, matcher2.group(1), n));
                        continue;
                    }
                    printWriter.println(String.format(RES_ID_FORMAT_CONST, matcher2.group(2), n));
                }
                printWriter.close();
            }
        }
        catch (IOException iOException) {
            throw new AndrolibException("Could not tag res IDs for: " + file.getAbsolutePath(), iOException);
        }
        catch (DirectoryException directoryException) {
            throw new AndrolibException("Could not tag res IDs for: " + file.getAbsolutePath(), directoryException);
        }
    }

    private void tagResIdsForFile(ResTable resTable, Directory directory, String string) throws IOException, DirectoryException, AndrolibException {
        Iterator iterator = IOUtils.readLines(directory.getFileInput(string)).iterator();
        PrintWriter printWriter = new PrintWriter(directory.getFileOutput(string));
        while (iterator.hasNext()) {
            String string2;
            block5: {
                int n;
                string2 = (String)iterator.next();
                if (RES_NAME_PATTERN.matcher(string2).matches()) {
                    printWriter.println(string2);
                    printWriter.println((String)iterator.next());
                    continue;
                }
                Matcher matcher = RES_ID_PATTERN.matcher(string2);
                if (matcher.matches() && (n = this.parseResID(matcher.group(3))) != -1) {
                    try {
                        ResResSpec resResSpec = resTable.getResSpec(n);
                        printWriter.println(String.format(RES_NAME_FORMAT, resResSpec.getFullName()));
                    }
                    catch (UndefinedResObject undefinedResObject) {
                        if (R_FILE_PATTERN.matcher(string).matches()) break block5;
                        LOGGER.warning(String.format("Undefined resource spec in %s: 0x%08x", string, n));
                    }
                }
            }
            printWriter.println(string2);
        }
        printWriter.close();
    }

    private int parseResID(String string) {
        if (string.endsWith("ff")) {
            return -1;
        }
        int n = Integer.valueOf(string, 16);
        if (string.length() == 4) {
            n <<= 16;
        }
        return n;
    }
}

