/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib;

import brut.androlib.AndrolibException;
import brut.androlib.AndrolibSmali;
import brut.androlib.res.AndrolibResources;
import brut.androlib.res.data.ResTable;
import brut.androlib.res.util.ExtFile;
import brut.common.BrutException;
import brut.directory.Directory;
import brut.directory.DirectoryException;
import brut.util.BrutIO;
import brut.util.OS;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Logger;

public class Androlib {
    private final AndrolibResources mAndRes = new AndrolibResources();
    private final AndrolibSmali mSmali = new AndrolibSmali();
    private static final Logger LOGGER = Logger.getLogger(Androlib.class.getName());
    private static final String SMALI_DIRNAME = "smali";
    private static final String APK_DIRNAME = "build/apk";
    private static final String OUT_APK_FILENAME = "dist/out.apk";
    private static final String[] APK_RESOURCES_FILENAMES = new String[]{"resources.arsc", "AndroidManifest.xml", "res"};
    private static final String[] APP_RESOURCES_FILENAMES = new String[]{"AndroidManifest.xml", "res"};

    public ResTable getResTable(ExtFile extFile) throws AndrolibException {
        LOGGER.info("Decoding resource table...");
        return this.mAndRes.getResTable(extFile);
    }

    public void decodeSourcesRaw(ExtFile extFile, File file) throws AndrolibException {
        try {
            Directory directory = extFile.getDirectory();
            if (directory.containsFile("classes.dex")) {
                LOGGER.info("Copying raw classes.dex file...");
                extFile.getDirectory().copyToDir(file, "classes.dex");
            }
        }
        catch (DirectoryException directoryException) {
            throw new AndrolibException(directoryException);
        }
    }

    public void decodeSourcesSmali(File file, File file2) throws AndrolibException {
        try {
            File file3 = new File(file2, SMALI_DIRNAME);
            OS.rmdir(file3);
            file3.mkdirs();
            LOGGER.info("Baksmaling...");
            this.mSmali.baksmali(file, file3);
        }
        catch (BrutException brutException) {
            throw new AndrolibException(brutException);
        }
    }

    public void decodeResourcesRaw(ExtFile extFile, File file) throws AndrolibException {
        try {
            Directory directory = extFile.getDirectory();
            if (directory.containsFile("resources.arsc")) {
                LOGGER.info("Copying raw resources...");
                extFile.getDirectory().copyToDir(file, APK_RESOURCES_FILENAMES);
            }
        }
        catch (DirectoryException directoryException) {
            throw new AndrolibException(directoryException);
        }
    }

    public void decodeResourcesFull(ExtFile extFile, File file, ResTable resTable) throws AndrolibException {
        LOGGER.info("Decoding resources...");
        this.mAndRes.decode(resTable, extFile, file);
    }

    public void decodeRawFiles(ExtFile extFile, File file) throws AndrolibException {
        LOGGER.info("Copying assets and libs...");
        try {
            Directory directory = extFile.getDirectory();
            if (directory.containsDir("assets")) {
                directory.copyToDir(file, "assets");
            }
            if (directory.containsDir("lib")) {
                directory.copyToDir(file, "lib");
            }
        }
        catch (DirectoryException directoryException) {
            throw new AndrolibException(directoryException);
        }
    }

    public void build(File file, boolean bl) throws AndrolibException {
        this.build(new ExtFile(file), bl);
    }

    public void build(ExtFile extFile, boolean bl) throws AndrolibException {
        boolean bl2 = this.mAndRes.detectWhetherAppIsFramework(extFile);
        new File(extFile, APK_DIRNAME).mkdirs();
        this.buildSources(extFile, bl);
        this.buildResources(extFile, bl, bl2);
        this.buildLib(extFile, bl);
        this.buildApk(extFile, bl2);
    }

    public void buildSources(File file, boolean bl) throws AndrolibException {
        if (!this.buildSourcesRaw(file, bl) && !this.buildSourcesSmali(file, bl)) {
            LOGGER.warning("Could not find sources");
        }
    }

    public boolean buildSourcesRaw(File file, boolean bl) throws AndrolibException {
        try {
            File file2 = new File(file, "classes.dex");
            if (!file2.exists()) {
                return false;
            }
            File file3 = new File(file, "build/apk/classes.dex");
            if (bl || this.isModified(file2, file3)) {
                LOGGER.info("Copying classes.dex file...");
                BrutIO.copyAndClose(new FileInputStream(file2), new FileOutputStream(file3));
            }
            return true;
        }
        catch (IOException iOException) {
            throw new AndrolibException(iOException);
        }
    }

    public boolean buildSourcesSmali(File file, boolean bl) throws AndrolibException {
        File file2 = new File(file, SMALI_DIRNAME);
        if (!file2.exists()) {
            return false;
        }
        File file3 = new File(file, "build/apk/classes.dex");
        if (!bl) {
            LOGGER.info("Checking whether sources has changed...");
        }
        if (bl || this.isModified(file2, file3)) {
            LOGGER.info("Smaling...");
            file3.delete();
            this.mSmali.smali(file2, file3);
        }
        return true;
    }

    public void buildResources(ExtFile extFile, boolean bl, boolean bl2) throws AndrolibException {
        if (!this.buildResourcesRaw(extFile, bl) && !this.buildResourcesFull(extFile, bl, bl2)) {
            LOGGER.warning("Could not find resources");
        }
    }

    public boolean buildResourcesRaw(ExtFile extFile, boolean bl) throws AndrolibException {
        try {
            if (!new File(extFile, "resources.arsc").exists()) {
                return false;
            }
            File file = new File(extFile, APK_DIRNAME);
            if (!bl) {
                LOGGER.info("Checking whether resources has changed...");
            }
            if (bl || this.isModified(this.newFiles(APK_RESOURCES_FILENAMES, extFile), this.newFiles(APK_RESOURCES_FILENAMES, file))) {
                LOGGER.info("Copying raw resources");
                extFile.getDirectory().copyToDir(file, APK_RESOURCES_FILENAMES);
            }
            return true;
        }
        catch (DirectoryException directoryException) {
            throw new AndrolibException(directoryException);
        }
    }

    public boolean buildResourcesFull(File file, boolean bl, boolean bl2) throws AndrolibException {
        try {
            if (!new File(file, "res").exists()) {
                return false;
            }
            if (!bl) {
                LOGGER.info("Checking whether resources has changed...");
            }
            File file2 = new File(file, APK_DIRNAME);
            if (bl || this.isModified(this.newFiles(APP_RESOURCES_FILENAMES, file), this.newFiles(APK_RESOURCES_FILENAMES, file2))) {
                LOGGER.info("Building resources...");
                File file3 = File.createTempFile("APKTOOL", null);
                file3.delete();
                File file4 = new File(file, "9patch");
                if (!file4.exists()) {
                    file4 = null;
                }
                this.mAndRes.aaptPackage(file3, new File(file, "AndroidManifest.xml"), new File(file, "res"), file4, null, false, bl2);
                new ExtFile(file3).getDirectory().copyToDir(file2, APK_RESOURCES_FILENAMES);
            }
            return true;
        }
        catch (IOException iOException) {
            throw new AndrolibException(iOException);
        }
        catch (DirectoryException directoryException) {
            throw new AndrolibException(directoryException);
        }
    }

    public void buildLib(File file, boolean bl) throws AndrolibException {
        File file2 = new File(file, "lib");
        if (!file2.exists()) {
            return;
        }
        File file3 = new File(file, "build/apk/lib");
        if (bl || this.isModified(file2, file3)) {
            LOGGER.info("Copying libs...");
            try {
                OS.rmdir(file3);
                OS.cpdir(file2, file3);
            }
            catch (BrutException brutException) {
                throw new AndrolibException(brutException);
            }
        }
    }

    public void buildApk(File file, boolean bl) throws AndrolibException {
        File file2;
        LOGGER.info("Building apk file...");
        File file3 = new File(file, OUT_APK_FILENAME);
        if (file3.exists()) {
            file3.delete();
        } else {
            file2 = file3.getParentFile();
            if (!file2.exists()) {
                file2.mkdirs();
            }
        }
        file2 = new File(file, "assets");
        if (!file2.exists()) {
            file2 = null;
        }
        this.mAndRes.aaptPackage(file3, null, null, new File(file, APK_DIRNAME), file2, false, true);
    }

    private boolean isModified(File file, File file2) {
        if (!file2.exists()) {
            return true;
        }
        return BrutIO.recursiveModifiedTime(file) > BrutIO.recursiveModifiedTime(file2);
    }

    private boolean isModified(File[] fileArray, File[] fileArray2) {
        for (int i = 0; i < fileArray2.length; ++i) {
            if (fileArray2[i].exists()) continue;
            return true;
        }
        return BrutIO.recursiveModifiedTime(fileArray) > BrutIO.recursiveModifiedTime(fileArray2);
    }

    private File[] newFiles(String[] stringArray, File file) {
        File[] fileArray = new File[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            fileArray[i] = new File(file, stringArray[i]);
        }
        return fileArray;
    }
}

