/*
 * Decompiled with CFR 0.152.
 */
package oms.GameEngine;

import android.content.Context;
import android.media.AudioManager;
import oms.GameEngine.GameMedia;
import oms.GameEngine.GameSound;

public class MediaManager {
    public static float MaxVolume = 0.0f;
    public static float SoundVolume = 0.0f;
    public static final int VOLUMEDOWN = 1;
    public static final int VOLUMEUP;
    public static float VolumeInc;
    public static GameMedia _GameMedia;
    public static GameSound _GameSound;
    public static boolean mMediaEnable;
    public static boolean mSoundEnable;
    private Context mContext;

    public MediaManager(Context context) {
        this.mContext = context;
        _GameMedia = null;
        _GameSound = null;
        mSoundEnable = 1;
        mMediaEnable = 1;
        AudioManager audioManager = (AudioManager)this.mContext.getSystemService("audio");
        SoundVolume = audioManager.getStreamVolume(3);
        MaxVolume = audioManager.getStreamMaxVolume(3);
        VolumeInc = MaxVolume / 20.0f;
    }

    public int CH_GetPlayedTime(int n2) {
        return _GameSound.CH_GetPlayedTime(n2);
    }

    public boolean CH_MediaIsPlaying(int n2) {
        return _GameMedia.CH_isPlaying(n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void CH_MediaPause(int n2) {
        if (!mMediaEnable) {
            return;
        }
        _GameMedia.CH_Pause(n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void CH_MediaPlay(int n2, int n3, boolean bl) {
        if (!mMediaEnable) {
            return;
        }
        _GameMedia.CH_Play(n2, n3, bl);
    }

    public void CH_MediaRelease(int n2) {
        _GameMedia.CH_Release(n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void CH_MediaResume(int n2) {
        if (!mMediaEnable) {
            return;
        }
        _GameMedia.CH_Resume(n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void CH_MediaSetLoop(int n2, boolean bl) {
        if (!mMediaEnable) {
            return;
        }
        _GameMedia.CH_SetLoop(n2, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void CH_MediaStop(int n2) {
        if (!mMediaEnable) {
            return;
        }
        _GameMedia.CH_Stop(n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void CH_SoundPause(int n2) {
        if (!mSoundEnable) {
            return;
        }
        _GameSound.CH_Pause(n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void CH_SoundPlay(int n2, int n3) {
        float f2;
        if (!mSoundEnable) {
            return;
        }
        GameSound gameSound = _GameSound;
        float f3 = SoundVolume;
        float f4 = MaxVolume;
        gameSound.volume = f2 = f3 / f4;
        _GameSound.CH_Play(n2, n3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void CH_SoundPlayLoop(int n2, int n3) {
        if (!mSoundEnable) {
            return;
        }
        _GameSound.CH_PlayLoop(n2, n3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void CH_SoundResume(int n2) {
        if (!mSoundEnable) {
            return;
        }
        _GameSound.CH_Resume(n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void CH_SoundSetRate(int n2, float f2) {
        if (!mSoundEnable) {
            return;
        }
        _GameSound.CH_SetRate(n2, f2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void CH_SoundStop(int n2) {
        if (!mSoundEnable) {
            return;
        }
        _GameSound.CH_Stop(n2);
    }

    public boolean GetMediaStatus() {
        return mMediaEnable;
    }

    public int GetPlayedTime(int n2) {
        return _GameSound.GetPlayedTime(n2);
    }

    public boolean GetSoundStatus() {
        return mSoundEnable;
    }

    public void Init(int n2, int n3) {
        Context context = this.mContext;
        GameMedia gameMedia = _GameMedia = new GameMedia(context, n3);
        float f2 = SoundVolume;
        float f3 = MaxVolume;
        float f4 = f2 / f3;
        gameMedia.setAllMediaVolume(f4);
        Context context2 = this.mContext;
        GameSound gameSound = _GameSound = new GameSound(context2, n2);
        float f5 = SoundVolume;
        float f6 = MaxVolume;
        float f7 = f5 / f6;
        gameSound.setAllSoundVolume(f7);
    }

    public void RemoveAll() {
        if (_GameMedia != null) {
            _GameMedia.stopAll();
        }
        if (_GameSound != null) {
            _GameSound.removeAll();
        }
    }

    public void SetMediaEnable(boolean bl) {
        mMediaEnable = bl;
    }

    public void SetSoundEnable(boolean bl) {
        mSoundEnable = bl;
    }

    public void SetSoundStopEn(boolean bl) {
        if (_GameSound != null) {
            _GameSound.SetSoundStopEn(bl);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void SetSystemVolume(int n2) {
        if (n2 == 0) {
            float f2 = SoundVolume;
            float f3 = VolumeInc;
            SoundVolume = f2 + f3;
            float f4 = SoundVolume;
            float f5 = MaxVolume;
            if (f4 >= f5) {
                SoundVolume = MaxVolume;
            }
        } else {
            float f6 = SoundVolume;
            float f7 = VolumeInc;
            if ((SoundVolume = f6 - f7) <= 0.0f) {
                SoundVolume = 0.0f;
            }
        }
        float f8 = SoundVolume;
        this.setAllSoundVolume(f8);
        float f9 = SoundVolume;
        this.setAllMediaVolume(f9);
    }

    public void addLoopSound(int n2) {
        if (_GameSound != null) {
            _GameSound.addLoopSound(n2);
        }
    }

    public void addSound(int n2) {
        if (_GameSound != null) {
            _GameSound.addSound(n2);
        }
    }

    public void clearMediaMap() {
        if (_GameMedia != null) {
            _GameMedia.clearMediaMap();
        }
    }

    public void clearSoundPlayMap() {
    }

    public float getMediaVolume() {
        return SoundVolume;
    }

    public float getSoundVolume() {
        return SoundVolume;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isMediaPlaying(int n2) {
        if (!mMediaEnable) {
            return false;
        }
        if (_GameMedia == null) return false;
        return _GameMedia.isPlaying(n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean mediaLoad(int n2) {
        if (_GameMedia == null) return false;
        return _GameMedia.load(n2);
    }

    public void mediaPause(int n2) {
        if (_GameMedia != null && mMediaEnable) {
            _GameMedia.pause(n2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void mediaPlay(int n2, boolean bl) {
        if (!mMediaEnable) {
            return;
        }
        if (_GameMedia == null) return;
        boolean bl2 = _GameMedia.play(n2, bl);
    }

    public void mediaResume(int n2) {
        if (_GameMedia != null && mMediaEnable) {
            _GameMedia.resume(n2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void mediaStop(int n2) {
        if (!mMediaEnable) {
            return;
        }
        if (_GameMedia == null) return;
        _GameMedia.stop(n2);
    }

    public void mediaStopAll() {
        if (_GameMedia != null) {
            _GameMedia.stopAll();
        }
    }

    public void onPause() {
        if (_GameMedia != null) {
            _GameMedia.pause();
        }
        if (_GameSound != null) {
            _GameSound.pause();
        }
    }

    public void onResume() {
        if (_GameMedia != null && mMediaEnable) {
            _GameMedia.resume();
        }
        if (_GameSound != null && mSoundEnable) {
            _GameSound.resume();
        }
    }

    public void release() {
        if (_GameMedia != null) {
            _GameMedia.release();
        }
        if (_GameSound != null) {
            _GameSound.release();
        }
    }

    public void removeSound(int n2) {
        if (_GameSound != null) {
            _GameSound.removeSound(n2);
        }
    }

    public void setAllMediaVolume(float f2) {
        float f3 = MaxVolume;
        if (f2 >= f3) {
            f2 = MaxVolume;
        }
        SoundVolume = f2;
        AudioManager audioManager = (AudioManager)this.mContext.getSystemService("audio");
        int n2 = (int)f2;
        audioManager.setStreamVolume(3, n2, 1);
        if (_GameMedia != null) {
            GameMedia gameMedia = _GameMedia;
            float f4 = MaxVolume;
            float f5 = f2 / f4;
            gameMedia.setAllMediaVolume(f5);
        }
    }

    public void setAllSoundVolume(float f2) {
        float f3 = MaxVolume;
        if (f2 >= f3) {
            f2 = MaxVolume;
        }
        SoundVolume = f2;
        AudioManager audioManager = (AudioManager)this.mContext.getSystemService("audio");
        int n2 = (int)f2;
        audioManager.setStreamVolume(3, n2, 1);
        if (_GameSound != null) {
            GameSound gameSound = _GameSound;
            float f4 = MaxVolume;
            float f5 = f2 / f4;
            gameSound.setAllSoundVolume(f5);
        }
    }

    public void setAudioStreamType(int n2, int n3) {
        if (_GameMedia != null) {
            _GameMedia.setAudioStreamType(n2, n3);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setMediaLoop(int n2, boolean bl) {
        if (!mMediaEnable) {
            return;
        }
        if (_GameMedia == null) return;
        _GameMedia.setLoop(n2, bl);
    }

    public void setMediaVolume(int n2, float f2) {
        if (_GameMedia != null) {
            GameMedia gameMedia = _GameMedia;
            float f3 = SoundVolume;
            gameMedia.setMediaVolume(n2, f3);
        }
    }

    public void setRate(int n2, float f2) {
        if (_GameSound != null) {
            _GameSound.setRate(n2, f2);
        }
    }

    public void setSoundVolume(int n2, float f2) {
        SoundVolume = f2;
        if (_GameSound != null) {
            _GameSound.setSoundVolume(n2, f2);
        }
    }

    public void soundPause(int n2) {
        if (_GameSound != null && mSoundEnable) {
            _GameSound.pause(n2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void soundPlay(int n2) {
        float f2;
        if (!mSoundEnable) {
            return;
        }
        if (_GameSound == null) return;
        GameSound gameSound = _GameSound;
        float f3 = SoundVolume;
        float f4 = MaxVolume;
        gameSound.volume = f2 = f3 / f4;
        _GameSound.play(n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void soundPlayLoop(int n2) {
        float f2;
        if (!mSoundEnable) {
            return;
        }
        if (_GameSound == null) return;
        GameSound gameSound = _GameSound;
        float f3 = SoundVolume;
        float f4 = MaxVolume;
        gameSound.volume = f2 = f3 / f4;
        _GameSound.playLoop(n2);
    }

    public void soundResume(int n2) {
        if (_GameSound != null && mSoundEnable) {
            _GameSound.resume(n2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void soundStop(int n2) {
        if (!mSoundEnable) {
            return;
        }
        if (_GameSound == null) return;
        _GameSound.stop(n2);
    }
}

