/*
 * Decompiled with CFR 0.152.
 */
package oms.GameEngine;

import oms.GameEngine.GameMath;
import oms.GameEngine.KeyBoard;
import oms.GameEngine.TouchPannel;

public class InputInterface {
    private KeyBoard cKeyBoard;
    private TouchPannel cTouchPannel;
    public boolean nIsPause;
    public int nScreenXOff;
    public int nScreenYOff;

    public InputInterface() {
        TouchPannel touchPannel;
        KeyBoard keyBoard;
        this.cKeyBoard = keyBoard = new KeyBoard();
        this.cTouchPannel = touchPannel = new TouchPannel();
        this.nScreenXOff = 0;
        this.nScreenYOff = 0;
        this.nIsPause = 0;
    }

    public boolean CHKIsTouch() {
        return this.cTouchPannel.CHKIsTouch();
    }

    public boolean CHKSingleKey(int n2) {
        return this.cKeyBoard.CHKSingleKey(n2);
    }

    public boolean CHKSteadyKey(int n2) {
        return this.cKeyBoard.CHKSteadyKey(n2);
    }

    public boolean CHKTouchDown() {
        return this.cTouchPannel.CHKTouchDown();
    }

    public boolean CHKTouchMove() {
        return this.cTouchPannel.CHKTouchMove();
    }

    public boolean CHKTouchUp() {
        return this.cTouchPannel.CHKTouchUp();
    }

    public boolean CHKUpKey(int n2) {
        return this.cKeyBoard.CHKUpKey(n2);
    }

    public void ClearKeyValue() {
        this.cKeyBoard.ClearKeyValue();
    }

    public void ClearTouchDown() {
        this.cTouchPannel.ClearTouchDown();
    }

    public void ClearTouchMove() {
        this.cTouchPannel.ClearTouchMove();
    }

    public void ClearTouchUp() {
        this.cTouchPannel.ClearTouchUp();
    }

    public int GetTouchDownCount() {
        return this.cTouchPannel.GetTouchDownCount();
    }

    public int GetTouchDownX() {
        return this.cTouchPannel.GetTouchDownX();
    }

    public int GetTouchDownX(int n2) {
        return this.cTouchPannel.GetTouchDownX();
    }

    public int GetTouchDownY() {
        return this.cTouchPannel.GetTouchDownY();
    }

    public int GetTouchDownY(int n2) {
        return this.cTouchPannel.GetTouchDownY();
    }

    public boolean GetTouchEn() {
        return this.cTouchPannel.mTouchEn;
    }

    public int GetTouchMoveCount() {
        return this.cTouchPannel.GetTouchMoveCount();
    }

    public int GetTouchMoveX() {
        return this.cTouchPannel.GetTouchMoveX();
    }

    public int GetTouchMoveX(int n2) {
        return this.cTouchPannel.GetTouchMoveX(n2);
    }

    public int GetTouchMoveY() {
        return this.cTouchPannel.GetTouchMoveY();
    }

    public int GetTouchMoveY(int n2) {
        return this.cTouchPannel.GetTouchMoveY(n2);
    }

    public int GetTouchUpCount() {
        return this.cTouchPannel.GetTouchUpCount();
    }

    public int GetTouchUpX() {
        return this.cTouchPannel.GetTouchUpX();
    }

    public int GetTouchUpX(int n2) {
        return this.cTouchPannel.GetTouchUpX();
    }

    public int GetTouchUpY() {
        return this.cTouchPannel.GetTouchUpY();
    }

    public int GetTouchUpY(int n2) {
        return this.cTouchPannel.GetTouchUpY();
    }

    public void ReadKeyBoard() {
        this.cKeyBoard.ReadKeyBoard();
    }

    public void ReadTouch() {
        this.cTouchPannel.ReadTouch();
    }

    public void SetScreenOffset(int n2, int n3) {
        this.nScreenXOff = n2;
        this.nScreenYOff = n3;
    }

    public void SetTouchDown(int n2, int n3) {
        TouchPannel touchPannel = this.cTouchPannel;
        int n4 = this.nScreenXOff;
        int n5 = GameMath.convertToRealX(n2 - n4);
        int n6 = this.nScreenYOff;
        int n7 = GameMath.convertToRealY(n3 - n6);
        touchPannel.SetTouchDown(n5, n7);
    }

    public void SetTouchEn(boolean bl) {
        this.cTouchPannel.mTouchEn = bl;
    }

    public void SetTouchMove(int n2, int n3) {
        TouchPannel touchPannel = this.cTouchPannel;
        int n4 = this.nScreenXOff;
        int n5 = GameMath.convertToRealX(n2 - n4);
        int n6 = this.nScreenYOff;
        int n7 = GameMath.convertToRealY(n3 - n6);
        touchPannel.SetTouchMove(n5, n7);
    }

    public void SetTouchUp(int n2, int n3) {
        TouchPannel touchPannel = this.cTouchPannel;
        int n4 = this.nScreenXOff;
        int n5 = GameMath.convertToRealX(n2 - n4);
        int n6 = this.nScreenYOff;
        int n7 = GameMath.convertToRealY(n3 - n6);
        touchPannel.SetTouchUp(n5, n7);
    }

    public void onKeyDown(int n2) {
        if (!this.nIsPause) {
            this.cKeyBoard.onKeyDown(n2);
        }
    }

    public void onKeyUp(int n2) {
        if (!this.nIsPause) {
            this.cKeyBoard.onKeyUp(n2);
        }
    }
}

