/*
 * Decompiled with CFR 0.152.
 */
package oms.GameEngine;

import android.content.Context;
import android.media.SoundPool;
import android.util.Log;

public class GameSound {
    public static final int PLAY_LOOP = 1;
    public static final int PLAY_ONCE;
    public boolean SoundStopEn = 1;
    public CSoundPlay[] cSoundPlay;
    public int mChannelMax;
    public Context mContext;
    public int mCurLoadSoundNum;
    public int[] mPlayChannel;
    public SoundPool soundPool;
    public float volume = 1.0f;

    public GameSound(Context context, int n2) {
        SoundPool soundPool;
        this.mContext = context;
        int n3 = n2 + 1;
        this.soundPool = soundPool = new SoundPool(n3, 3, 0);
        this.mChannelMax = n2;
        int[] nArray = new int[n2];
        this.mPlayChannel = nArray;
        CSoundPlay[] cSoundPlayArray = new CSoundPlay[n2];
        this.cSoundPlay = cSoundPlayArray;
        int n4 = 0;
        while (true) {
            CSoundPlay cSoundPlay;
            if (n4 >= n2) {
                this.mCurLoadSoundNum = 0;
                return;
            }
            this.mPlayChannel[n4] = -1;
            CSoundPlay[] cSoundPlayArray2 = this.cSoundPlay;
            cSoundPlayArray2[n4] = cSoundPlay = new CSoundPlay();
            ++n4;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int GetMapIdx(int n2) {
        int n3 = 0;
        int n4;
        while (n3 < (n4 = this.mChannelMax)) {
            if (this.cSoundPlay[n3].nResID == n2) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int CH_GetPlayedTime(int n2) {
        int n3 = this.mPlayChannel[n2];
        int n4 = this.GetMapIdx(n3);
        if (n4 != -1) return this.cSoundPlay[n4].GetPlayedTime();
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void CH_Pause(int n2) {
        int n3 = this.mChannelMax;
        if (n2 > n3) {
            return;
        }
        if (this.mPlayChannel[n2] == -1) return;
        int n4 = this.mPlayChannel[n2];
        this.pause(n4);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void CH_Play(int n2, int n3) {
        int n4;
        int n5 = this.mChannelMax;
        if (n2 > n5) {
            return;
        }
        int n6 = this.GetMapIdx(n3);
        if (n6 == -1) return;
        if (this.mPlayChannel[n2] != -1) {
            int n7 = this.mPlayChannel[n2];
            int n8 = this.GetMapIdx(n7);
            if (this.SoundStopEn && this.cSoundPlay[n8].nSteamID != -1) {
                SoundPool soundPool = this.soundPool;
                int n9 = this.cSoundPlay[n8].nSteamID;
                soundPool.stop(n9);
                SoundPool soundPool2 = this.soundPool;
                int n10 = this.cSoundPlay[n8].nSteamID;
                soundPool2.setVolume(n10, 0.0f, 0.0f);
                SoundPool soundPool3 = this.soundPool;
                int n11 = this.cSoundPlay[n8].nSteamID;
                soundPool3.setLoop(n11, -1);
                this.cSoundPlay[n8].nPlaying = 0;
            }
        }
        SoundPool soundPool = this.soundPool;
        int n12 = this.cSoundPlay[n6].nLoadedID;
        float f2 = this.volume;
        float f3 = this.volume;
        int n13 = 0;
        this.cSoundPlay[n6].nSteamID = n4 = soundPool.play(n12, f2, f3, 0, n13, 1.0f);
        this.cSoundPlay[n6].nLoop = 0;
        this.cSoundPlay[n6].nPlaying = 1;
        this.cSoundPlay[n6].Start();
        this.soundPool.setLoop(n4, 0);
        this.mPlayChannel[n2] = n3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void CH_PlayLoop(int n2, int n3) {
        int n4;
        int n5 = this.mChannelMax;
        if (n2 > n5) {
            return;
        }
        int n6 = this.GetMapIdx(n3);
        if (n6 == -1) return;
        if (this.mPlayChannel[n2] != -1) {
            int n7 = this.mPlayChannel[n2];
            int n8 = this.GetMapIdx(n7);
            if (this.SoundStopEn && this.cSoundPlay[n8].nSteamID != -1) {
                SoundPool soundPool = this.soundPool;
                int n9 = this.cSoundPlay[n8].nSteamID;
                soundPool.stop(n9);
                SoundPool soundPool2 = this.soundPool;
                int n10 = this.cSoundPlay[n8].nSteamID;
                soundPool2.setVolume(n10, 0.0f, 0.0f);
                SoundPool soundPool3 = this.soundPool;
                int n11 = this.cSoundPlay[n8].nSteamID;
                soundPool3.setLoop(n11, -1);
                this.cSoundPlay[n8].nPlaying = 0;
            }
        }
        SoundPool soundPool = this.soundPool;
        int n12 = this.cSoundPlay[n6].nLoadedID;
        float f2 = this.volume;
        float f3 = this.volume;
        this.cSoundPlay[n6].nSteamID = n4 = soundPool.play(n12, f2, f3, 0, -1, 1.0f);
        this.cSoundPlay[n6].nLoop = 1;
        this.cSoundPlay[n6].nPlaying = 1;
        this.cSoundPlay[n6].Start();
        this.soundPool.setLoop(n4, -1);
        this.mPlayChannel[n2] = n3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void CH_Resume(int n2) {
        int n3 = this.mChannelMax;
        if (n2 > n3) {
            return;
        }
        if (this.mPlayChannel[n2] == -1) return;
        int n4 = this.mPlayChannel[n2];
        this.resume(n4);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void CH_SetRate(int n2, float f2) {
        int n3 = this.mChannelMax;
        if (n2 > n3) {
            return;
        }
        if (this.mPlayChannel[n2] == -1) return;
        int n4 = this.mPlayChannel[n2];
        this.setRate(n4, f2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void CH_Stop(int n2) {
        int n3 = this.mChannelMax;
        if (n2 > n3) {
            return;
        }
        if (this.mPlayChannel[n2] == -1) return;
        int n4 = this.mPlayChannel[n2];
        this.stop(n4);
        this.mPlayChannel[n2] = -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int GetPlayedTime(int n2) {
        int n3 = this.GetMapIdx(n2);
        if (n3 != -1) return this.cSoundPlay[n3].GetPlayedTime();
        return 0;
    }

    public void SetSoundStopEn(boolean bl) {
        this.SoundStopEn = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addLoopSound(int n2) {
        int n3;
        int n4 = this.mCurLoadSoundNum;
        int n5 = this.mChannelMax;
        if (n4 >= n5) {
            return;
        }
        if (this.GetMapIdx(n2) != -1) return;
        SoundPool soundPool = this.soundPool;
        Context context = this.mContext;
        int n6 = soundPool.load(context, n2, 1);
        CSoundPlay[] cSoundPlayArray = this.cSoundPlay;
        int n7 = this.mCurLoadSoundNum;
        cSoundPlayArray[n7].nResID = n2;
        CSoundPlay[] cSoundPlayArray2 = this.cSoundPlay;
        int n8 = this.mCurLoadSoundNum;
        cSoundPlayArray2[n8].nLoadedID = n6;
        CSoundPlay[] cSoundPlayArray3 = this.cSoundPlay;
        int n9 = this.mCurLoadSoundNum;
        this.mCurLoadSoundNum = n3 = n9 + 1;
        cSoundPlayArray3[n9].nLoop = 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addSound(int n2) {
        int n3;
        int n4 = this.mCurLoadSoundNum;
        int n5 = this.mChannelMax;
        if (n4 >= n5) {
            return;
        }
        if (this.GetMapIdx(n2) != -1) return;
        SoundPool soundPool = this.soundPool;
        Context context = this.mContext;
        int n6 = soundPool.load(context, n2, 1);
        CSoundPlay[] cSoundPlayArray = this.cSoundPlay;
        int n7 = this.mCurLoadSoundNum;
        cSoundPlayArray[n7].nResID = n2;
        CSoundPlay[] cSoundPlayArray2 = this.cSoundPlay;
        int n8 = this.mCurLoadSoundNum;
        cSoundPlayArray2[n8].nLoadedID = n6;
        CSoundPlay[] cSoundPlayArray3 = this.cSoundPlay;
        int n9 = this.mCurLoadSoundNum;
        this.mCurLoadSoundNum = n3 = n9 + 1;
        cSoundPlayArray3[n9].nLoop = 0;
    }

    public float getVolume() {
        return this.volume;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    public void pause() {
        int n2 = 0;
        int n3;
        block0: while (n2 < (n3 = this.mCurLoadSoundNum)) {
            boolean bl = true;
            while (true) {
                int n4;
                block8: {
                    block7: {
                        block6: {
                            if (!bl || (bl = false)) break block6;
                            if (this.cSoundPlay[n2].nSteamID == -1) break block7;
                            SoundPool soundPool = this.soundPool;
                            int n5 = this.cSoundPlay[n2].nSteamID;
                            soundPool.setLoop(n5, 0);
                            this.cSoundPlay[n2].nPlaying = 0;
                            this.cSoundPlay[n2].Pause();
                            n4 = 0;
                        }
                        if (n4 < 50) break block8;
                    }
                    ++n2;
                    continue block0;
                }
                SoundPool soundPool = this.soundPool;
                int n6 = this.cSoundPlay[n2].nSteamID;
                soundPool.pause(n6);
                ++n4;
            }
            break;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void pause(int n2) {
        int n3 = this.GetMapIdx(n2);
        if (n3 == -1) {
            return;
        }
        if (!this.cSoundPlay[n3].nPlaying) return;
        SoundPool soundPool = this.soundPool;
        int n4 = this.cSoundPlay[n3].nSteamID;
        soundPool.setLoop(n4, 0);
        this.cSoundPlay[n3].nPlaying = 0;
        SoundPool soundPool2 = this.soundPool;
        int n5 = this.cSoundPlay[n3].nSteamID;
        soundPool2.pause(n5);
        this.cSoundPlay[n3].Pause();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void play(int n2) {
        int n3;
        int n4 = this.GetMapIdx(n2);
        if (n4 == -1) {
            return;
        }
        if (this.SoundStopEn && this.cSoundPlay[n4].nSteamID != -1) {
            SoundPool soundPool = this.soundPool;
            int n5 = this.cSoundPlay[n4].nSteamID;
            soundPool.stop(n5);
            SoundPool soundPool2 = this.soundPool;
            int n6 = this.cSoundPlay[n4].nSteamID;
            soundPool2.setVolume(n6, 0.0f, 0.0f);
            SoundPool soundPool3 = this.soundPool;
            int n7 = this.cSoundPlay[n4].nSteamID;
            soundPool3.setLoop(n7, -1);
            this.cSoundPlay[n4].nPlaying = 0;
        }
        SoundPool soundPool = this.soundPool;
        int n8 = this.cSoundPlay[n4].nLoadedID;
        float f2 = this.volume;
        float f3 = this.volume;
        int n9 = 0;
        this.cSoundPlay[n4].nSteamID = n3 = soundPool.play(n8, f2, f3, 0, n9, 1.0f);
        this.cSoundPlay[n4].nLoop = 0;
        this.cSoundPlay[n4].nPlaying = 1;
        this.cSoundPlay[n4].Start();
        this.soundPool.setLoop(n3, 0);
        String string2 = "Cur Stream ID=" + n3;
        int n10 = Log.v((String)"SoundPool", (String)string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void playLoop(int n2) {
        int n3;
        int n4 = this.GetMapIdx(n2);
        if (n4 == -1) {
            return;
        }
        if (this.SoundStopEn && this.cSoundPlay[n4].nSteamID != -1) {
            SoundPool soundPool = this.soundPool;
            int n5 = this.cSoundPlay[n4].nSteamID;
            soundPool.stop(n5);
            SoundPool soundPool2 = this.soundPool;
            int n6 = this.cSoundPlay[n4].nSteamID;
            soundPool2.setVolume(n6, 0.0f, 0.0f);
            SoundPool soundPool3 = this.soundPool;
            int n7 = this.cSoundPlay[n4].nSteamID;
            soundPool3.setLoop(n7, -1);
            this.cSoundPlay[n4].nPlaying = 0;
        }
        SoundPool soundPool = this.soundPool;
        int n8 = this.cSoundPlay[n4].nLoadedID;
        float f2 = this.volume;
        float f3 = this.volume;
        this.cSoundPlay[n4].nSteamID = n3 = soundPool.play(n8, f2, f3, 0, -1, 1.0f);
        this.cSoundPlay[n4].nLoop = 1;
        this.cSoundPlay[n4].nPlaying = 1;
        this.cSoundPlay[n4].Start();
        this.soundPool.setLoop(n3, -1);
    }

    public void release() {
        int n2 = 0;
        while (true) {
            int n3;
            if (n2 >= (n3 = this.mChannelMax)) {
                this.soundPool.release();
                this.soundPool = null;
                this.mCurLoadSoundNum = 0;
                return;
            }
            if (this.cSoundPlay[n2].nSteamID != -1 && this.cSoundPlay[n2].nLoop) {
                SoundPool soundPool = this.soundPool;
                int n4 = this.cSoundPlay[n2].nSteamID;
                soundPool.stop(n4);
                SoundPool soundPool2 = this.soundPool;
                int n5 = this.cSoundPlay[n2].nSteamID;
                soundPool2.setLoop(n5, 0);
                SoundPool soundPool3 = this.soundPool;
                int n6 = this.cSoundPlay[n2].nSteamID;
                boolean bl = soundPool3.unload(n6);
                this.cSoundPlay[n2].nLoop = 0;
            }
            this.cSoundPlay[n2].nSteamID = -1;
            this.cSoundPlay[n2].nResID = -1;
            this.mPlayChannel[n2] = -1;
            this.cSoundPlay[n2].nPlaying = 0;
            ++n2;
        }
    }

    public void removeAll() {
        int n2 = 0;
        while (true) {
            int n3;
            if (n2 >= (n3 = this.mChannelMax)) {
                this.mCurLoadSoundNum = 0;
                return;
            }
            if (this.cSoundPlay[n2].nSteamID != -1 && this.cSoundPlay[n2].nLoop) {
                SoundPool soundPool = this.soundPool;
                int n4 = this.cSoundPlay[n2].nSteamID;
                soundPool.stop(n4);
                SoundPool soundPool2 = this.soundPool;
                int n5 = this.cSoundPlay[n2].nSteamID;
                soundPool2.setLoop(n5, 0);
                SoundPool soundPool3 = this.soundPool;
                int n6 = this.cSoundPlay[n2].nSteamID;
                boolean bl = soundPool3.unload(n6);
                this.cSoundPlay[n2].nLoop = 0;
            }
            this.cSoundPlay[n2].nSteamID = -1;
            this.cSoundPlay[n2].nResID = -1;
            this.mPlayChannel[n2] = -1;
            this.cSoundPlay[n2].nPlaying = 0;
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void removeSound(int n2) {
        int n3;
        int n4 = this.GetMapIdx(n2);
        if (n4 == -1) {
            return;
        }
        int n5 = this.cSoundPlay[n4].nLoadedID;
        if (n5 == -1) return;
        if (this.cSoundPlay[n4].nLoop) {
            SoundPool soundPool = this.soundPool;
            int n6 = this.cSoundPlay[n4].nSteamID;
            soundPool.stop(n6);
        }
        boolean bl = this.soundPool.unload(n5);
        this.cSoundPlay[n4].nLoadedID = -1;
        this.cSoundPlay[n4].nResID = -1;
        this.cSoundPlay[n4].nLoop = 0;
        this.cSoundPlay[n4].nSteamID = -1;
        if (this.mCurLoadSoundNum <= 0) return;
        this.mCurLoadSoundNum = n3 = this.mCurLoadSoundNum - 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void resume() {
        int n2 = 0;
        int n3;
        while (n2 < (n3 = this.mCurLoadSoundNum)) {
            if (this.cSoundPlay[n2].nLoop) {
                SoundPool soundPool = this.soundPool;
                int n4 = this.cSoundPlay[n2].nSteamID;
                soundPool.setLoop(n4, -1);
                SoundPool soundPool2 = this.soundPool;
                int n5 = this.cSoundPlay[n2].nSteamID;
                soundPool2.resume(n5);
                this.cSoundPlay[n2].nPlaying = 1;
                this.cSoundPlay[n2].Resume();
            } else if (this.cSoundPlay[n2].GetPlayedTime() < 1000 && this.cSoundPlay[n2].nSteamID != -1) {
                SoundPool soundPool = this.soundPool;
                int n6 = this.cSoundPlay[n2].nSteamID;
                soundPool.resume(n6);
                this.cSoundPlay[n2].Resume();
                this.cSoundPlay[n2].nPlaying = 1;
            }
            ++n2;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void resume(int n2) {
        int n3 = this.GetMapIdx(n2);
        if (n3 == -1) {
            return;
        }
        if (this.cSoundPlay[n3].nSteamID == -1) return;
        if (this.cSoundPlay[n3].nPlaying) return;
        if (this.cSoundPlay[n3].nLoop) {
            SoundPool soundPool = this.soundPool;
            int n4 = this.cSoundPlay[n3].nSteamID;
            soundPool.setLoop(n4, -1);
        }
        SoundPool soundPool = this.soundPool;
        int n5 = this.cSoundPlay[n3].nSteamID;
        soundPool.resume(n5);
        this.cSoundPlay[n3].Resume();
        this.cSoundPlay[n3].nPlaying = 1;
    }

    public void setAllSoundVolume(float f2) {
        this.volume = f2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setRate(int n2, float f2) {
        int n3 = this.GetMapIdx(n2);
        if (n3 == -1) {
            return;
        }
        if ((double)f2 < 0.5) {
            f2 = 0.5f;
        } else if ((double)f2 > 2.0) {
            f2 = 2.0f;
        }
        SoundPool soundPool = this.soundPool;
        int n4 = this.cSoundPlay[n3].nSteamID;
        soundPool.setRate(n4, f2);
    }

    public void setSoundVolume(int n2, float f2) {
        this.volume = f2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void stop(int n2) {
        if (!this.SoundStopEn) {
            return;
        }
        int n3 = this.GetMapIdx(n2);
        if (n3 == -1) return;
        SoundPool soundPool = this.soundPool;
        int n4 = this.cSoundPlay[n3].nSteamID;
        soundPool.setLoop(n4, 0);
        SoundPool soundPool2 = this.soundPool;
        int n5 = this.cSoundPlay[n3].nSteamID;
        soundPool2.stop(n5);
        this.cSoundPlay[n3].nSteamID = -1;
        this.cSoundPlay[n3].nLoop = 0;
        this.cSoundPlay[n3].nPlaying = 0;
        this.cSoundPlay[n3].Stop();
    }

    class CSoundPlay {
        public int nLoadedID;
        public boolean nLoop;
        public long nPlayStart;
        public int nPlayedTime;
        public boolean nPlaying;
        public int nResID;
        public int nSteamID;

        public CSoundPlay() {
            this.Reset();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int GetPlayedTime() {
            long l2;
            if (this.nPlayedTime != 0) return this.nPlayedTime;
            long l3 = System.currentTimeMillis();
            if (l3 < (l2 = this.nPlayStart)) {
                l3 += 86400000L;
            }
            long l4 = this.nPlayStart;
            return (int)(l3 - l4);
        }

        public void Pause() {
            int n2;
            long l2;
            long l3 = System.currentTimeMillis();
            if (l3 < (l2 = this.nPlayStart)) {
                l3 += 86400000L;
            }
            long l4 = this.nPlayStart;
            this.nPlayedTime = n2 = (int)(l3 - l4);
        }

        public void Reset() {
            this.nResID = 1;
            this.nSteamID = -1;
            this.nLoadedID = -1;
            this.nLoop = 0;
            this.nPlaying = 0;
            this.nPlayedTime = 0;
            this.nPlayStart = 0L;
        }

        public void Resume() {
            long l2;
            long l3;
            long l4 = System.currentTimeMillis();
            if (l4 < (l3 = (long)this.nPlayedTime)) {
                l4 += 86400000L;
            }
            long l5 = this.nPlayedTime;
            this.nPlayStart = l2 = l4 - l5;
            this.nPlayedTime = 0;
        }

        public void Start() {
            long l2;
            this.nPlayStart = l2 = System.currentTimeMillis();
            this.nPlayedTime = 0;
        }

        public void Stop() {
            this.nPlayStart = 0L;
            this.nPlayedTime = 0;
        }
    }
}

