/*
 * Decompiled with CFR 0.152.
 */
package oms.GameEngine;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.MediaPlayer;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.HashMap;

public class GameMedia {
    public static final int PLAY_LOOP = 1;
    public static final int PLAY_ONCE;
    private int SOUNDCHANNEL = 0;
    private HashMap<Integer, Integer> gameMediaMap;
    private int loadStreamNum;
    private Context mContext;
    private int[] mPlayChannel;
    private int[] mSavePlayPos;
    private int maxStream;
    private MediaPlayer[] mediaPlayer;
    public float volume;

    public GameMedia(Context context, int n2) {
        this.mContext = context;
        this.maxStream = n2;
        HashMap hashMap = new HashMap();
        this.gameMediaMap = hashMap;
        int n3 = this.maxStream;
        int n4 = this.SOUNDCHANNEL;
        MediaPlayer[] mediaPlayerArray = new MediaPlayer[n3 + n4];
        this.mediaPlayer = mediaPlayerArray;
        int n5 = this.maxStream;
        int n6 = this.SOUNDCHANNEL;
        int[] nArray = new int[n5 + n6];
        this.mPlayChannel = nArray;
        int n7 = this.maxStream;
        int n8 = this.SOUNDCHANNEL;
        int[] nArray2 = new int[n7 + n8];
        this.mSavePlayPos = nArray2;
        int n9 = 0;
        while (true) {
            MediaPlayer mediaPlayer;
            int n10;
            int n11;
            int n12;
            if (n9 >= (n12 = (n11 = this.maxStream) + (n10 = this.SOUNDCHANNEL))) {
                this.loadStreamNum = 0;
                this.volume = 1.0f;
                return;
            }
            MediaPlayer[] mediaPlayerArray2 = this.mediaPlayer;
            mediaPlayerArray2[n9] = mediaPlayer = new MediaPlayer();
            this.mSavePlayPos[n9] = -1;
            this.mPlayChannel[n9] = -1;
            ++n9;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void CH_Pause(int n2) {
        int n3 = this.maxStream;
        if (n2 >= n3) {
            return;
        }
        if (this.mPlayChannel[n2] == -1) return;
        int n4 = this.mPlayChannel[n2];
        this.pause(n4);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void CH_Play(int n2, int n3, boolean bl) {
        int n4 = this.maxStream;
        if (n2 >= n4) {
            return;
        }
        this.CH_Stop(n2);
        if (!this.play(n3, bl)) return;
        this.mPlayChannel[n2] = n3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void CH_Release(int n2) {
        int n3 = this.maxStream;
        if (n2 >= n3) {
            return;
        }
        if (this.mPlayChannel[n2] == -1) return;
        int n4 = this.mPlayChannel[n2];
        this.release(n4);
        this.mPlayChannel[n2] = -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void CH_Resume(int n2) {
        int n3 = this.maxStream;
        if (n2 >= n3) {
            return;
        }
        if (this.mPlayChannel[n2] == -1) return;
        int n4 = this.mPlayChannel[n2];
        this.resume(n4);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void CH_SetLoop(int n2, boolean bl) {
        int n3 = this.maxStream;
        if (n2 >= n3) {
            return;
        }
        if (this.mPlayChannel[n2] == -1) return;
        int n4 = this.mPlayChannel[n2];
        this.setLoop(n4, bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void CH_Stop(int n2) {
        int n3 = this.maxStream;
        if (n2 >= n3) {
            return;
        }
        if (this.mPlayChannel[n2] == -1) return;
        int n4 = this.mPlayChannel[n2];
        this.stop(n4);
        this.mPlayChannel[n2] = -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean CH_isPlaying(int n2) {
        int n3 = this.maxStream;
        if (n2 >= n3) {
            return false;
        }
        if (this.mPlayChannel[n2] == -1) return false;
        int n4 = this.mPlayChannel[n2];
        return this.isPlaying(n4);
    }

    public void clearMediaMap() {
        this.gameMediaMap.clear();
        this.loadStreamNum = 0;
    }

    public float getVolume() {
        return this.volume;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isPlaying(int n2) {
        int n3;
        if (this.gameMediaMap.isEmpty()) {
            return false;
        }
        HashMap<Integer, Integer> hashMap = this.gameMediaMap;
        Integer n4 = n2;
        int n5 = hashMap.get(n4);
        if (n5 >= (n3 = this.maxStream)) {
            return false;
        }
        if (n5 == 0) return false;
        MediaPlayer[] mediaPlayerArray = this.mediaPlayer;
        int n6 = n5 - 1;
        return mediaPlayerArray[n6].isPlaying();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean load(int n2) {
        int n3;
        int n4 = this.loadStreamNum;
        int n5 = this.maxStream;
        if (n4 >= n5) {
            return false;
        }
        AssetFileDescriptor assetFileDescriptor = this.mContext.getResources().openRawResourceFd(n2);
        if (assetFileDescriptor == null) {
            return false;
        }
        try {
            MediaPlayer[] mediaPlayerArray = this.mediaPlayer;
            int n6 = this.loadStreamNum;
            MediaPlayer mediaPlayer = mediaPlayerArray[n6];
            FileDescriptor fileDescriptor = assetFileDescriptor.getFileDescriptor();
            long l2 = assetFileDescriptor.getStartOffset();
            long l3 = assetFileDescriptor.getLength();
            mediaPlayer.setDataSource(fileDescriptor, l2, l3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            assetFileDescriptor.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            MediaPlayer[] mediaPlayerArray = this.mediaPlayer;
            int n7 = this.loadStreamNum;
            mediaPlayerArray[n7].prepare();
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        HashMap<Integer, Integer> hashMap = this.gameMediaMap;
        Integer n8 = n2;
        Integer n9 = this.loadStreamNum + 1;
        Integer n10 = hashMap.put(n8, n9);
        this.loadStreamNum = n3 = this.loadStreamNum + 1;
        return true;
    }

    public void pause() {
        int n2 = this.gameMediaMap.size();
        int n3 = 0;
        while (n3 < n2) {
            if (this.mediaPlayer[n3] != false && this.mediaPlayer[n3].isPlaying()) {
                int n4;
                this.mediaPlayer[n3].pause();
                int[] nArray = this.mSavePlayPos;
                nArray[n3] = n4 = this.mediaPlayer[n3].getCurrentPosition();
            }
            ++n3;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void pause(int n2) {
        int n3;
        if (this.gameMediaMap.isEmpty()) {
            return;
        }
        HashMap<Integer, Integer> hashMap = this.gameMediaMap;
        Integer n4 = n2;
        int n5 = hashMap.get(n4);
        if (n5 == 0) return;
        MediaPlayer[] mediaPlayerArray = this.mediaPlayer;
        int n6 = n5 - 1;
        mediaPlayerArray[n6].pause();
        int[] nArray = this.mSavePlayPos;
        int n7 = n5 - 1;
        MediaPlayer[] mediaPlayerArray2 = this.mediaPlayer;
        int n8 = n5 - 1;
        nArray[n7] = n3 = mediaPlayerArray2[n8].getCurrentPosition();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean play(int n2, boolean bl) {
        int n3;
        boolean bl2 = this.load(n2);
        if (this.gameMediaMap.isEmpty()) {
            return false;
        }
        HashMap<Integer, Integer> hashMap = this.gameMediaMap;
        Integer n4 = n2;
        int n5 = hashMap.get(n4);
        if (n5 >= (n3 = this.maxStream)) {
            return false;
        }
        if (n5 == 0) return false;
        MediaPlayer[] mediaPlayerArray = this.mediaPlayer;
        int n6 = n5 - 1;
        mediaPlayerArray[n6].seekTo(0);
        MediaPlayer[] mediaPlayerArray2 = this.mediaPlayer;
        int n7 = n5 - 1;
        mediaPlayerArray2[n7].setLooping(bl);
        MediaPlayer[] mediaPlayerArray3 = this.mediaPlayer;
        int n8 = n5 - 1;
        mediaPlayerArray3[n8].start();
        MediaPlayer[] mediaPlayerArray4 = this.mediaPlayer;
        int n9 = n5 - 1;
        MediaPlayer mediaPlayer = mediaPlayerArray4[n9];
        float f2 = this.volume;
        float f3 = this.volume;
        mediaPlayer.setVolume(f2, f3);
        return true;
    }

    public void release() {
        int n2 = 0;
        while (true) {
            int n3;
            int n4;
            int n5;
            if (n2 >= (n5 = (n4 = this.maxStream) + (n3 = this.SOUNDCHANNEL))) {
                this.gameMediaMap.clear();
                this.loadStreamNum = 0;
                return;
            }
            this.mediaPlayer[n2].stop();
            this.mediaPlayer[n2].release();
            this.mPlayChannel[n2] = -1;
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void release(int n2) {
        int n3;
        if (this.gameMediaMap.isEmpty()) {
            return;
        }
        HashMap<Integer, Integer> hashMap = this.gameMediaMap;
        Integer n4 = n2;
        int n5 = hashMap.get(n4);
        if (n5 == 0) return;
        MediaPlayer[] mediaPlayerArray = this.mediaPlayer;
        int n6 = n5 - 1;
        mediaPlayerArray[n6].stop();
        MediaPlayer[] mediaPlayerArray2 = this.mediaPlayer;
        int n7 = n5 - 1;
        mediaPlayerArray2[n7].release();
        HashMap<Integer, Integer> hashMap2 = this.gameMediaMap;
        Integer n8 = n2;
        Integer n9 = hashMap2.remove(n8);
        if (this.loadStreamNum <= 0) return;
        this.loadStreamNum = n3 = this.loadStreamNum - 1;
    }

    public void resume() {
        int n2 = this.gameMediaMap.size();
        int n3 = 0;
        while (n3 < n2) {
            if (this.mediaPlayer[n3] != false && this.mSavePlayPos[n3] != -1) {
                this.mSavePlayPos[n3] = -1;
                this.mediaPlayer[n3].start();
            }
            ++n3;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void resume(int n2) {
        if (this.gameMediaMap.isEmpty()) {
            return;
        }
        HashMap<Integer, Integer> hashMap = this.gameMediaMap;
        Integer n3 = n2;
        int n4 = hashMap.get(n3);
        if (n4 == 0) return;
        MediaPlayer[] mediaPlayerArray = this.mediaPlayer;
        int n5 = n4 - 1;
        mediaPlayerArray[n5].start();
        int[] nArray = this.mSavePlayPos;
        int n6 = n4 - 1;
        if (nArray[n6] == -1) return;
        int[] nArray2 = this.mSavePlayPos;
        int n7 = n4 - 1;
        nArray2[n7] = -1;
        MediaPlayer[] mediaPlayerArray2 = this.mediaPlayer;
        int n8 = n4 - 1;
        mediaPlayerArray2[n8].start();
    }

    public void setAllMediaVolume(float f2) {
        this.volume = 1.0f;
    }

    public void setAudioStreamType(int n2, int n3) {
        HashMap<Integer, Integer> hashMap = this.gameMediaMap;
        Integer n4 = n2;
        int n5 = hashMap.get(n4);
        if (n5 != 0) {
            MediaPlayer[] mediaPlayerArray = this.mediaPlayer;
            int n6 = n5 - 1;
            mediaPlayerArray[n6].setAudioStreamType(n3);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setLoop(int n2, boolean bl) {
        int n3;
        if (this.gameMediaMap.isEmpty()) {
            return;
        }
        HashMap<Integer, Integer> hashMap = this.gameMediaMap;
        Integer n4 = n2;
        int n5 = hashMap.get(n4);
        if (n5 >= (n3 = this.maxStream)) return;
        if (n5 == 0) return;
        MediaPlayer[] mediaPlayerArray = this.mediaPlayer;
        int n6 = n5 - 1;
        mediaPlayerArray[n6].setLooping(bl);
    }

    public void setMediaVolume(int n2, float f2) {
        this.volume = 1.0f;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void stop(int n2) {
        int n3;
        if (this.gameMediaMap.isEmpty()) {
            return;
        }
        HashMap<Integer, Integer> hashMap = this.gameMediaMap;
        Integer n4 = n2;
        int n5 = hashMap.get(n4);
        if (n5 >= (n3 = this.maxStream)) return;
        if (n5 != 0) {
            int n6;
            MediaPlayer mediaPlayer;
            MediaPlayer[] mediaPlayerArray = this.mediaPlayer;
            int n7 = n5 - 1;
            mediaPlayerArray[n7].stop();
            int[] nArray = this.mSavePlayPos;
            int n8 = n5 - 1;
            nArray[n8] = -1;
            MediaPlayer[] mediaPlayerArray2 = this.mediaPlayer;
            int n9 = n5 - 1;
            mediaPlayerArray2[n9].release();
            MediaPlayer[] mediaPlayerArray3 = this.mediaPlayer;
            int n10 = n5 - 1;
            mediaPlayerArray3[n10] = mediaPlayer = new MediaPlayer();
            this.loadStreamNum = n6 = this.loadStreamNum - 1;
        }
        HashMap<Integer, Integer> hashMap2 = this.gameMediaMap;
        Integer n11 = n2;
        Integer n12 = hashMap2.remove(n11);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void stopAll() {
        if (this.gameMediaMap.isEmpty()) {
            return;
        }
        int n2 = this.gameMediaMap.size();
        int n3 = 0;
        while (true) {
            MediaPlayer mediaPlayer;
            if (n3 >= n2) {
                this.clearMediaMap();
                return;
            }
            this.mediaPlayer[n3].stop();
            this.mediaPlayer[n3].release();
            MediaPlayer[] mediaPlayerArray = this.mediaPlayer;
            mediaPlayerArray[n3] = mediaPlayer = new MediaPlayer();
            this.mSavePlayPos[n3] = -1;
            ++n3;
        }
    }
}

