/*
 * Decompiled with CFR 0.152.
 */
package oms.GameEngine;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import oms.GameEngine.C_MessageManager;
import oms.GameEngine.C_MultiTouch;
import oms.GameEngine.GameCanvas;
import oms.GameEngine.GameView;
import oms.GameEngine.InputInterface;
import oms.GameEngine.MediaManager;
import oms.GameEngine.PackageManager;
import oms.GameEngine.VibrateManager;

public class C_Lib {
    public static final int ADMOB_GONE = 2;
    public static final int ADMOB_INVISIABLE = 0;
    public static final int ADMOB_REFLASH = 32768;
    public static final int ADMOB_VISIABLE = 1;
    public static float mCanvasScaleX = 1.0f;
    public static float mCanvasScaleY = 1.0f;
    private Activity cActivity;
    private MediaManager cMediaManager;
    private C_MessageManager cMessageMgr;
    public Thread cThread;
    private VibrateManager cVibrateManager;
    public GameView cView;
    private GameCanvas gameCanvas;
    private InputInterface input;
    public Bitmap mBackground;
    private Context mContext = null;
    public boolean mTop;
    private int nAdmobStatus;
    public int nFPS;
    private int nFrameFlashTime;
    public int nRefreshHeight;
    public int nRefreshWidth;
    private int nResumeDelay;
    public float nScaledDensity;
    public int nVBLCount;

    public C_Lib(Context context, int n2, int n3, int n4) {
        VibrateManager vibrateManager;
        C_MessageManager c_MessageManager;
        InputInterface inputInterface;
        MediaManager mediaManager;
        this.mContext = context;
        this.gameCanvas = null;
        Context context2 = this.mContext;
        this.cMediaManager = mediaManager = new MediaManager(context2);
        this.input = inputInterface = new InputInterface();
        this.InitCanvas(n2, n3, n4);
        this.cMessageMgr = c_MessageManager = new C_MessageManager();
        this.cVibrateManager = vibrateManager = new VibrateManager();
        this.setFrameReflashTime(33);
        this.nFPS = 0;
        this.nVBLCount = 0;
        this.nRefreshWidth = 320;
        this.nRefreshHeight = 480;
        this.nScaledDensity = 1.0f;
        this.cView = null;
        this.cThread = null;
        this.mBackground = null;
        this.mTop = 1;
        this.nResumeDelay = 0;
        this.nAdmobStatus = 1;
    }

    private void InitCanvas(int n2, int n3, int n4) {
        if (this.gameCanvas == null) {
            GameCanvas gameCanvas;
            Context context = this.mContext;
            this.gameCanvas = gameCanvas = new GameCanvas(context, n2, n3, n4);
        }
    }

    public void ClearACT() {
        this.gameCanvas.ClearACT();
    }

    public Activity GetActivity() {
        return this.cActivity;
    }

    public int GetAdmobStatus() {
        return this.nAdmobStatus;
    }

    public Thread GetGameThread() {
        return this.cThread;
    }

    public int GetReflashHeight() {
        float f2 = this.nRefreshHeight;
        float f3 = this.nScaledDensity;
        return (int)(f2 * f3);
    }

    public int GetReflashWidth() {
        float f2 = this.nRefreshWidth;
        float f3 = this.nScaledDensity;
        return (int)(f2 * f3);
    }

    public GameView GetView() {
        return this.cView;
    }

    public void InitMedia(int n2, int n3) {
        if (this.cMediaManager == null) {
            this.cMediaManager.Init(n2, n3);
        }
    }

    public void OnDraw(Canvas canvas) {
        this.gameCanvas.onDraw(canvas);
    }

    public void ReadTouch() {
        this.input.ReadTouch();
    }

    public void Release() {
        if (this.gameCanvas != null) {
            this.gameCanvas.release();
            this.gameCanvas = null;
        }
        if (this.cMediaManager != null) {
            this.cMediaManager.release();
            this.cMediaManager = null;
        }
        if (this.mBackground != null) {
            this.mBackground.recycle();
            this.mBackground = null;
        }
    }

    public void SetActivity(Activity activity) {
        this.cActivity = activity;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void SetAdmobStatus(int n2) {
        int n3;
        if (32768 != n2) {
            this.nAdmobStatus = n2;
            return;
        }
        this.nAdmobStatus = n3 = this.nAdmobStatus | 0x8000;
    }

    public void SetBackground(int n2) {
        if (this.nRefreshHeight > 480) {
            Bitmap bitmap;
            if (this.mBackground != null) {
                this.mBackground.recycle();
                this.mBackground = null;
            }
            this.mBackground = bitmap = PackageManager.createBitmap(this.mContext, n2);
        }
    }

    public void SetBackgroundTop(boolean bl) {
        this.mTop = bl;
    }

    public void SetCanvasScale(float f2, float f3) {
        mCanvasScaleX = f2;
        mCanvasScaleY = f3;
    }

    public void SetCanvaseSize(int n2, int n3) {
        this.nRefreshWidth = n2;
        this.nRefreshHeight = n3;
    }

    public void SetGameThread(Thread thread) {
        this.cThread = thread;
    }

    public void SetGameView(GameView gameView) {
        this.cView = gameView;
    }

    public void SetReflashSize(int n2, int n3, float f2) {
        this.nRefreshWidth = n2;
        this.nRefreshHeight = n3;
        this.nScaledDensity = f2;
        int n4 = (this.nRefreshWidth - 320) / 2;
        int n5 = (this.nRefreshHeight - 480) / 2;
        this.SetScreenOffset(n4, n5);
        this.SetCanvasScale(1.0f, 1.0f);
    }

    public void SetScreenOffset(int n2, int n3) {
        this.input.SetScreenOffset(n2, n3);
        this.gameCanvas.SetScreenOffset(n2, n3);
        C_MultiTouch.SetScreenOffset(n2, n3);
    }

    public void ViewDark(int n2) {
        System.gc();
        boolean bl = true;
        while (true) {
            if (!bl) {
                this.input.ReadTouch();
                this.input.ReadKeyBoard();
                return;
            }
            if (this.gameCanvas.ViewDark(n2)) {
                bl = false;
            }
            this.WaitBLK();
        }
    }

    public void ViewOpen(int n2) {
        System.gc();
        boolean bl = true;
        while (true) {
            if (!bl) {
                this.input.ReadTouch();
                this.input.ReadKeyBoard();
                return;
            }
            if (this.gameCanvas.ViewOpen(n2)) {
                bl = false;
            }
            this.WaitBLK();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void WaitBLK() {
        int n2;
        if (this.nResumeDelay > 0) {
            int n3;
            this.nResumeDelay = n3 = this.nResumeDelay - 1;
        } else {
            this.input.nIsPause = 0;
        }
        if (this.gameCanvas != null) {
            this.gameCanvas.flush();
            if (this.cView != null) {
                while (this.gameCanvas != null && this.gameCanvas.getUpdata()) {
                    try {
                        Thread.sleep(this.nFrameFlashTime >> 1);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
        }
        this.nVBLCount = n2 = this.nVBLCount + 1;
    }

    public int getFPS() {
        return this.nFPS;
    }

    public int getFrameReflashTime() {
        return this.nFrameFlashTime;
    }

    public GameCanvas getGameCanvas() {
        return this.gameCanvas;
    }

    public InputInterface getInput() {
        return this.input;
    }

    public Context getMContext() {
        return this.mContext;
    }

    public MediaManager getMediaManager() {
        return this.cMediaManager;
    }

    public C_MessageManager getMessageMgr() {
        return this.cMessageMgr;
    }

    public int getVBLCount() {
        return this.nVBLCount;
    }

    public VibrateManager getVibrateManager() {
        return this.cVibrateManager;
    }

    public boolean isReflash() {
        return this.gameCanvas.isReflash();
    }

    void onDraw(C_Lib c_Lib, Canvas canvas, int n2) {
        this.gameCanvas.onDraw(c_Lib, canvas, n2);
    }

    public void onPause() {
        this.input.nIsPause = 1;
        this.input.ClearKeyValue();
        this.nResumeDelay = 10;
        this.gameCanvas.bUpdate = 0;
        if (this.cMediaManager != null) {
            this.cMediaManager.onPause();
        }
    }

    public void onResume() {
        if (this.cMediaManager != null) {
            this.cMediaManager.onResume();
        }
    }

    public void setFPS(int n2) {
        this.nFPS = n2;
    }

    public void setFrameReflashTime(int n2) {
        this.nFrameFlashTime = n2;
    }

    public void setMContext(Context context) {
        this.mContext = context;
    }
}

