/*
 * Decompiled with CFR 0.152.
 */
package pxb.android.dex2jar.v3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.commons.LocalVariablesSorter;
import pxb.android.dex2jar.Method;
import pxb.android.dex2jar.optimize.A;
import pxb.android.dex2jar.optimize.B;
import pxb.android.dex2jar.optimize.C;
import pxb.android.dex2jar.optimize.LdcOptimizeAdapter;
import pxb.android.dex2jar.optimize.MethodTransformer;
import pxb.android.dex2jar.org.objectweb.asm.tree.MethodNode;
import pxb.android.dex2jar.v3.Ann;
import pxb.android.dex2jar.v3.V3AnnAdapter;
import pxb.android.dex2jar.v3.V3CodeAdapter;
import pxb.android.dex2jar.visitors.DexAnnotationAble;
import pxb.android.dex2jar.visitors.DexAnnotationVisitor;
import pxb.android.dex2jar.visitors.DexCodeVisitor;
import pxb.android.dex2jar.visitors.DexMethodVisitor;

public class V3MethodAdapter
implements DexMethodVisitor,
Opcodes {
    protected List<Ann> anns = new ArrayList<Ann>();
    protected boolean build = false;
    protected ClassVisitor cv;
    protected Method method;
    protected MethodVisitor mv;
    protected List<Ann>[] paramAnns;
    protected MethodNode methodNode;

    public V3MethodAdapter(ClassVisitor cv, Method method) {
        this.cv = cv;
        this.method = method;
        List[] paramAnns = new List[method.getType().getParameterTypes().length];
        int i = 0;
        while (i < paramAnns.length) {
            paramAnns[i] = new ArrayList();
            ++i;
        }
        this.paramAnns = paramAnns;
    }

    protected void build() {
        if (!this.build) {
            String[] exceptions = null;
            Iterator<Ann> it = this.anns.iterator();
            while (it.hasNext()) {
                Ann ann = it.next();
                if (!"Ldalvik/annotation/Throws;".equals(ann.type)) continue;
                it.remove();
                for (Ann.Item item : ann.items) {
                    if (!item.name.equals("value")) continue;
                    Ann values = (Ann)item.value;
                    exceptions = new String[values.items.size()];
                    int count = 0;
                    for (Ann.Item i : values.items) {
                        exceptions[count++] = i.value.toString();
                    }
                }
            }
            MethodVisitor mv = this.cv.visitMethod(this.method.getAccessFlags(), this.method.getName(), this.method.getType().getDesc(), null, exceptions);
            if (mv != null) {
                this.methodNode = new MethodNode(this.method.getAccessFlags(), this.method.getName(), this.method.getType().getDesc(), null, exceptions);
                for (Ann ann : this.anns) {
                    AnnotationVisitor av = mv.visitAnnotation(ann.type, ann.visible == 1);
                    V3AnnAdapter.accept(ann.items, av);
                    av.visitEnd();
                }
                int i = 0;
                while (i < this.paramAnns.length) {
                    for (Ann ann : this.paramAnns[i]) {
                        AnnotationVisitor av = mv.visitParameterAnnotation(i, ann.type, ann.visible == 1);
                        V3AnnAdapter.accept(ann.items, av);
                        av.visitEnd();
                    }
                    ++i;
                }
            }
            this.mv = mv;
            this.build = true;
        }
    }

    public DexAnnotationVisitor visitAnnotation(String name, int visitable) {
        Ann ann = new Ann(name, visitable);
        this.anns.add(ann);
        return new V3AnnAdapter(ann);
    }

    public DexCodeVisitor visitCode() {
        this.build();
        if (this.mv == null) {
            return null;
        }
        return new V3CodeAdapter(this.method, this.methodNode);
    }

    public void visitEnd() {
        this.build();
        if (this.mv != null && this.methodNode.instructions.size() > 2) {
            List<MethodTransformer> trs = Arrays.asList(new A(), new B(this.method), new C(this.method));
            for (MethodTransformer tr : trs) {
                tr.transform(this.methodNode);
            }
        }
        this.methodNode.accept((MethodVisitor)new LocalVariablesSorter(this.method.getAccessFlags(), this.method.getType().getDesc(), (MethodVisitor)new LdcOptimizeAdapter(this.mv)));
    }

    public DexAnnotationAble visitParamesterAnnotation(int index) {
        final List<Ann> panns = this.paramAnns[index];
        return new DexAnnotationAble(){

            public DexAnnotationVisitor visitAnnotation(String name, int visitable) {
                Ann ann = new Ann(name, visitable);
                panns.add(ann);
                return new V3AnnAdapter(ann);
            }
        };
    }
}

