/*
 * Decompiled with CFR 0.152.
 */
package pxb.android.dex2jar.reader;

import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pxb.android.dex2jar.DataIn;
import pxb.android.dex2jar.Dex;
import pxb.android.dex2jar.visitors.DexCodeVisitor;

public class DexDebugInfoReader {
    public static final int DBG_END_SEQUENCE = 0;
    public static final int DBG_ADVANCE_PC = 1;
    public static final int DBG_ADVANCE_LINE = 2;
    public static final int DBG_START_LOCAL = 3;
    public static final int DBG_START_LOCAL_EXTENDED = 4;
    public static final int DBG_END_LOCAL = 5;
    public static final int DBG_RESTART_LOCAL = 6;
    public static final int DBG_SET_PROLOGUE_END = 7;
    public static final int DBG_SET_EPILOGUE_BEGIN = 8;
    public static final int DBG_SET_FILE = 9;
    public static final int DBG_FIRST_SPECIAL = 10;
    public static final int DBG_LINE_BASE = -4;
    public static final int DBG_LINE_RANGE = 15;
    private DataIn in;
    private Dex dex;
    private static final Logger log = LoggerFactory.getLogger(DexDebugInfoReader.class);

    public DexDebugInfoReader(DataIn in, Dex dex, int regsize) {
        this.in = in;
        this.dex = dex;
    }

    public void accept(DexCodeVisitor dcv) {
        DataIn in = this.in;
        int lineRegister = (int)in.readUnsignedLeb128();
        int szParams = (int)in.readUnsignedLeb128();
        String[] ps = new String[szParams];
        int i = 0;
        while (i < szParams) {
            int string_offset = (int)(in.readUnsignedLeb128() - 1L);
            ps[i] = this.dex.getString(string_offset);
            ++i;
        }
        int addressRegister = 0;
        HashMap<Integer, LocalVariable> variableList = new HashMap<Integer, LocalVariable>();
        block13: while (true) {
            int opcode = in.readByte();
            switch (opcode) {
                case 0: {
                    break block13;
                }
                case 1: {
                    int offset = (int)in.readUnsignedLeb128();
                    addressRegister += offset;
                    continue block13;
                }
                case 2: {
                    int offset = (int)in.readUnsignedLeb128();
                    lineRegister += offset;
                    continue block13;
                }
                case 3: {
                    int regNum = (int)in.readUnsignedLeb128();
                    int nameIdx = (int)in.readUnsignedLeb128() - 1;
                    int typeIdx = (int)in.readUnsignedLeb128() - 1;
                    if (nameIdx < 0 || typeIdx < 0) continue block13;
                    LocalVariable localVariable = new LocalVariable(regNum, addressRegister, -1, this.dex.getString(nameIdx), this.dex.getType(typeIdx), null);
                    variableList.put(regNum, localVariable);
                    continue block13;
                }
                case 4: {
                    int regNum = (int)in.readUnsignedLeb128();
                    int nameIdx = (int)in.readUnsignedLeb128() - 1;
                    int typeIdx = (int)in.readUnsignedLeb128() - 1;
                    int sigIdx = (int)in.readUnsignedLeb128() - 1;
                    if (nameIdx < 0 || typeIdx < 0) continue block13;
                    LocalVariable localVariable = new LocalVariable(regNum, addressRegister, -1, this.dex.getString(nameIdx), this.dex.getType(typeIdx), this.dex.getString(sigIdx));
                    variableList.put(regNum, localVariable);
                    continue block13;
                }
                case 5: {
                    int regNum = (int)in.readUnsignedLeb128();
                    LocalVariable nameIdx = (LocalVariable)variableList.get(regNum);
                    continue block13;
                }
                case 6: {
                    int regNum = (int)in.readUnsignedLeb128();
                    LocalVariable v = (LocalVariable)variableList.get(regNum);
                    if (v == null) continue block13;
                    v.start = addressRegister;
                    continue block13;
                }
                case 7: {
                    continue block13;
                }
                case 8: {
                    continue block13;
                }
                case 9: {
                    int sourceFileIdx = (int)in.readUnsignedLeb128() - 1;
                    if (!log.isDebugEnabled()) continue block13;
                    log.debug("source file:{}", (Object)this.dex.getString(sourceFileIdx));
                    continue block13;
                }
                default: {
                    int adjustedOpcode = opcode - 10;
                    lineRegister += -4 + adjustedOpcode % 15;
                    addressRegister += adjustedOpcode / 15;
                    continue block13;
                }
            }
            break;
        }
    }

    public static class LocalVariable {
        public int start;
        public int end;
        public String name;
        public String type;
        public String signature;
        public int reg;

        public LocalVariable(int reg, int start, int end, String name, String type, String signature) {
            this.reg = reg;
            this.start = start;
            this.end = end;
            this.name = name;
            this.type = type;
            this.signature = signature;
        }
    }
}

