/*
 * Decompiled with CFR 0.152.
 */
package pxb.android.dex2jar.reader;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.Label;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pxb.android.dex2jar.DataIn;
import pxb.android.dex2jar.Dex;
import pxb.android.dex2jar.DexOpcodeDump;
import pxb.android.dex2jar.DexOpcodeUtil;
import pxb.android.dex2jar.DexOpcodes;
import pxb.android.dex2jar.Method;
import pxb.android.dex2jar.reader.DexOpcodeAdapter;
import pxb.android.dex2jar.visitors.DexCodeVisitor;

public class DexCodeReader
implements DexOpcodes {
    private static final Logger log = LoggerFactory.getLogger(DexCodeReader.class);
    private Dex dex;
    private DataIn in;
    private Map<Integer, Label> labels = new HashMap<Integer, Label>();
    private Method method;

    public DexCodeReader(Dex dex, DataIn in, Method method) {
        this.dex = dex;
        this.in = in;
        this.method = method;
    }

    public void accept(DexCodeVisitor dcv) {
        int size;
        int opcode;
        int args_index;
        int[] args;
        DataIn in = this.in;
        DexOpcodeAdapter tadoa = new DexOpcodeAdapter(this.dex, dcv, this.labels);
        short total_registers_size = in.readShortx();
        short in_register_size = in.readShortx();
        in.readShortx();
        int tries_size = in.readShortx();
        int debug_off = in.readIntx();
        int instruction_size = in.readIntx();
        int i = total_registers_size - in_register_size;
        if ((this.method.getAccessFlags() & 8) == 0) {
            args = new int[this.method.getType().getParameterTypes().length + 1];
            args[0] = i++;
            args_index = 1;
        } else {
            args = new int[this.method.getType().getParameterTypes().length];
            args_index = 0;
        }
        String[] stringArray = this.method.getType().getParameterTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            args[args_index++] = i++;
            if ("D".equals(type) || "J".equals(type)) {
                ++i;
            }
            ++n2;
        }
        dcv.visitInitLocal(args);
        if (tries_size > 0) {
            in.push();
            in.skip(instruction_size * 2);
            if (in.needPadding()) {
                in.skip(2);
            }
            int i2 = 0;
            while (i2 < tries_size) {
                int start = in.readIntx();
                short offset = in.readShortx();
                short handlers = in.readShortx();
                in.push();
                in.skip((tries_size - i2 - 1) * 8 + handlers);
                boolean catchAll = false;
                int listSize = (int)in.readSignedLeb128();
                if (listSize <= 0) {
                    listSize = -listSize;
                    catchAll = true;
                }
                int k = 0;
                while (k < listSize) {
                    int type_id = (int)in.readUnsignedLeb128();
                    int handler = (int)in.readUnsignedLeb128();
                    this.order(start);
                    this.order(start + offset);
                    this.order(handler);
                    String type = this.dex.getType(type_id);
                    dcv.visitTryCatch(this.labels.get(start), this.labels.get(start + offset), this.labels.get(handler), type);
                    ++k;
                }
                if (catchAll) {
                    int handler = (int)in.readUnsignedLeb128();
                    this.order(start);
                    this.order(start + offset);
                    this.order(handler);
                    dcv.visitTryCatch(this.labels.get(start), this.labels.get(start + offset), this.labels.get(handler), null);
                }
                in.pop();
                ++i2;
            }
            in.pop();
        }
        in.push();
        int i3 = 0;
        while (i3 < instruction_size) {
            opcode = in.readByte() & 0xFF;
            size = DexOpcodeUtil.getSize(opcode);
            switch (size) {
                case 1: {
                    int a = in.readByte();
                    switch (opcode) {
                        case 40: {
                            this.order(i3 + (byte)a);
                        }
                    }
                    ++i3;
                    break;
                }
                case 2: {
                    in.skip(1);
                    short b = in.readShortx();
                    switch (opcode) {
                        case 41: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 61: {
                            this.order(i3 + b);
                        }
                    }
                    i3 += 2;
                    break;
                }
                case 3: {
                    in.skip(5);
                    i3 += 3;
                    break;
                }
                case 0: {
                    i3 = instruction_size;
                    break;
                }
                case -1: {
                    in.skip(1);
                    int offset = in.readIntx();
                    in.push();
                    in.skip((offset - 3) * 2);
                    switch (opcode) {
                        case 44: {
                            in.readShortx();
                            int switch_size = in.readShortx();
                            int j = 0;
                            while (j < switch_size) {
                                in.readIntx();
                                ++j;
                            }
                            j = 0;
                            while (j < switch_size) {
                                this.order(i3 + in.readIntx());
                                ++j;
                            }
                            this.order(i3 + 3);
                            break;
                        }
                        case 43: {
                            in.skip(2);
                            int switch_size = in.readShortx();
                            in.skip(4);
                            int j = 0;
                            while (j < switch_size) {
                                int targetOffset = in.readIntx();
                                this.order(i3 + targetOffset);
                                ++j;
                            }
                            this.order(i3 + 3);
                            break;
                        }
                    }
                    in.pop();
                    i3 += 3;
                    break;
                }
                case 5: {
                    in.skip(9);
                    i3 += 5;
                }
            }
        }
        in.pop();
        i3 = 0;
        while (i3 < instruction_size) {
            opcode = in.readByte() & 0xFF;
            if (this.labels.containsKey(i3)) {
                dcv.visitLabel(this.labels.get(i3));
            }
            tadoa.visitOffset(i3);
            size = DexOpcodeUtil.getSize(opcode);
            switch (size) {
                case 1: {
                    int a = in.readByte();
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("%04x| %02x%02x           %s", i3, opcode, a, DexOpcodeDump.dump(opcode)));
                    }
                    tadoa.visit(opcode, a);
                    ++i3;
                    break;
                }
                case 2: {
                    int a = in.readByte();
                    short b = in.readShortx();
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("%04x| %02x%02x %04x      %s", i3, opcode, a, Short.reverseBytes(b), DexOpcodeDump.dump(opcode)));
                    }
                    tadoa.visit(opcode, a, b);
                    i3 += 2;
                    break;
                }
                case 3: {
                    int a = in.readByte();
                    short b = in.readShortx();
                    short c = in.readShortx();
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("%04x| %02x%02x %04x %04x %s", i3, opcode, a, Short.reverseBytes(b), Short.reverseBytes(c), DexOpcodeDump.dump(opcode)));
                    }
                    tadoa.visit(opcode, a, b, c);
                    i3 += 3;
                    break;
                }
                case 0: {
                    i3 = instruction_size;
                    break;
                }
                case -1: {
                    int reg = in.readByte();
                    int offset = in.readIntx();
                    in.push();
                    in.skip((offset - 3) * 2);
                    switch (opcode) {
                        case 44: {
                            in.readShortx();
                            int switch_size = in.readShortx();
                            int[] cases = new int[switch_size];
                            Label[] label = new Label[switch_size];
                            int j = 0;
                            while (j < switch_size) {
                                cases[j] = in.readIntx();
                                ++j;
                            }
                            j = 0;
                            while (j < switch_size) {
                                label[j] = this.labels.get(i3 + in.readIntx());
                                ++j;
                            }
                            dcv.visitLookupSwitchInsn(opcode, reg, this.labels.get(i3 + 3), cases, label);
                            break;
                        }
                        case 43: {
                            in.readShortx();
                            int switch_size = in.readShortx();
                            int first_case = in.readIntx();
                            int last_case = first_case - 1 + switch_size;
                            Label[] _labels = new Label[switch_size];
                            int j = 0;
                            while (j < switch_size) {
                                int targetOffset = in.readIntx();
                                _labels[j] = this.labels.get(i3 + targetOffset);
                                ++j;
                            }
                            dcv.visitTableSwitchInsn(opcode, reg, first_case, last_case, this.labels.get(i3 + 3), _labels);
                            break;
                        }
                        case 38: {
                            int j;
                            in.readShortx();
                            short elemWidth = in.readShortx();
                            int initLength = in.readIntx();
                            Object[] values = new Object[initLength];
                            switch (elemWidth) {
                                case 1: {
                                    j = 0;
                                    while (j < initLength) {
                                        values[j] = in.readByte();
                                        ++j;
                                    }
                                    break;
                                }
                                case 2: {
                                    j = 0;
                                    while (j < initLength) {
                                        values[j] = in.readShortx();
                                        ++j;
                                    }
                                    break;
                                }
                                case 4: {
                                    j = 0;
                                    while (j < initLength) {
                                        values[j] = in.readIntx();
                                        ++j;
                                    }
                                    break;
                                }
                                case 8: {
                                    j = 0;
                                    while (j < initLength) {
                                        values[j] = in.readLongx();
                                        ++j;
                                    }
                                    break;
                                }
                            }
                            dcv.visitFillArrayInsn(opcode, reg, elemWidth, initLength, values);
                        }
                    }
                    in.pop();
                    i3 += 3;
                    break;
                }
                case 5: {
                    int reg = in.readByte();
                    int l = in.readIntx();
                    int h = in.readIntx();
                    long longV = (long)h << 32 | (long)l & 0xFFFFFFFFL;
                    dcv.visitLdcInsn(opcode, longV, reg);
                    i3 += 5;
                    break;
                }
                default: {
                    throw new RuntimeException(String.format("Not support Opcode :0x%02x=%s @[0x%04x]", opcode, DexOpcodeDump.dump(opcode), i3));
                }
            }
        }
        dcv.visitEnd();
    }

    private void order(int offset) {
        if (!this.labels.containsKey(offset)) {
            this.labels.put(offset, new Label());
        }
    }
}

