/*
 * Decompiled with CFR 0.152.
 */
package pxb.android.dex2jar.org.objectweb.asm.tree.analysis;

import java.util.ArrayList;
import org.objectweb.asm.Type;
import pxb.android.dex2jar.org.objectweb.asm.tree.AbstractInsnNode;
import pxb.android.dex2jar.org.objectweb.asm.tree.IincInsnNode;
import pxb.android.dex2jar.org.objectweb.asm.tree.MethodInsnNode;
import pxb.android.dex2jar.org.objectweb.asm.tree.MultiANewArrayInsnNode;
import pxb.android.dex2jar.org.objectweb.asm.tree.VarInsnNode;
import pxb.android.dex2jar.org.objectweb.asm.tree.analysis.AnalyzerException;
import pxb.android.dex2jar.org.objectweb.asm.tree.analysis.Interpreter;
import pxb.android.dex2jar.org.objectweb.asm.tree.analysis.Value;

public class Frame {
    private Value returnValue;
    private Value[] localValues;
    private Value[] stackValues;
    private int top;

    public Frame(int nLocals, int nStack) {
        this.localValues = new Value[nLocals];
        this.stackValues = new Value[nStack];
    }

    public Frame(Frame src) {
        this(src.localValues.length, src.stackValues.length);
        this.init(src);
    }

    public Frame init(Frame src) {
        this.returnValue = src.returnValue;
        this.localValues = new Value[src.localValues.length];
        this.stackValues = new Value[src.stackValues.length];
        System.arraycopy(src.localValues, 0, this.localValues, 0, this.localValues.length);
        System.arraycopy(src.stackValues, 0, this.stackValues, 0, this.stackValues.length);
        this.top = src.top;
        return this;
    }

    public void setReturn(Value v) {
        this.returnValue = v;
    }

    public Value getLocal(int i) throws IndexOutOfBoundsException {
        if (i >= this.localValues.length) {
            Value[] temp = new Value[i + 2];
            System.arraycopy(this.localValues, 0, temp, 0, this.localValues.length);
            this.localValues = temp;
        }
        return this.localValues[i];
    }

    public void setLocal(int i, Value value) throws IndexOutOfBoundsException {
        if (i >= this.localValues.length) {
            Value[] temp = new Value[i + 2];
            System.arraycopy(this.localValues, 0, temp, 0, this.localValues.length);
            this.localValues = temp;
        }
        this.localValues[i] = value;
    }

    public int getStackSize() {
        return this.top;
    }

    public Value getStack(int i) throws IndexOutOfBoundsException {
        if (this.top >= this.stackValues.length) {
            Value[] temp = new Value[this.top + 2];
            System.arraycopy(this.stackValues, 0, temp, 0, this.stackValues.length);
            this.stackValues = temp;
        }
        return this.stackValues[i];
    }

    public void clearStack() {
        this.top = 0;
    }

    public Value pop() throws IndexOutOfBoundsException {
        if (this.top == 0) {
            throw new IndexOutOfBoundsException("Cannot pop operand off an empty stack.");
        }
        return this.stackValues[--this.top];
    }

    public void push(Value value) throws IndexOutOfBoundsException {
        if (this.top >= this.stackValues.length) {
            Value[] temp = new Value[this.top + 2];
            System.arraycopy(this.stackValues, 0, temp, 0, this.stackValues.length);
            this.stackValues = temp;
        }
        this.stackValues[this.top++] = value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(AbstractInsnNode insn, Interpreter interpreter) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 0: {
                return;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                this.push(interpreter.newOperation(insn));
                return;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                this.push(interpreter.copyOperation(insn, this.getLocal(((VarInsnNode)insn).var)));
                return;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                Value value2 = this.pop();
                Value value1 = this.pop();
                this.push(interpreter.binaryOperation(insn, value1, value2));
                return;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                Value local;
                Value value1 = interpreter.copyOperation(insn, this.pop());
                int var = ((VarInsnNode)insn).var;
                this.setLocal(var, value1);
                if (value1.getSize() == 2) {
                    this.setLocal(var + 1, interpreter.newValue(null));
                }
                if (var <= 0 || (local = this.getLocal(var - 1)) == null || local.getSize() != 2) return;
                this.setLocal(var - 1, interpreter.newValue(null));
                return;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                Value value3 = this.pop();
                Value value2 = this.pop();
                Value value1 = this.pop();
                interpreter.ternaryOperation(insn, value1, value2, value3);
                return;
            }
            case 87: {
                if (this.pop().getSize() != 2) return;
                throw new AnalyzerException("Illegal use of POP");
            }
            case 88: {
                if (this.pop().getSize() != 1 || this.pop().getSize() == 1) return;
                throw new AnalyzerException("Illegal use of POP2");
            }
            case 89: {
                Value value1 = this.pop();
                if (value1.getSize() != 1) {
                    throw new AnalyzerException("Illegal use of DUP");
                }
                this.push(value1);
                this.push(interpreter.copyOperation(insn, value1));
                return;
            }
            case 90: {
                Value value1 = this.pop();
                Value value2 = this.pop();
                if (value1.getSize() != 1 || value2.getSize() != 1) {
                    throw new AnalyzerException("Illegal use of DUP_X1");
                }
                this.push(interpreter.copyOperation(insn, value1));
                this.push(value2);
                this.push(value1);
                return;
            }
            case 91: {
                Value value1 = this.pop();
                if (value1.getSize() != 1) throw new AnalyzerException("Illegal use of DUP_X2");
                Value value2 = this.pop();
                if (value2.getSize() == 1) {
                    Value value3 = this.pop();
                    if (value3.getSize() != 1) throw new AnalyzerException("Illegal use of DUP_X2");
                    this.push(interpreter.copyOperation(insn, value1));
                    this.push(value3);
                    this.push(value2);
                    this.push(value1);
                    return;
                }
                this.push(interpreter.copyOperation(insn, value1));
                this.push(value2);
                this.push(value1);
                return;
            }
            case 92: {
                Value value1 = this.pop();
                if (value1.getSize() == 1) {
                    Value value2 = this.pop();
                    if (value2.getSize() != 1) throw new AnalyzerException("Illegal use of DUP2");
                    this.push(value2);
                    this.push(value1);
                    this.push(interpreter.copyOperation(insn, value2));
                    this.push(interpreter.copyOperation(insn, value1));
                    return;
                }
                this.push(value1);
                this.push(interpreter.copyOperation(insn, value1));
                return;
            }
            case 93: {
                Value value1 = this.pop();
                if (value1.getSize() == 1) {
                    Value value3;
                    Value value2 = this.pop();
                    if (value2.getSize() != 1 || (value3 = this.pop()).getSize() != 1) throw new AnalyzerException("Illegal use of DUP2_X1");
                    this.push(interpreter.copyOperation(insn, value2));
                    this.push(interpreter.copyOperation(insn, value1));
                    this.push(value3);
                    this.push(value2);
                    this.push(value1);
                    return;
                }
                Value value2 = this.pop();
                if (value2.getSize() != 1) throw new AnalyzerException("Illegal use of DUP2_X1");
                this.push(interpreter.copyOperation(insn, value1));
                this.push(value2);
                this.push(value1);
                return;
            }
            case 94: {
                Value value1 = this.pop();
                if (value1.getSize() == 1) {
                    Value value2 = this.pop();
                    if (value2.getSize() != 1) throw new AnalyzerException("Illegal use of DUP2_X2");
                    Value value3 = this.pop();
                    if (value3.getSize() == 1) {
                        Value value4 = this.pop();
                        if (value4.getSize() != 1) throw new AnalyzerException("Illegal use of DUP2_X2");
                        this.push(interpreter.copyOperation(insn, value2));
                        this.push(interpreter.copyOperation(insn, value1));
                        this.push(value4);
                        this.push(value3);
                        this.push(value2);
                        this.push(value1);
                        return;
                    }
                    this.push(interpreter.copyOperation(insn, value2));
                    this.push(interpreter.copyOperation(insn, value1));
                    this.push(value3);
                    this.push(value2);
                    this.push(value1);
                    return;
                }
                Value value2 = this.pop();
                if (value2.getSize() == 1) {
                    Value value3 = this.pop();
                    if (value3.getSize() != 1) throw new AnalyzerException("Illegal use of DUP2_X2");
                    this.push(interpreter.copyOperation(insn, value1));
                    this.push(value3);
                    this.push(value2);
                    this.push(value1);
                    return;
                }
                this.push(interpreter.copyOperation(insn, value1));
                this.push(value2);
                this.push(value1);
                return;
            }
            case 95: {
                Value value2 = this.pop();
                Value value1 = this.pop();
                if (value1.getSize() != 1 || value2.getSize() != 1) {
                    throw new AnalyzerException("Illegal use of SWAP");
                }
                this.push(interpreter.copyOperation(insn, value2));
                this.push(interpreter.copyOperation(insn, value1));
                return;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                Value value2 = this.pop();
                Value value1 = this.pop();
                this.push(interpreter.binaryOperation(insn, value1, value2));
                return;
            }
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                this.push(interpreter.unaryOperation(insn, this.pop()));
                return;
            }
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: {
                Value value2 = this.pop();
                Value value1 = this.pop();
                this.push(interpreter.binaryOperation(insn, value1, value2));
                return;
            }
            case 132: {
                int var = ((IincInsnNode)insn).var;
                this.setLocal(var, interpreter.unaryOperation(insn, this.getLocal(var)));
                return;
            }
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: {
                this.push(interpreter.unaryOperation(insn, this.pop()));
                return;
            }
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                Value value2 = this.pop();
                Value value1 = this.pop();
                this.push(interpreter.binaryOperation(insn, value1, value2));
                return;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: {
                interpreter.unaryOperation(insn, this.pop());
                return;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                Value value2 = this.pop();
                Value value1 = this.pop();
                interpreter.binaryOperation(insn, value1, value2);
                return;
            }
            case 167: {
                return;
            }
            case 168: {
                this.push(interpreter.newOperation(insn));
                return;
            }
            case 169: {
                return;
            }
            case 170: 
            case 171: {
                interpreter.unaryOperation(insn, this.pop());
                return;
            }
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: {
                Value value1 = this.pop();
                interpreter.unaryOperation(insn, value1);
                interpreter.returnOperation(insn, value1, this.returnValue);
                return;
            }
            case 177: {
                if (this.returnValue == null) return;
                throw new AnalyzerException("Incompatible return type");
            }
            case 178: {
                this.push(interpreter.newOperation(insn));
                return;
            }
            case 179: {
                interpreter.unaryOperation(insn, this.pop());
                return;
            }
            case 180: {
                this.push(interpreter.unaryOperation(insn, this.pop()));
                return;
            }
            case 181: {
                Value value2 = this.pop();
                Value value1 = this.pop();
                interpreter.binaryOperation(insn, value1, value2);
                return;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: {
                ArrayList<Value> values = new ArrayList<Value>();
                String desc = ((MethodInsnNode)insn).desc;
                int i = Type.getArgumentTypes((String)desc).length;
                while (i > 0) {
                    values.add(0, this.pop());
                    --i;
                }
                if (insn.getOpcode() != 184 && insn.getOpcode() != 186) {
                    values.add(0, this.pop());
                }
                if (Type.getReturnType((String)desc) == Type.VOID_TYPE) {
                    interpreter.naryOperation(insn, values);
                    return;
                }
                this.push(interpreter.naryOperation(insn, values));
                return;
            }
            case 187: {
                this.push(interpreter.newOperation(insn));
                return;
            }
            case 188: 
            case 189: 
            case 190: {
                this.push(interpreter.unaryOperation(insn, this.pop()));
                return;
            }
            case 191: {
                interpreter.unaryOperation(insn, this.pop());
                return;
            }
            case 192: 
            case 193: {
                this.push(interpreter.unaryOperation(insn, this.pop()));
                return;
            }
            case 194: 
            case 195: {
                interpreter.unaryOperation(insn, this.pop());
                return;
            }
            case 197: {
                ArrayList<Value> values = new ArrayList<Value>();
                int i = ((MultiANewArrayInsnNode)insn).dims;
                while (i > 0) {
                    values.add(0, this.pop());
                    --i;
                }
                this.push(interpreter.naryOperation(insn, values));
                return;
            }
            case 198: 
            case 199: {
                interpreter.unaryOperation(insn, this.pop());
                return;
            }
            default: {
                throw new RuntimeException("Illegal opcode " + insn.getOpcode());
            }
        }
    }

    public boolean merge(Frame frame, Interpreter interpreter) throws AnalyzerException {
        Value v;
        if (this.top != frame.top) {
            throw new AnalyzerException("Incompatible stack heights");
        }
        boolean changes = false;
        int i = 0;
        while (i < Math.min(this.localValues.length, frame.localValues.length)) {
            if (this.localValues[i] != null && (v = interpreter.merge(this.localValues[i], frame.localValues[i])) != this.localValues[i]) {
                this.localValues[i] = v;
                changes |= true;
            }
            ++i;
        }
        i = 0;
        while (i < this.top) {
            v = interpreter.merge(this.stackValues[i], frame.stackValues[i]);
            if (v != this.stackValues[i]) {
                this.stackValues[i] = v;
                changes |= true;
            }
            ++i;
        }
        return changes;
    }

    public boolean merge(Frame frame, boolean[] access) {
        boolean changes = false;
        int i = 0;
        while (i < Math.min(frame.localValues.length, this.localValues.length)) {
            if (!access[i] && !this.localValues[i].equals(frame.localValues[i])) {
                this.localValues[i] = frame.localValues[i];
                changes = true;
            }
            ++i;
        }
        return changes;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < this.localValues.length) {
            b.append(this.getLocal(i));
            ++i;
        }
        b.append(' ');
        i = 0;
        while (i < this.getStackSize()) {
            b.append(this.getStack(i).toString());
            ++i;
        }
        return b.toString();
    }
}

