/*
 * Decompiled with CFR 0.152.
 */
package pxb.android.dex2jar.optimize;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.util.TraceMethodVisitor;
import pxb.android.dex2jar.Method;
import pxb.android.dex2jar.optimize.MethodTransformer;
import pxb.android.dex2jar.optimize.Util;
import pxb.android.dex2jar.org.objectweb.asm.tree.AbstractInsnNode;
import pxb.android.dex2jar.org.objectweb.asm.tree.InsnList;
import pxb.android.dex2jar.org.objectweb.asm.tree.InsnNode;
import pxb.android.dex2jar.org.objectweb.asm.tree.JumpInsnNode;
import pxb.android.dex2jar.org.objectweb.asm.tree.LabelNode;
import pxb.android.dex2jar.org.objectweb.asm.tree.LdcInsnNode;
import pxb.android.dex2jar.org.objectweb.asm.tree.LookupSwitchInsnNode;
import pxb.android.dex2jar.org.objectweb.asm.tree.MethodInsnNode;
import pxb.android.dex2jar.org.objectweb.asm.tree.MethodNode;
import pxb.android.dex2jar.org.objectweb.asm.tree.TableSwitchInsnNode;
import pxb.android.dex2jar.org.objectweb.asm.tree.TryCatchBlockNode;
import pxb.android.dex2jar.org.objectweb.asm.tree.TypeInsnNode;
import pxb.android.dex2jar.org.objectweb.asm.tree.VarInsnNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class B
implements MethodTransformer,
Opcodes {
    Method m;
    InsnList insnList;
    TraceMethodVisitor tr = new TraceMethodVisitor();
    MethodNode method;
    List<Block> blocks = new ArrayList<Block>();
    Map<Label, Block> blockMaps = new HashMap<Label, Block>();
    int max = -1;

    public B(Method m) {
        this.m = m;
    }

    private int order() {
        return ++this.max;
    }

    private void max(int max) {
        if (max > this.max) {
            this.max = max;
        }
    }

    @Override
    public void transform(MethodNode method) {
        AbstractInsnNode q;
        int blockIndex = 0;
        this.insnList = method.instructions;
        this.method = method;
        HashMap<Integer, AbstractInsnNode> in = new HashMap<Integer, AbstractInsnNode>();
        HashMap<Integer, AbstractInsnNode> out = new HashMap<Integer, AbstractInsnNode>();
        AbstractInsnNode p = method.instructions.getFirst();
        if (!(p instanceof LabelNode)) {
            this.insnList.insertBefore(p, new LabelNode());
        }
        if (!((q = method.instructions.getLast()) instanceof LabelNode)) {
            this.insnList.insert(q, new LabelNode());
        }
        AbstractInsnNode first = method.instructions.getFirst();
        p = first.getNext();
        while (p != null) {
            if (Util.isRead(p)) {
                int r = Util.var(p);
                this.max(r);
                if (in.get(r) == null && out.get(r) == null) {
                    in.put(r, p);
                }
            } else if (Util.isWrite(p)) {
                int r = Util.var(p);
                this.max(r);
                out.put(r, p);
            } else if (Util.needBreak(p)) {
                if (p.getType() != 7) {
                    q = p.getNext();
                    if (q != null && q.getType() == 7) {
                        p = q;
                    } else {
                        method.instructions.insert(p, new LabelNode());
                        p = p.getNext();
                    }
                }
                Block block = new Block(blockIndex++);
                block.first = (LabelNode)first;
                block.last = (LabelNode)p;
                block.in = in;
                block.out = out;
                this.blocks.add(block);
                this.blockMaps.put(block.first.getLabel(), block);
                first = p;
                in = new HashMap();
                out = new HashMap();
            }
            p = p.getNext();
        }
        this.linkTryCatch();
        this.linkBlocks();
        for (Block block : this.blocks) {
            B.optmizeOut(block);
        }
        for (Block block : this.blocks) {
            this.doBlock(block);
        }
    }

    private static void optmizeOut(Block block) {
        HashSet<Object> mask = new HashSet<Object>();
        Iterator<Integer> it = block.out.keySet().iterator();
        while (it.hasNext()) {
            Integer i = it.next();
            mask.clear();
            boolean read = B.doOptmizeOut(i, block, mask, false);
            if (read) continue;
            it.remove();
        }
    }

    private static boolean doOptmizeOut(Integer i, Block block, Set<Object> mask, boolean checkThis) {
        if (checkThis && block.in.containsKey(i)) {
            return true;
        }
        if (!mask.contains(block)) {
            mask.add(block);
            for (Block n : block.tos) {
                boolean result;
                if (mask.contains(n) || !(result = B.doOptmizeOut(i, n, mask, true))) continue;
                return true;
            }
        }
        return false;
    }

    private void linkBlocks() {
        int i = 0;
        while (i < this.blocks.size()) {
            Block block = this.blocks.get(i);
            AbstractInsnNode node = block.last.getPrevious();
            switch (node.getType()) {
                case 6: {
                    JumpInsnNode jump = (JumpInsnNode)node;
                    B.link(block, this.blockMaps.get(jump.label.getLabel()));
                    if (jump.getOpcode() == 167) break;
                    B.link(block, this.blocks.get(i + 1));
                    break;
                }
                case 11: {
                    LabelNode label;
                    LookupSwitchInsnNode lsin = (LookupSwitchInsnNode)node;
                    B.link(block, this.blockMaps.get(lsin.dflt.getLabel()));
                    for (Object l : lsin.labels) {
                        label = (LabelNode)l;
                        B.link(block, this.blockMaps.get(label.getLabel()));
                    }
                    break;
                }
                case 10: {
                    LabelNode label;
                    TableSwitchInsnNode tsin = (TableSwitchInsnNode)node;
                    B.link(block, this.blockMaps.get(tsin.dflt.getLabel()));
                    for (Object l : tsin.labels) {
                        label = (LabelNode)l;
                        B.link(block, this.blockMaps.get(label.getLabel()));
                    }
                    break;
                }
                default: {
                    int insnOpcode = node.getOpcode();
                    if (insnOpcode == 191 || insnOpcode >= 172 && insnOpcode <= 177) break;
                    B.link(block, this.blocks.get(i + 1));
                }
            }
            ++i;
        }
    }

    private void linkTryCatch() {
        block0: for (Object o : this.method.tryCatchBlocks) {
            Block block;
            TryCatchBlockNode tcb = (TryCatchBlockNode)o;
            Block b_handle = this.blockMaps.get(tcb.handler.getLabel());
            int i = 0;
            while (i < this.blocks.size()) {
                block = this.blocks.get(i);
                if (block.first == tcb.start) break;
                ++i;
            }
            while (i < this.blocks.size()) {
                block = this.blocks.get(i);
                if (block.first == tcb.end) continue block0;
                B.link(block, b_handle);
                ++i;
            }
        }
    }

    private static void link(Block from, Block to) {
        from.tos.add(to);
        to.froms.add(from);
    }

    public void changeLdc_0(List<Block> blocks) {
        for (Block a : blocks) {
            AbstractInsnNode p = a.first.getNext();
            while (p != null && !(p instanceof LabelNode)) {
                switch (p.getOpcode()) {
                    case 18: {
                        int i;
                        LdcInsnNode ldc = (LdcInsnNode)p;
                        Object value = ldc.cst;
                        if (!(value instanceof Integer) || (i = ((Integer)value).intValue()) != 0) break;
                        System.out.println("sssssssssssssssssssssssssssssssssssssssssssss");
                    }
                }
                p = p.getNext();
            }
        }
    }

    public void dump() {
        this.insnList.accept((MethodVisitor)this.tr);
        for (Object o : this.tr.text) {
            System.out.print(o);
        }
        this.tr.text.clear();
    }

    protected void doNew(Block block) {
        HashMap<String, AbstractInsnNode> map = new HashMap<String, AbstractInsnNode>();
        AbstractInsnNode p = block.first.getNext();
        block4: while (p != null && p != block.last) {
            switch (p.getOpcode()) {
                case 187: {
                    AbstractInsnNode store = p.getNext();
                    if (store instanceof VarInsnNode) {
                        map.put(String.valueOf(((TypeInsnNode)p).desc) + Util.var(store), p);
                        p = store.getNext();
                        break;
                    }
                    p = store;
                    break;
                }
                case 183: {
                    MethodInsnNode m = (MethodInsnNode)p;
                    p = p.getNext();
                    if (!m.name.equals("<init>")) continue block4;
                    int length = Type.getArgumentTypes((String)m.desc).length;
                    AbstractInsnNode q = m.getPrevious();
                    while (length-- > 0) {
                        q = q.getPrevious();
                    }
                    AbstractInsnNode _new = (AbstractInsnNode)map.remove(String.valueOf(m.owner) + Util.var(q));
                    if (_new == null) continue block4;
                    AbstractInsnNode _store = _new.getNext();
                    this.insnList.remove(_new);
                    this.insnList.remove(_store);
                    this.insnList.insertBefore(q, _new);
                    this.insnList.insert(_new, new InsnNode(89));
                    this.insnList.remove(q);
                    this.insnList.insert((AbstractInsnNode)m, _store);
                    break;
                }
                default: {
                    p = p.getNext();
                }
            }
        }
    }

    protected void dump(Block block) {
        AbstractInsnNode p = block.first.getNext();
        while (p != null && !(p instanceof LabelNode)) {
            p.accept((MethodVisitor)this.tr);
            p = p.getNext();
        }
        for (Object o : this.tr.text) {
            System.out.print(o);
        }
        this.tr.text.clear();
        System.out.println();
    }

    protected void doLdc(Block block) {
        HashMap<Integer, LdcInsnNode> map = new HashMap<Integer, LdcInsnNode>();
        AbstractInsnNode p = block.first.getNext();
        while (p != null && p != block.last) {
            Integer var;
            if (p.getOpcode() == 18) {
                Integer var2;
                AbstractInsnNode q = p.getNext();
                if (Util.isWrite(q) && (block.out.get(var2 = Integer.valueOf(Util.var(q))) == null || block.out.get(var2) != q)) {
                    map.put(var2, (LdcInsnNode)p);
                    this.insnList.remove(q);
                    q = p.getPrevious();
                    this.insnList.remove(p);
                    p = q;
                }
            } else if (Util.isRead(p)) {
                LdcInsnNode ldc;
                var = Util.var(p);
                if ((block.out.get(var) == null || block.out.get(var) != p) && (ldc = (LdcInsnNode)map.get(var)) != null) {
                    AbstractInsnNode _ldc_copy = ldc.clone(null);
                    this.insnList.insert(p, _ldc_copy);
                    this.insnList.remove(p);
                    p = _ldc_copy;
                }
            } else if (Util.isWrite(p)) {
                var = Util.var(p);
                map.remove(var);
            }
            p = p.getNext();
        }
    }

    protected void doVar(Block block) {
        AbstractInsnNode p = block.first.getNext();
        while (p != null && p != block.last) {
            AbstractInsnNode q;
            if (Util.isWrite(p) && Util.isRead(q = p.getNext()) && Util.isSameVar(p, q)) {
                int var = Util.var(p);
                boolean canDel = true;
                AbstractInsnNode i = q.getNext();
                while (i != null && i != block.last) {
                    if (Util.isRead(i) && var == Util.var(i)) {
                        canDel = false;
                        break;
                    }
                    if (Util.isWrite(i) && var == Util.var(i)) {
                        canDel = true;
                        break;
                    }
                    i = i.getNext();
                }
                if (canDel && block.out.get(var) != p) {
                    AbstractInsnNode t = q.getNext();
                    this.insnList.remove(p);
                    this.insnList.remove(q);
                    p = t.getPrevious();
                }
            }
            p = p.getNext();
        }
    }

    public void doBlock(Block block) {
        this.doNew(block);
        this.doLdc(block);
        this.doVar(block);
        this.doReIndex(block);
    }

    protected void doZeroNull(Block block) {
        AbstractInsnNode p = block.first.getNext();
        while (p != null && p != block.last) {
            if (p instanceof LdcInsnNode) {
                LdcInsnNode ldc = (LdcInsnNode)p;
                Object o = ldc.cst;
                if (o instanceof Integer && (Integer)o == 0) {
                    AbstractInsnNode store = ldc.getNext();
                    int v = Util.var(store);
                    AbstractInsnNode q = store.getNext();
                    boolean replaceAll = false;
                    while (q != null && q != block.last) {
                        if (Util.isRead(q) && Util.var(q) == v && q.getOpcode() == 25) {
                            replaceAll = true;
                            break;
                        }
                        q = q.getNext();
                    }
                    if (replaceAll) {
                        this.rep(ldc, block.last);
                    }
                }
            }
            p = p.getNext();
        }
    }

    void rep(LdcInsnNode ldc, AbstractInsnNode end) {
        ldc.cst = null;
        AbstractInsnNode _store = ldc.getNext();
        int v = Util.var(_store);
        VarInsnNode store_template = new VarInsnNode(58, v);
        VarInsnNode load_template = new VarInsnNode(25, v);
        VarInsnNode store = (VarInsnNode)store_template.clone(null);
        this.insnList.insertBefore(_store, store);
        this.insnList.remove(_store);
        _store = store;
        AbstractInsnNode p = _store.getNext();
        while (p != null && p != end) {
            if (Util.isRead(p)) {
                VarInsnNode load = (VarInsnNode)load_template.clone(null);
                this.insnList.insertBefore(p, load);
                this.insnList.remove(p);
                p = load;
                continue;
            }
            if (!Util.isWrite(p)) continue;
            VarInsnNode store2 = (VarInsnNode)store_template.clone(null);
            this.insnList.insertBefore(p, store2);
            this.insnList.remove(p);
            p = store2;
        }
    }

    protected void doReIndex(Block block) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        AbstractInsnNode p = block.first;
        while (p != block.last) {
            int r;
            if (Util.isWrite(p)) {
                r = Util.var(p);
                if (block.out.get(r) == null) {
                    int nr = this.order();
                    Util.var(p, nr);
                    map.put(r, nr);
                }
            } else if (Util.isRead(p) && block.in.get(r = Util.var(p)) == null && block.out.get(r) == null) {
                Integer v = (Integer)map.get(r);
                if (v == null) {
                    int nr = this.order();
                    Util.var(p, nr);
                    map.put(r, nr);
                } else {
                    Util.var(p, v);
                }
            }
            p = p.getNext();
        }
    }

    public static class Block {
        public LabelNode first;
        public LabelNode last;
        public Map<Integer, AbstractInsnNode> in;
        public Map<Integer, AbstractInsnNode> inType;
        public Map<Integer, AbstractInsnNode> out;
        public Map<Integer, AbstractInsnNode> outType;
        public List<Block> froms = new ArrayList<Block>();
        public List<Block> tos = new ArrayList<Block>();
        private final int index;

        public Block(int index) {
            this.index = index;
        }

        public String toString() {
            TraceMethodVisitor tr = new TraceMethodVisitor();
            AbstractInsnNode p = this.first.getNext();
            while (p != this.last) {
                p.accept((MethodVisitor)tr);
                p = p.getNext();
            }
            StringBuilder sb = new StringBuilder().append("this:").append(this.index);
            StringBuilder temp = new StringBuilder();
            for (Block b : this.froms) {
                temp.append(',').append(b.index);
            }
            if (temp.length() > 0) {
                temp.deleteCharAt(0);
            }
            sb.append(" from:").append('[').append(temp.toString()).append(']');
            temp.setLength(0);
            for (Block b : this.tos) {
                temp.append(',').append(b.index);
            }
            if (temp.length() > 0) {
                temp.deleteCharAt(0);
            }
            sb.append(" to:").append('[').append(temp.toString()).append(']');
            temp.setLength(0);
            for (Integer i : this.in.keySet()) {
                if (this.in.get(i) == null) continue;
                temp.append(',').append(i);
            }
            if (temp.length() > 0) {
                temp.deleteCharAt(0);
            }
            sb.append(" in:").append('[').append(temp.toString()).append(']');
            temp.setLength(0);
            for (Integer i : this.out.keySet()) {
                if (this.out.get(i) == null) continue;
                temp.append(',').append(i);
            }
            if (temp.length() > 0) {
                temp.deleteCharAt(0);
            }
            sb.append(" out:").append('[').append(temp.toString()).append(']');
            sb.append("\n");
            int i = 0;
            for (Object o : tr.text) {
                sb.append(String.format("%04d", i++)).append(o);
            }
            sb.append("");
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LocalType {
        UNKNOWN,
        OBJECT,
        NUMBER;

    }
}

