/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Build;
import android.os.Handler;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import java.io.InputStream;
import org.achartengine.GraphicalView$1;
import org.achartengine.GraphicalView$2;
import org.achartengine.ITouchHandler;
import org.achartengine.TouchHandler;
import org.achartengine.TouchHandlerOld;
import org.achartengine.chart.AbstractChart;
import org.achartengine.chart.RoundChart;
import org.achartengine.chart.XYChart;
import org.achartengine.model.Point;
import org.achartengine.model.SeriesSelection;
import org.achartengine.renderer.DefaultRenderer;
import org.achartengine.renderer.XYMultipleSeriesRenderer;
import org.achartengine.tools.FitZoom;
import org.achartengine.tools.PanListener;
import org.achartengine.tools.Zoom;
import org.achartengine.tools.ZoomListener;

public class GraphicalView
extends View {
    private static final int ZOOM_BUTTONS_COLOR = Color.argb((int)175, (int)150, (int)150, (int)150);
    private Bitmap fitZoomImage;
    private AbstractChart mChart;
    private Context mContext;
    private FitZoom mFitZoom;
    private Handler mHandler;
    private Paint mPaint;
    private Rect mRect;
    private DefaultRenderer mRenderer;
    private ITouchHandler mTouchHandler;
    private Zoom mZoomIn;
    private Zoom mZoomOut;
    private RectF mZoomR;
    private float oldX;
    private float oldY;
    private Bitmap zoomInImage;
    private Bitmap zoomOutImage;
    private int zoomSize;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GraphicalView(Context context, AbstractChart abstractChart) {
        super(context);
        Handler handler;
        Paint paint;
        RectF rectF;
        Rect rect;
        this.mRect = rect = new Rect();
        this.mZoomR = rectF = new RectF();
        this.zoomSize = 50;
        this.mPaint = paint = new Paint();
        this.mContext = context;
        this.mChart = abstractChart;
        this.mHandler = handler = new Handler();
        if (this.mChart instanceof XYChart) {
            XYMultipleSeriesRenderer xYMultipleSeriesRenderer = ((XYChart)this.mChart).getRenderer();
            this.mRenderer = xYMultipleSeriesRenderer;
        } else {
            DefaultRenderer defaultRenderer;
            this.mRenderer = defaultRenderer = ((RoundChart)this.mChart).getRenderer();
        }
        if (this.mRenderer.isZoomButtonsVisible()) {
            Bitmap bitmap;
            Bitmap bitmap2;
            Bitmap bitmap3;
            this.zoomInImage = bitmap3 = BitmapFactory.decodeStream((InputStream)GraphicalView.class.getResourceAsStream("image/zoom_in.png"));
            this.zoomOutImage = bitmap2 = BitmapFactory.decodeStream((InputStream)GraphicalView.class.getResourceAsStream("image/zoom_out.png"));
            this.fitZoomImage = bitmap = BitmapFactory.decodeStream((InputStream)GraphicalView.class.getResourceAsStream("image/zoom-1.png"));
        }
        if (this.mRenderer instanceof XYMultipleSeriesRenderer && ((XYMultipleSeriesRenderer)this.mRenderer).getMarginsColor() == 0) {
            XYMultipleSeriesRenderer xYMultipleSeriesRenderer = (XYMultipleSeriesRenderer)this.mRenderer;
            int n = this.mPaint.getColor();
            xYMultipleSeriesRenderer.setMarginsColor(n);
        }
        if (this.mRenderer.isZoomEnabled() && this.mRenderer.isZoomButtonsVisible() || this.mRenderer.isExternalZoomEnabled()) {
            FitZoom fitZoom;
            Zoom zoom;
            Zoom zoom2;
            AbstractChart abstractChart2 = this.mChart;
            float f = this.mRenderer.getZoomRate();
            this.mZoomIn = zoom2 = new Zoom(abstractChart2, true, f);
            AbstractChart abstractChart3 = this.mChart;
            float f2 = this.mRenderer.getZoomRate();
            this.mZoomOut = zoom = new Zoom(abstractChart3, null, f2);
            AbstractChart abstractChart4 = this.mChart;
            this.mFitZoom = fitZoom = new FitZoom(abstractChart4);
        }
        int n = 7;
        try {
            int n2 = Integer.valueOf(Build.VERSION.SDK);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (n < 7) {
            AbstractChart abstractChart5 = this.mChart;
            TouchHandlerOld touchHandlerOld = new TouchHandlerOld(this, abstractChart5);
            this.mTouchHandler = touchHandlerOld;
            return;
        }
        AbstractChart abstractChart6 = this.mChart;
        TouchHandler touchHandler = new TouchHandler(this, abstractChart6);
        this.mTouchHandler = touchHandler;
    }

    public void addPanListener(PanListener panListener) {
        this.mTouchHandler.addPanListener(panListener);
    }

    public void addZoomListener(ZoomListener zoomListener, boolean bl, boolean bl2) {
        if (bl) {
            if (this.mZoomIn != null) {
                this.mZoomIn.addZoomListener(zoomListener);
                this.mZoomOut.addZoomListener(zoomListener);
            }
            if (bl2) {
                this.mTouchHandler.addZoomListener(zoomListener);
            }
        }
    }

    public SeriesSelection getCurrentSeriesAndPoint() {
        AbstractChart abstractChart = this.mChart;
        float f = this.oldX;
        float f2 = this.oldY;
        Point point = new Point(f, f2);
        return abstractChart.getSeriesAndPointForScreenCoordinate(point);
    }

    protected RectF getZoomRectangle() {
        return this.mZoomR;
    }

    protected void onDraw(Canvas canvas) {
        Paint paint = null;
        super.onDraw(canvas);
        Rect rect = this.mRect;
        canvas.getClipBounds(rect);
        int n = this.mRect.top;
        int n2 = this.mRect.left;
        int n3 = this.mRect.width();
        int n4 = this.mRect.height();
        if (this.mRenderer.isInScroll()) {
            n = 0;
            n2 = 0;
            n3 = this.getMeasuredWidth();
            n4 = this.getMeasuredHeight();
        }
        String string2 = "width = " + n3 + "; height= " + n4;
        Log.i((String)"mChart", (String)string2);
        AbstractChart abstractChart = this.mChart;
        Paint paint2 = this.mPaint;
        Canvas canvas2 = canvas;
        abstractChart.draw(canvas2, n2, n, n3, n4, paint2);
        if (this.mRenderer != null && this.mRenderer.isZoomEnabled() && this.mRenderer.isZoomButtonsVisible()) {
            int n5;
            Paint paint3 = this.mPaint;
            int n6 = ZOOM_BUTTONS_COLOR;
            paint3.setColor(n6);
            int n7 = this.zoomSize;
            int n8 = Math.min(n3, n4) / 7;
            this.zoomSize = n5 = Math.max(n7, n8);
            RectF rectF = this.mZoomR;
            int n9 = n2 + n3;
            int n10 = this.zoomSize * 3;
            float f = n9 - n10;
            float f2 = n + n4;
            float f3 = (float)this.zoomSize * 1061578342;
            float f4 = f2 - f3;
            float f5 = n2 + n3;
            float f6 = n + n4;
            rectF.set(f, f4, f5, f6);
            RectF rectF2 = this.mZoomR;
            float f7 = this.zoomSize / 3;
            float f8 = this.zoomSize / 3;
            Paint paint4 = this.mPaint;
            canvas.drawRoundRect(rectF2, f7, f8, paint4);
            float f9 = n + n4;
            float f10 = (float)this.zoomSize * 1059061760;
            float f11 = f9 - f10;
            Bitmap bitmap = this.zoomInImage;
            float f12 = n2 + n3;
            float f13 = (float)this.zoomSize * 0x40300000;
            float f14 = f12 - f13;
            canvas.drawBitmap(bitmap, f14, f11, paint);
            Bitmap bitmap2 = this.zoomOutImage;
            float f15 = n2 + n3;
            float f16 = (float)this.zoomSize * 1071644672;
            float f17 = f15 - f16;
            canvas.drawBitmap(bitmap2, f17, f11, paint);
            Bitmap bitmap3 = this.fitZoomImage;
            float f18 = n2 + n3;
            float f19 = (float)this.zoomSize * 1061158912;
            float f20 = f18 - f19;
            canvas.drawBitmap(bitmap3, f20, f11, paint);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onTouchEvent(MotionEvent motionEvent) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        DefaultRenderer defaultRenderer;
        int n = motionEvent.getAction();
        if (!n) {
            float f;
            float f2;
            this.oldX = f2 = motionEvent.getX();
            this.oldY = f = motionEvent.getY();
        }
        if ((defaultRenderer = this.mRenderer) != null && ((bl3 = this.mRenderer.isPanEnabled()) || (bl2 = this.mRenderer.isZoomEnabled())) && (bl = this.mTouchHandler.handleTouch(motionEvent))) {
            return n != 0;
        }
        boolean bl4 = super.onTouchEvent(motionEvent);
        return n != 0;
    }

    public void removePanListener(PanListener panListener) {
        this.mTouchHandler.removePanListener(panListener);
    }

    public void removeZoomListener(ZoomListener zoomListener) {
        synchronized (this) {
            if (this.mZoomIn != null) {
                this.mZoomIn.removeZoomListener(zoomListener);
                this.mZoomOut.removeZoomListener(zoomListener);
            }
            this.mTouchHandler.removeZoomListener(zoomListener);
            return;
        }
    }

    public void repaint() {
        Handler handler = this.mHandler;
        GraphicalView$1 graphicalView$1 = new GraphicalView$1(this);
        handler.post((Runnable)graphicalView$1);
    }

    public void repaint(int n, int n2, int n3, int n4) {
        Handler handler = this.mHandler;
        GraphicalView graphicalView = this;
        int n5 = n;
        int n6 = n2;
        int n7 = n3;
        int n8 = n4;
        GraphicalView$2 graphicalView$2 = new GraphicalView$2(graphicalView, n5, n6, n7, n8);
        handler.post((Runnable)graphicalView$2);
    }

    public void setZoomRate(float f) {
        if (this.mZoomIn != null && this.mZoomOut != null) {
            this.mZoomIn.setZoomRate(f);
            this.mZoomOut.setZoomRate(f);
        }
    }

    public Bitmap toBitmap() {
        boolean bl = true;
        this.setDrawingCacheEnabled((boolean)null);
        if (!this.isDrawingCacheEnabled()) {
            this.setDrawingCacheEnabled(bl);
        }
        if (this.mRenderer.isApplyBackgroundColor()) {
            int n = this.mRenderer.getBackgroundColor();
            this.setDrawingCacheBackgroundColor(n);
        }
        this.setDrawingCacheQuality(0x100000);
        return this.getDrawingCache(bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double[] toRealPoint(int n) {
        boolean bl = this.mChart instanceof XYChart;
        if (!bl) return false;
        XYChart xYChart = (XYChart)this.mChart;
        bl = this.oldX;
        float f = this.oldY;
        double[] dArray = xYChart.toRealPoint((float)bl, f, n);
        return bl;
    }

    public void zoomIn() {
        if (this.mZoomIn != null) {
            this.mZoomIn.apply(0);
            this.repaint();
        }
    }

    public void zoomOut() {
        if (this.mZoomOut != null) {
            this.mZoomOut.apply(0);
            this.repaint();
        }
    }

    public void zoomReset() {
        if (this.mFitZoom != null) {
            this.mFitZoom.apply();
            this.mZoomIn.notifyZoomResetListeners();
            this.repaint();
        }
    }
}

