/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.src;

import brut.androlib.AndrolibException;
import brut.androlib.src.TypeName;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jf.dexlib.Code.Analysis.RegisterType;

public class DebugInjector {
    private final ListIterator<String> mIt;
    private final StringBuilder mOut;
    private boolean mFirstInstruction = true;
    private final Set<String> mInitializedRegisters = new HashSet<String>();
    private static final Pattern REGISTER_INFO_PATTERN = Pattern.compile("((?:p|v)\\d+)=\\(([^)]+)\\);");

    public static void inject(ListIterator<String> it, StringBuilder out) throws AndrolibException {
        new DebugInjector(it, out).inject();
    }

    private DebugInjector(ListIterator<String> it, StringBuilder out) {
        this.mIt = it;
        this.mOut = out;
    }

    private void inject() throws AndrolibException {
        String definition = this.nextAndAppend();
        if (definition.contains(" abstract ") || definition.contains(" native ")) {
            this.nextAndAppend();
            return;
        }
        this.injectParameters(definition);
        boolean end = false;
        while (!end) {
            end = this.step();
        }
    }

    private void injectParameters(String definition) throws AndrolibException {
        int i;
        int pos = definition.indexOf(40);
        if (pos == -1) {
            throw new AndrolibException();
        }
        int pos2 = definition.indexOf(41, pos);
        if (pos2 == -1) {
            throw new AndrolibException();
        }
        String params = definition.substring(pos + 1, pos2);
        int argc = TypeName.listFromInternalName(params).size() + i;
        for (i = definition.contains(" static ") ? 0 : 1; i < argc; ++i) {
            this.mOut.append(".parameter \"p").append(i).append("\"\n");
        }
    }

    private boolean step() {
        String line = this.next();
        if (line.isEmpty()) {
            return false;
        }
        switch (line.charAt(0)) {
            case '#': {
                return this.processComment(line);
            }
            case ':': {
                this.append(line);
                return false;
            }
            case '.': {
                return this.processDirective(line);
            }
        }
        return this.processInstruction(line);
    }

    private boolean processComment(String line) {
        if (this.mFirstInstruction) {
            return false;
        }
        Matcher m = REGISTER_INFO_PATTERN.matcher(line);
        block12: while (m.find()) {
            String localName = m.group(1);
            String localType = null;
            switch (RegisterType.Category.valueOf(m.group(2))) {
                case Reference: 
                case Null: 
                case UninitRef: 
                case UninitThis: {
                    localType = "Ljava/lang/Object;";
                    break;
                }
                case Boolean: {
                    localType = "Z";
                    break;
                }
                case Integer: 
                case One: 
                case Unknown: {
                    localType = "I";
                    break;
                }
                case Uninit: 
                case Conflicted: {
                    if (!this.mInitializedRegisters.remove(localName)) continue block12;
                    this.mOut.append(".end local ").append(localName).append('\n');
                    continue block12;
                }
                case Short: 
                case PosShort: {
                    localType = "S";
                    break;
                }
                case Byte: 
                case PosByte: {
                    localType = "B";
                    break;
                }
                case Char: {
                    localType = "C";
                    break;
                }
                case Float: {
                    localType = "F";
                    break;
                }
                case LongHi: 
                case LongLo: {
                    localType = "J";
                    break;
                }
                case DoubleHi: 
                case DoubleLo: {
                    localType = "D";
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            this.mInitializedRegisters.add(localName);
            this.mOut.append(".local ").append(localName).append(", ").append(localName).append(':').append(localType).append('\n');
        }
        return false;
    }

    private boolean processDirective(String line) {
        block3: {
            String line2 = line.substring(1);
            if (line2.startsWith("line ") || line2.equals("prologue") || line2.startsWith("parameter") || line2.startsWith("local ") || line2.startsWith("end local ")) {
                return false;
            }
            this.append(line);
            if (line2.equals("end method")) {
                return true;
            }
            if (!line2.startsWith("annotation ") && !line2.equals("sparse-switch") && !line2.startsWith("packed-switch ") && !line2.startsWith("array-data ")) break block3;
            while (!(line2 = this.nextAndAppend()).startsWith(".end ")) {
            }
        }
        return false;
    }

    private boolean processInstruction(String line) {
        if (this.mFirstInstruction) {
            this.mOut.append(".prologue\n");
            this.mFirstInstruction = false;
        }
        this.mOut.append(".line ").append(this.mIt.nextIndex()).append('\n').append(line).append('\n');
        return false;
    }

    private String next() {
        return this.mIt.next().trim();
    }

    private String nextAndAppend() {
        String line = this.next();
        this.append(line);
        return line;
    }

    private void append(String append) {
        this.mOut.append(append).append('\n');
    }
}

