/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib;

import brut.androlib.AndrolibException;
import brut.androlib.ApktoolProperties;
import brut.androlib.java.AndrolibJava;
import brut.androlib.res.AndrolibResources;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResTable;
import brut.androlib.res.util.ExtFile;
import brut.androlib.src.SmaliBuilder;
import brut.androlib.src.SmaliDecoder;
import brut.common.BrutException;
import brut.directory.Directory;
import brut.directory.DirectoryException;
import brut.util.BrutIO;
import brut.util.OS;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class Androlib {
    private final AndrolibResources mAndRes = new AndrolibResources();
    private static final Logger LOGGER = Logger.getLogger(Androlib.class.getName());
    private static final String SMALI_DIRNAME = "smali";
    private static final String APK_DIRNAME = "build/apk";
    private static final String[] APK_RESOURCES_FILENAMES = new String[]{"resources.arsc", "AndroidManifest.xml", "res"};
    private static final String[] APK_RESOURCES_WITHOUT_RES_FILENAMES = new String[]{"resources.arsc", "AndroidManifest.xml"};
    private static final String[] APP_RESOURCES_FILENAMES = new String[]{"AndroidManifest.xml", "res"};

    public ResTable getResTable(ExtFile apkFile) throws AndrolibException {
        return this.mAndRes.getResTable(apkFile);
    }

    public void decodeSourcesRaw(ExtFile apkFile, File outDir, boolean debug) throws AndrolibException {
        try {
            if (debug) {
                LOGGER.warning("Debug mode not available.");
            }
            Directory apk = apkFile.getDirectory();
            LOGGER.info("Copying raw classes.dex file...");
            apkFile.getDirectory().copyToDir(outDir, "classes.dex");
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    public void decodeSourcesSmali(File apkFile, File outDir, boolean debug) throws AndrolibException {
        try {
            File smaliDir = new File(outDir, SMALI_DIRNAME);
            OS.rmdir(smaliDir);
            smaliDir.mkdirs();
            LOGGER.info("Baksmaling...");
            SmaliDecoder.decode(apkFile, smaliDir, debug);
        }
        catch (BrutException ex) {
            throw new AndrolibException(ex);
        }
    }

    public void decodeSourcesJava(ExtFile apkFile, File outDir, boolean debug) throws AndrolibException {
        LOGGER.info("Decoding Java sources...");
        new AndrolibJava().decode(apkFile, outDir);
    }

    public void decodeResourcesRaw(ExtFile apkFile, File outDir) throws AndrolibException {
        try {
            Directory apk = apkFile.getDirectory();
            LOGGER.info("Copying raw resources...");
            apkFile.getDirectory().copyToDir(outDir, APK_RESOURCES_FILENAMES);
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    public void decodeResourcesFull(ExtFile apkFile, File outDir, ResTable resTable) throws AndrolibException {
        this.mAndRes.decode(resTable, apkFile, outDir);
    }

    public void decodeRawFiles(ExtFile apkFile, File outDir) throws AndrolibException {
        LOGGER.info("Copying assets and libs...");
        try {
            Directory in = apkFile.getDirectory();
            if (in.containsDir("assets")) {
                in.copyToDir(outDir, "assets");
            }
            if (in.containsDir("lib")) {
                in.copyToDir(outDir, "lib");
            }
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    public void writeMetaFile(File mOutDir, Map<String, Object> meta) throws AndrolibException {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml(options);
        OutputStreamWriter writer = null;
        try {
            writer = new FileWriter(new File(mOutDir, "apktool.yml"));
            yaml.dump(meta, writer);
        }
        catch (IOException ex) {
            throw new AndrolibException(ex);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    public Map<String, Object> readMetaFile(ExtFile appDir) throws AndrolibException {
        InputStream in = null;
        try {
            in = appDir.getDirectory().getFileInput("apktool.yml");
            Yaml yaml = new Yaml();
            Map map = (Map)yaml.load(in);
            return map;
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    public void build(File appDir, File outFile, boolean forceBuildAll, boolean debug) throws AndrolibException {
        this.build(new ExtFile(appDir), outFile, forceBuildAll, debug);
    }

    public void build(ExtFile appDir, File outFile, boolean forceBuildAll, boolean debug) throws AndrolibException {
        boolean framework;
        Map<String, Object> meta = this.readMetaFile(appDir);
        Object t1 = meta.get("isFrameworkApk");
        boolean bl = framework = t1 == null ? false : (Boolean)t1;
        if (outFile == null) {
            String outFileName = (String)meta.get("apkFileName");
            outFile = new File(appDir, "dist" + File.separator + (outFileName == null ? "out.apk" : outFileName));
        }
        new File(appDir, APK_DIRNAME).mkdirs();
        this.buildSources(appDir, forceBuildAll, debug);
        this.buildResources(appDir, forceBuildAll, framework, (Map)meta.get("usesFramework"));
        this.buildLib(appDir, forceBuildAll);
        this.buildApk(appDir, outFile, framework);
    }

    public void buildSources(File appDir, boolean forceBuildAll, boolean debug) throws AndrolibException {
        if (!(this.buildSourcesRaw(appDir, forceBuildAll, debug) || this.buildSourcesSmali(appDir, forceBuildAll, debug) || this.buildSourcesJava(appDir, forceBuildAll, debug))) {
            LOGGER.warning("Could not find sources");
        }
    }

    public boolean buildSourcesRaw(File appDir, boolean forceBuildAll, boolean debug) throws AndrolibException {
        try {
            File working = new File(appDir, "classes.dex");
            if (!working.exists()) {
                return false;
            }
            if (debug) {
                LOGGER.warning("Debug mode not available.");
            }
            File stored = new File(appDir, "build/apk/classes.dex");
            if (forceBuildAll || this.isModified(working, stored)) {
                LOGGER.info("Copying classes.dex file...");
                BrutIO.copyAndClose(new FileInputStream(working), new FileOutputStream(stored));
            }
            return true;
        }
        catch (IOException ex) {
            throw new AndrolibException(ex);
        }
    }

    public boolean buildSourcesSmali(File appDir, boolean forceBuildAll, boolean debug) throws AndrolibException {
        ExtFile smaliDir = new ExtFile(appDir, SMALI_DIRNAME);
        if (!smaliDir.exists()) {
            return false;
        }
        File dex = new File(appDir, "build/apk/classes.dex");
        if (!forceBuildAll) {
            LOGGER.info("Checking whether sources has changed...");
        }
        if (forceBuildAll || this.isModified(smaliDir, dex)) {
            LOGGER.info("Smaling...");
            dex.delete();
            SmaliBuilder.build(smaliDir, dex, debug);
        }
        return true;
    }

    public boolean buildSourcesJava(File appDir, boolean forceBuildAll, boolean debug) throws AndrolibException {
        File javaDir = new File(appDir, "src");
        if (!javaDir.exists()) {
            return false;
        }
        File dex = new File(appDir, "build/apk/classes.dex");
        if (!forceBuildAll) {
            LOGGER.info("Checking whether sources has changed...");
        }
        if (forceBuildAll || this.isModified(javaDir, dex)) {
            LOGGER.info("Building java sources...");
            dex.delete();
            new AndrolibJava().build(javaDir, dex);
        }
        return true;
    }

    public void buildResources(ExtFile appDir, boolean forceBuildAll, boolean framework, Map<String, Object> usesFramework) throws AndrolibException {
        if (!this.buildResourcesRaw(appDir, forceBuildAll) && !this.buildResourcesFull(appDir, forceBuildAll, framework, usesFramework)) {
            LOGGER.warning("Could not find resources");
        }
    }

    public boolean buildResourcesRaw(ExtFile appDir, boolean forceBuildAll) throws AndrolibException {
        try {
            if (!new File(appDir, "resources.arsc").exists()) {
                return false;
            }
            File apkDir = new File(appDir, APK_DIRNAME);
            if (!forceBuildAll) {
                LOGGER.info("Checking whether resources has changed...");
            }
            if (forceBuildAll || this.isModified(this.newFiles(APK_RESOURCES_FILENAMES, appDir), this.newFiles(APK_RESOURCES_FILENAMES, apkDir))) {
                LOGGER.info("Copying raw resources...");
                appDir.getDirectory().copyToDir(apkDir, APK_RESOURCES_FILENAMES);
            }
            return true;
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    public boolean buildResourcesFull(File appDir, boolean forceBuildAll, boolean framework, Map<String, Object> usesFramework) throws AndrolibException {
        try {
            if (!new File(appDir, "res").exists()) {
                return false;
            }
            if (!forceBuildAll) {
                LOGGER.info("Checking whether resources has changed...");
            }
            File apkDir = new File(appDir, APK_DIRNAME);
            if (forceBuildAll || this.isModified(this.newFiles(APP_RESOURCES_FILENAMES, appDir), this.newFiles(APK_RESOURCES_FILENAMES, apkDir))) {
                LOGGER.info("Building resources...");
                File apkFile = File.createTempFile("APKTOOL", null);
                apkFile.delete();
                File ninePatch = new File(appDir, "9patch");
                if (!ninePatch.exists()) {
                    ninePatch = null;
                }
                this.mAndRes.aaptPackage(apkFile, new File(appDir, "AndroidManifest.xml"), new File(appDir, "res"), ninePatch, null, this.parseUsesFramework(usesFramework), false, framework);
                Directory tmpDir = new ExtFile(apkFile).getDirectory();
                tmpDir.copyToDir(apkDir, tmpDir.containsDir("res") ? APK_RESOURCES_FILENAMES : APK_RESOURCES_WITHOUT_RES_FILENAMES);
            }
            return true;
        }
        catch (IOException ex) {
            throw new AndrolibException(ex);
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    public void buildLib(File appDir, boolean forceBuildAll) throws AndrolibException {
        File working = new File(appDir, "lib");
        if (!working.exists()) {
            return;
        }
        File stored = new File(appDir, "build/apk/lib");
        if (forceBuildAll || this.isModified(working, stored)) {
            LOGGER.info("Copying libs...");
            try {
                OS.rmdir(stored);
                OS.cpdir(working, stored);
            }
            catch (BrutException ex) {
                throw new AndrolibException(ex);
            }
        }
    }

    public void buildApk(File appDir, File outApk, boolean framework) throws AndrolibException {
        LOGGER.info("Building apk file...");
        if (outApk.exists()) {
            outApk.delete();
        } else {
            File outDir = outApk.getParentFile();
            if (outDir != null && !outDir.exists()) {
                outDir.mkdirs();
            }
        }
        File assetDir = new File(appDir, "assets");
        if (!assetDir.exists()) {
            assetDir = null;
        }
        this.mAndRes.aaptPackage(outApk, null, null, new File(appDir, APK_DIRNAME), assetDir, null, false, framework);
    }

    public void publicizeResources(File arscFile) throws AndrolibException {
        this.mAndRes.publicizeResources(arscFile);
    }

    public void installFramework(File frameFile, String tag) throws AndrolibException {
        this.mAndRes.installFramework(frameFile, tag);
    }

    public boolean isFrameworkApk(ResTable resTable) {
        for (ResPackage pkg : resTable.listMainPackages()) {
            if (pkg.getId() >= 64) continue;
            return true;
        }
        return false;
    }

    public static String getVersion() {
        String version = ApktoolProperties.get("version");
        return version.endsWith("-SNAPSHOT") ? version.substring(0, version.length() - 9) + '.' + ApktoolProperties.get("git.commit.id.abbrev") : version;
    }

    private File[] parseUsesFramework(Map<String, Object> usesFramework) throws AndrolibException {
        if (usesFramework == null) {
            return null;
        }
        List ids = (List)usesFramework.get("ids");
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        String tag = (String)usesFramework.get("tag");
        File[] files = new File[ids.size()];
        int i = 0;
        Iterator i$ = ids.iterator();
        while (i$.hasNext()) {
            int id = (Integer)i$.next();
            files[i++] = this.mAndRes.getFrameworkApk(id, tag);
        }
        return files;
    }

    private boolean isModified(File working, File stored) {
        if (!stored.exists()) {
            return true;
        }
        return BrutIO.recursiveModifiedTime(working) > BrutIO.recursiveModifiedTime(stored);
    }

    private boolean isModified(File[] working, File[] stored) {
        for (int i = 0; i < stored.length; ++i) {
            if (stored[i].exists()) continue;
            return true;
        }
        return BrutIO.recursiveModifiedTime(working) > BrutIO.recursiveModifiedTime(stored);
    }

    private File[] newFiles(String[] names, File dir) {
        File[] files = new File[names.length];
        for (int i = 0; i < names.length; ++i) {
            files[i] = new File(dir, names[i]);
        }
        return files;
    }
}

