/*
 * Decompiled with CFR 0.152.
 */
package com.mikameng.tool;

import java.io.File;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import pxb.android.dex2jar.v3.Main;

public class App
implements SelectionListener {
    private static final Logger logger = Logger.getLogger(App.class);
    private Display display;
    private Shell shell;
    private Button browserButton;
    private Button deCompileButton;
    private Button aboutButton;
    private Button closeButton;
    private Text apkFileText;
    private Label statusLabel;
    private boolean running;
    private String apkFile;

    public App() {
        try {
            this.display = new Display();
            this.shell = new Shell(this.display, 35040);
            GridData gridData = new GridData(1808);
            this.shell.setLayoutData((Object)gridData);
            this.shell.setLayout((Layout)new GridLayout(1, false));
            this.shell.setText("Android APK\u53cd\u7f16\u8bd1\u5de5\u5177");
            this.createUI();
            this.shell.setImage(new Image((Device)this.display, App.class.getResourceAsStream("13.png")));
            this.shell.pack();
            this.shell.open();
            while (!this.shell.isDisposed()) {
                if (this.display.readAndDispatch()) continue;
                this.display.sleep();
            }
            this.display.dispose();
        }
        catch (Exception e) {
            logger.error((Object)"\u8fd0\u884c\u51fa\u9519: ", (Throwable)e);
            System.exit(1);
        }
    }

    private void createUI() {
        GridData buttonData = new GridData();
        buttonData.widthHint = 100;
        buttonData.heightHint = 35;
        GridData textData = new GridData();
        textData.heightHint = 30;
        textData.widthHint = 300;
        Group group = new Group((Composite)this.shell, 0);
        GridData groupData = new GridData(64);
        groupData.verticalIndent = 10;
        group.setLayoutData((Object)groupData);
        group.setLayout((Layout)new GridLayout(4, false));
        group.setText("\u8bbe\u7f6e");
        Label label = new Label((Composite)group, 0);
        label.setText("Android APK:");
        this.apkFileText = new Text((Composite)group, 18436);
        this.apkFileText.setLayoutData((Object)textData);
        this.browserButton = new Button((Composite)group, 8);
        this.browserButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.browserButton.setText("\u6d4f\u89c8");
        this.browserButton.setLayoutData((Object)buttonData);
        this.browserButton.addSelectionListener((SelectionListener)this);
        Composite composite = new Composite((Composite)this.shell, 0);
        GridData buttonsData = new GridData(128);
        buttonsData.verticalIndent = 10;
        composite.setLayoutData((Object)buttonsData);
        composite.setLayout((Layout)new GridLayout(3, false));
        this.deCompileButton = new Button(composite, 8);
        this.deCompileButton.setText("\u53cd\u7f16\u8bd1");
        this.deCompileButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.deCompileButton.addSelectionListener((SelectionListener)this);
        this.deCompileButton.setLayoutData((Object)buttonData);
        this.aboutButton = new Button(composite, 8);
        this.aboutButton.setText("\u5173\u4e8e");
        this.aboutButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.aboutButton.addSelectionListener((SelectionListener)this);
        this.aboutButton.setLayoutData((Object)buttonData);
        this.closeButton = new Button(composite, 8);
        this.closeButton.setText("\u5173\u95ed");
        this.closeButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.closeButton.addSelectionListener((SelectionListener)this);
        this.closeButton.setLayoutData((Object)buttonData);
        this.statusLabel = new Label((Composite)this.shell, 2048);
        GridData status = new GridData(1800);
        status.horizontalSpan = 0;
        this.statusLabel.setLayoutData((Object)status);
        this.statusLabel.setText("\u5de5\u5177\u5df2\u542f\u52a8");
        logger.info((Object)"\u5de5\u5177\u5df2\u542f\u52a8");
    }

    public static void main(String[] args) {
        BasicConfigurator.configure();
        new App();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Button button = (Button)e.widget;
        if (button == this.browserButton) {
            this.setAPKFile();
        } else if (button == this.closeButton) {
            this.shell.dispose();
            this.display.dispose();
        } else if (button == this.deCompileButton) {
            this.deCompile();
        } else if (button == this.aboutButton) {
            this.about();
        }
    }

    private void about() {
        MessageBox aboutDialog = new MessageBox(this.shell, 8);
        aboutDialog.setText("\u6ce8\u610f\u4e8b\u9879");
        aboutDialog.setMessage("\u672c\u8f6f\u4ef6\u4ec5\u4f9b\u5b66\u4e60\u4e4b\u7528\uff0c \u8bf7\u52ff\u4f7f\u7528\u975e\u6cd5\u9014\u5f84.\n\u8bf7\u9075\u5faaGoogle\u76f8\u5173\u534f\u8bae\u548c\u76f8\u5173\u6cd5\u5f8b\u6cd5\u89c4");
        aboutDialog.open();
    }

    private void setAPKFile() {
        try {
            FileDialog browserDir = new FileDialog(this.shell);
            browserDir.setText("\u8bf7\u9009\u62e9Android APK\u6587\u4ef6");
            browserDir.setFilterExtensions(new String[]{"*.apk", "*.*"});
            browserDir.setFilterNames(new String[]{"Android APK\u6587\u4ef6", "\u6240\u6709\u6587\u4ef6"});
            String apk = this.apkFileText.getText();
            if (apk == null || apk.trim().length() == 0) {
                apk = ".";
            }
            browserDir.setFilterPath(apk);
            String dir = browserDir.open();
            this.apkFileText.setText(dir);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void deCompile() {
        this.apkFile = this.apkFileText.getText();
        if (this.apkFile == null || this.apkFile.trim().length() == 0 || !this.apkFile.endsWith(".apk")) {
            MessageBox msg = new MessageBox(this.shell, 8);
            msg.setMessage("\u8bf7\u8f93\u5165\u9700\u8981\u53cd\u7f16\u8bd1\u7684Android APK\u6587\u4ef6!");
            msg.setText("\u8b66\u544a:");
            msg.open();
            return;
        }
        if (this.running) {
            MessageBox msg = new MessageBox(this.shell, 8);
            msg.setMessage("\u6b63\u5728\u53cd\u7f16\u8bd1Android APK\u6587\u4ef6\uff0c \u8bf7\u7a0d\u7b49...");
            msg.setText("\u8b66\u544a:");
            msg.open();
            return;
        }
        this.running = true;
        this.deCompileButton.setEnabled(false);
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                new DeCompile().start();
            }
        });
    }

    private void deCompileXml(String dir) throws Exception {
        brut.apktool.Main apkTollMain = new brut.apktool.Main();
        brut.apktool.Main.main((String[])new String[]{"-v", "d", "-s", this.apkFile, dir});
    }

    private void genJar(String apkDir) {
        File file = new File(apkDir, "classes.dex");
        if (!file.exists()) {
            this.openDialog("\u8b66\u544a:", "\u53cd\u7f16\u8bd1Android\u9879\u76ee\u7684\u6839\u76ee\u5f55\u4e0b\u6ca1\u6709\u627e\u5230classes.dex \u6587\u4ef6");
            return;
        }
        Main dexmain = new Main();
        try {
            Main.main((String[])new String[]{file.getAbsolutePath()});
            this.log("\u6210\u529f\u751f\u6210JAR.");
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    App.this.deCompileButton.setEnabled(true);
                    MessageBox msg = new MessageBox(App.this.shell, 2);
                    msg.setMessage("\u6210\u529f\u751f\u6210JAR");
                    msg.setText("\u6210\u529f");
                    msg.open();
                }
            });
        }
        catch (Exception e1) {
            this.log("\u89e3\u6790\u751f\u6210JAR\u9519\u8bef: " + e1.getMessage());
            logger.error((Object)"\u89e3\u6790\u751f\u6210JAR\u9519\u8bef: ", (Throwable)e1);
        }
    }

    private void log(final String msg) {
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                App.this.statusLabel.setText(msg);
            }
        });
        logger.debug((Object)msg);
    }

    private void openDialog(final String title, final String message) {
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                MessageBox msg = new MessageBox(App.this.shell, 8);
                msg.setMessage(message);
                msg.setText(title);
                msg.open();
            }
        });
    }

    class DeCompile
    extends Thread {
        DeCompile() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                String dir = App.this.apkFile.substring(0, App.this.apkFile.indexOf(".apk"));
                App.this.log("\u5f00\u59cb\u53cd\u7f16\u8bd1xml\u6587\u4ef6");
                App.this.deCompileXml(dir);
                App.this.log("\u7ed3\u675f\u53cd\u7f16\u8bd1xml\u6587\u4ef6");
                App.this.log("\u5f00\u59cb\u53cd\u7f16\u8bd1dex\u6587\u4ef6");
                App.this.genJar(dir);
                App.this.log("\u7ed3\u675f\u53cd\u7f16\u8bd1dex\u6587\u4ef6");
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                App.this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageBox msg = new MessageBox(App.this.shell, 8);
                        msg.setMessage("\u53cd\u7f16\u8bd1\u7684Android APK\u6587\u4ef6\u51fa\u9519, \u8be6\u7ec6\u9519\u8bef\u8bf7\u770b\u65e5\u5fd7\u6587\u4ef6.");
                        msg.setText("\u8b66\u544a:");
                        msg.open();
                    }
                });
            }
            finally {
                App.this.running = false;
            }
            App.this.log("\u53cd\u7f16\u8bd1\u5b8c\u6210....");
        }
    }
}

