/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.v3;

import com.googlecode.dex2jar.Annotation;
import com.googlecode.dex2jar.Field;
import com.googlecode.dex2jar.v3.V3AnnAdapter;
import com.googlecode.dex2jar.visitors.DexAnnotationVisitor;
import com.googlecode.dex2jar.visitors.DexFieldVisitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;

public class V3FieldAdapter
implements DexFieldVisitor {
    protected List<Annotation> anns = new ArrayList<Annotation>();
    protected boolean build = false;
    protected ClassVisitor cv;
    protected Field field;
    protected FieldVisitor fv;
    protected Object value;
    protected int accessFlags;

    protected void build() {
        if (!this.build) {
            String signature = null;
            Iterator<Annotation> it = this.anns.iterator();
            while (it.hasNext()) {
                Annotation ann = it.next();
                if (!"Ldalvik/annotation/Signature;".equals(ann.type)) continue;
                it.remove();
                for (Annotation.Item item : ann.items) {
                    if (!item.name.equals("value")) continue;
                    Annotation values = (Annotation)item.value;
                    StringBuilder sb = new StringBuilder();
                    for (Annotation.Item i : values.items) {
                        sb.append(i.value.toString());
                    }
                    signature = sb.toString();
                }
            }
            FieldVisitor fv = this.cv.visitField(this.accessFlags, this.field.getName(), this.field.getType(), signature, this.value);
            if (fv != null) {
                for (Annotation ann : this.anns) {
                    AnnotationVisitor av = fv.visitAnnotation(ann.type, ann.visible);
                    V3AnnAdapter.accept(ann.items, av);
                    av.visitEnd();
                }
            }
            this.fv = fv;
            this.build = true;
        }
    }

    public DexAnnotationVisitor visitAnnotation(String name, boolean visible) {
        Annotation ann = new Annotation(name, visible);
        this.anns.add(ann);
        return new V3AnnAdapter(ann);
    }

    public V3FieldAdapter(ClassVisitor cv, int accessFlags, Field field, Object value) {
        this.cv = cv;
        this.field = field;
        this.value = value;
        this.accessFlags = accessFlags;
    }

    public void visitEnd() {
        this.build();
        if (this.fv != null) {
            this.fv.visitEnd();
        }
    }
}

