/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Format.InstructionWithJumboReference;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.Code.RegisterRangeInstruction;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Item;
import org.jf.dexlib.MethodIdItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.NumberUtils;

public class Instruction5rc
extends InstructionWithJumboReference
implements RegisterRangeInstruction {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private short regCount;
    private short startReg;

    public Instruction5rc(Opcode opcode, int regCount, int startReg, Item referencedItem) {
        super(opcode, referencedItem);
        if (regCount >= 65536) {
            throw new RuntimeException("regCount must be less than 65536");
        }
        if (regCount < 0) {
            throw new RuntimeException("regCount cannot be negative");
        }
        if (startReg >= 65536) {
            throw new RuntimeException("The beginning register of the range must be less than 65536");
        }
        if (startReg < 0) {
            throw new RuntimeException("The beginning register of the range cannot be negative");
        }
        this.regCount = (short)regCount;
        this.startReg = (short)startReg;
        Instruction5rc.checkItem(opcode, referencedItem, regCount);
    }

    private Instruction5rc(DexFile dexFile, Opcode opcode, byte[] buffer, int bufferIndex) {
        super(dexFile, opcode, buffer, bufferIndex);
        this.regCount = (short)NumberUtils.decodeUnsignedShort(buffer, bufferIndex + 6);
        this.startReg = (short)NumberUtils.decodeUnsignedShort(buffer, bufferIndex + 8);
        Instruction5rc.checkItem(opcode, this.getReferencedItem(), this.getRegCount());
    }

    protected void writeInstruction(AnnotatedOutput out, int currentCodeAddress) {
        out.writeByte(255);
        out.writeByte(this.opcode.value);
        out.writeInt(this.getReferencedItem().getIndex());
        out.writeShort(this.regCount);
        out.writeShort(this.startReg);
    }

    public Format getFormat() {
        return Format.Format5rc;
    }

    public int getRegCount() {
        return this.regCount & 0xFFFF;
    }

    public int getStartRegister() {
        return this.startReg & 0xFFFF;
    }

    private static void checkItem(Opcode opcode, Item item, int regCount) {
        if (opcode == Opcode.FILLED_NEW_ARRAY_JUMBO) {
            String type = ((TypeIdItem)item).getTypeDescriptor();
            if (type.charAt(0) != '[') {
                throw new RuntimeException("The type must be an array type");
            }
            if (type.charAt(1) == 'J' || type.charAt(1) == 'D') {
                throw new RuntimeException("The type cannot be an array of longs or doubles");
            }
        } else if (opcode.value >= Opcode.INVOKE_VIRTUAL_JUMBO.value && opcode.value <= Opcode.INVOKE_INTERFACE_JUMBO.value || opcode == Opcode.INVOKE_OBJECT_INIT_JUMBO) {
            MethodIdItem methodIdItem = (MethodIdItem)item;
            int parameterRegisterCount = methodIdItem.getPrototype().getParameterRegisterCount();
            if (opcode != Opcode.INVOKE_STATIC_JUMBO) {
                ++parameterRegisterCount;
            }
            if (parameterRegisterCount != regCount) {
                throw new RuntimeException("regCount does not match the number of arguments of the method");
            }
        }
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] buffer, int bufferIndex) {
            return new Instruction5rc(dexFile, opcode, buffer, bufferIndex);
        }
    }
}

