/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors;

import java.io.IOException;
import java.util.BitSet;
import org.jf.baksmali.Adaptors.MethodItem;
import org.jf.baksmali.Adaptors.RegisterFormatter;
import org.jf.baksmali.baksmali;
import org.jf.dexlib.ClassDataItem;
import org.jf.dexlib.Code.Analysis.AnalyzedInstruction;
import org.jf.dexlib.Code.Analysis.MethodAnalyzer;
import org.jf.dexlib.Code.Analysis.RegisterType;
import org.jf.dexlib.Code.FiveRegisterInstruction;
import org.jf.dexlib.Code.RegisterRangeInstruction;
import org.jf.dexlib.Code.SingleRegisterInstruction;
import org.jf.dexlib.Code.ThreeRegisterInstruction;
import org.jf.dexlib.Code.TwoRegisterInstruction;
import org.jf.dexlib.Util.AccessFlags;
import org.jf.util.IndentingWriter;

public class PreInstructionRegisterInfoMethodItem
extends MethodItem {
    private static AnalyzedInstruction lastInstruction;
    private final AnalyzedInstruction analyzedInstruction;
    private final MethodAnalyzer methodAnalyzer;

    public PreInstructionRegisterInfoMethodItem(AnalyzedInstruction analyzedInstruction, MethodAnalyzer methodAnalyzer, int codeAddress) {
        super(codeAddress);
        this.analyzedInstruction = analyzedInstruction;
        this.methodAnalyzer = methodAnalyzer;
    }

    public double getSortOrder() {
        return 99.9;
    }

    public boolean writeTo(IndentingWriter writer) throws IOException {
        int registerInfo = baksmali.registerInfo;
        int registerCount = this.analyzedInstruction.getRegisterCount();
        BitSet registers = new BitSet(registerCount);
        if ((registerInfo & 0x80) != 0) {
            this.addDiffRegs(registers);
        } else if ((registerInfo & 1) != 0) {
            registers.set(0, registerCount);
        } else if ((registerInfo & 2) != 0) {
            registers.set(0, registerCount);
        } else {
            if ((registerInfo & 8) != 0) {
                this.addArgsRegs(registers);
            }
            if ((registerInfo & 0x20) != 0) {
                this.addMergeRegs(registers, registerCount);
            } else if ((registerInfo & 0x40) != 0 && this.analyzedInstruction.isBeginningInstruction()) {
                this.addParamRegs(registers, registerCount);
            }
        }
        boolean printedSomething = false;
        if ((registerInfo & 0x40) != 0) {
            printedSomething = this.writeFullMergeRegs(writer, registers, registerCount);
        }
        printedSomething |= this.writeRegisterInfo(writer, registers, printedSomething);
        return printedSomething;
    }

    private void addArgsRegs(BitSet registers) {
        if (this.analyzedInstruction.getInstruction() instanceof RegisterRangeInstruction) {
            RegisterRangeInstruction instruction = (RegisterRangeInstruction)((Object)this.analyzedInstruction.getInstruction());
            registers.set(instruction.getStartRegister(), instruction.getStartRegister() + instruction.getRegCount());
        } else if (this.analyzedInstruction.getInstruction() instanceof FiveRegisterInstruction) {
            FiveRegisterInstruction instruction = (FiveRegisterInstruction)((Object)this.analyzedInstruction.getInstruction());
            int regCount = instruction.getRegCount();
            switch (regCount) {
                case 5: {
                    registers.set(instruction.getRegisterA());
                }
                case 4: {
                    registers.set(instruction.getRegisterG());
                }
                case 3: {
                    registers.set(instruction.getRegisterF());
                }
                case 2: {
                    registers.set(instruction.getRegisterE());
                }
                case 1: {
                    registers.set(instruction.getRegisterD());
                }
            }
        } else if (this.analyzedInstruction.getInstruction() instanceof ThreeRegisterInstruction) {
            ThreeRegisterInstruction instruction = (ThreeRegisterInstruction)((Object)this.analyzedInstruction.getInstruction());
            registers.set(instruction.getRegisterA());
            registers.set(instruction.getRegisterB());
            registers.set(instruction.getRegisterC());
        } else if (this.analyzedInstruction.getInstruction() instanceof TwoRegisterInstruction) {
            TwoRegisterInstruction instruction = (TwoRegisterInstruction)((Object)this.analyzedInstruction.getInstruction());
            registers.set(instruction.getRegisterA());
            registers.set(instruction.getRegisterB());
        } else if (this.analyzedInstruction.getInstruction() instanceof SingleRegisterInstruction) {
            SingleRegisterInstruction instruction = (SingleRegisterInstruction)((Object)this.analyzedInstruction.getInstruction());
            registers.set(instruction.getRegisterA());
        }
    }

    private void addMergeRegs(BitSet registers, int registerCount) {
        if (this.analyzedInstruction.isBeginningInstruction()) {
            this.addParamRegs(registers, registerCount);
        }
        if (this.analyzedInstruction.getPredecessorCount() <= 1) {
            return;
        }
        for (int registerNum = 0; registerNum < registerCount; ++registerNum) {
            RegisterType mergedRegisterType = this.analyzedInstruction.getPreInstructionRegisterType(registerNum);
            for (AnalyzedInstruction predecessor : this.analyzedInstruction.getPredecessors()) {
                if (predecessor.getPostInstructionRegisterType(registerNum) == mergedRegisterType) continue;
                registers.set(registerNum);
            }
        }
    }

    private void addDiffRegs(BitSet registers) {
        if (!this.analyzedInstruction.isBeginningInstruction()) {
            for (int i = 0; i < this.analyzedInstruction.getRegisterCount(); ++i) {
                if (PreInstructionRegisterInfoMethodItem.lastInstruction.getPreInstructionRegisterType((int)i).category == this.analyzedInstruction.getPreInstructionRegisterType((int)i).category) continue;
                registers.set(i);
            }
        }
        lastInstruction = this.analyzedInstruction;
    }

    private void addParamRegs(BitSet registers, int registerCount) {
        ClassDataItem.EncodedMethod encodedMethod = this.methodAnalyzer.getMethod();
        int parameterRegisterCount = encodedMethod.method.getPrototype().getParameterRegisterCount();
        if ((encodedMethod.accessFlags & AccessFlags.STATIC.getValue()) == 0) {
            ++parameterRegisterCount;
        }
        registers.set(registerCount - parameterRegisterCount, registerCount);
    }

    private boolean writeFullMergeRegs(IndentingWriter writer, BitSet registers, int registerCount) throws IOException {
        if (this.analyzedInstruction.getPredecessorCount() <= 1) {
            return false;
        }
        ClassDataItem.EncodedMethod encodedMethod = this.methodAnalyzer.getMethod();
        boolean firstRegister = true;
        for (int registerNum = 0; registerNum < registerCount; ++registerNum) {
            RegisterType mergedRegisterType = this.analyzedInstruction.getPreInstructionRegisterType(registerNum);
            boolean addRegister = false;
            for (AnalyzedInstruction predecessor : this.analyzedInstruction.getPredecessors()) {
                RegisterType predecessorRegisterType = predecessor.getPostInstructionRegisterType(registerNum);
                if (predecessorRegisterType.category == RegisterType.Category.Unknown || predecessorRegisterType == mergedRegisterType) continue;
                addRegister = true;
                break;
            }
            if (!addRegister) continue;
            if (firstRegister) {
                firstRegister = false;
            } else {
                writer.write(10);
            }
            writer.write(35);
            RegisterFormatter.writeTo(writer, encodedMethod.codeItem, registerNum);
            writer.write(61);
            this.analyzedInstruction.getPreInstructionRegisterType(registerNum).writeTo(writer);
            writer.write(":merge{");
            boolean first = true;
            for (AnalyzedInstruction predecessor : this.analyzedInstruction.getPredecessors()) {
                RegisterType predecessorRegisterType = predecessor.getPostInstructionRegisterType(registerNum);
                if (!first) {
                    writer.write(44);
                }
                if (predecessor.getInstructionIndex() == -1) {
                    writer.write("Start:");
                } else {
                    writer.write("0x");
                    writer.printUnsignedLongAsHex(this.methodAnalyzer.getInstructionAddress(predecessor));
                    writer.write(58);
                }
                predecessorRegisterType.writeTo(writer);
                first = false;
            }
            writer.write(125);
            registers.clear(registerNum);
        }
        return !firstRegister;
    }

    private boolean writeRegisterInfo(IndentingWriter writer, BitSet registers, boolean addNewline) throws IOException {
        ClassDataItem.EncodedMethod encodedMethod = this.methodAnalyzer.getMethod();
        int registerNum = registers.nextSetBit(0);
        if (registerNum < 0) {
            return false;
        }
        if (addNewline) {
            writer.write(10);
        }
        writer.write(35);
        while (registerNum >= 0) {
            RegisterType registerType = this.analyzedInstruction.getPreInstructionRegisterType(registerNum);
            RegisterFormatter.writeTo(writer, encodedMethod.codeItem, registerNum);
            writer.write(61);
            if (registerType == null) {
                writer.write("null");
            } else {
                registerType.writeTo(writer);
            }
            writer.write(59);
            registerNum = registers.nextSetBit(registerNum + 1);
        }
        return true;
    }
}

