/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors.EncodedValue;

import java.io.IOException;
import org.jf.baksmali.Adaptors.EncodedValue.AnnotationEncodedValueAdaptor;
import org.jf.baksmali.Adaptors.EncodedValue.ArrayEncodedValueAdaptor;
import org.jf.baksmali.Adaptors.EncodedValue.EnumEncodedValueAdaptor;
import org.jf.baksmali.Adaptors.ReferenceFormatter;
import org.jf.baksmali.Renderers.BooleanRenderer;
import org.jf.baksmali.Renderers.ByteRenderer;
import org.jf.baksmali.Renderers.CharRenderer;
import org.jf.baksmali.Renderers.DoubleRenderer;
import org.jf.baksmali.Renderers.FloatRenderer;
import org.jf.baksmali.Renderers.IntegerRenderer;
import org.jf.baksmali.Renderers.LongRenderer;
import org.jf.baksmali.Renderers.ShortRenderer;
import org.jf.dexlib.EncodedValue.AnnotationEncodedValue;
import org.jf.dexlib.EncodedValue.ArrayEncodedValue;
import org.jf.dexlib.EncodedValue.BooleanEncodedValue;
import org.jf.dexlib.EncodedValue.ByteEncodedValue;
import org.jf.dexlib.EncodedValue.CharEncodedValue;
import org.jf.dexlib.EncodedValue.DoubleEncodedValue;
import org.jf.dexlib.EncodedValue.EncodedValue;
import org.jf.dexlib.EncodedValue.EnumEncodedValue;
import org.jf.dexlib.EncodedValue.FieldEncodedValue;
import org.jf.dexlib.EncodedValue.FloatEncodedValue;
import org.jf.dexlib.EncodedValue.IntEncodedValue;
import org.jf.dexlib.EncodedValue.LongEncodedValue;
import org.jf.dexlib.EncodedValue.MethodEncodedValue;
import org.jf.dexlib.EncodedValue.ShortEncodedValue;
import org.jf.dexlib.EncodedValue.StringEncodedValue;
import org.jf.dexlib.EncodedValue.TypeEncodedValue;
import org.jf.util.IndentingWriter;

public abstract class EncodedValueAdaptor {
    public static void writeTo(IndentingWriter writer, EncodedValue encodedValue) throws IOException {
        switch (encodedValue.getValueType()) {
            case VALUE_ANNOTATION: {
                AnnotationEncodedValueAdaptor.writeTo(writer, (AnnotationEncodedValue)encodedValue);
                return;
            }
            case VALUE_ARRAY: {
                ArrayEncodedValueAdaptor.writeTo(writer, (ArrayEncodedValue)encodedValue);
                return;
            }
            case VALUE_BOOLEAN: {
                BooleanRenderer.writeTo(writer, ((BooleanEncodedValue)encodedValue).value);
                return;
            }
            case VALUE_BYTE: {
                ByteRenderer.writeTo(writer, ((ByteEncodedValue)encodedValue).value);
                return;
            }
            case VALUE_CHAR: {
                CharRenderer.writeTo(writer, ((CharEncodedValue)encodedValue).value);
                return;
            }
            case VALUE_DOUBLE: {
                DoubleRenderer.writeTo(writer, ((DoubleEncodedValue)encodedValue).value);
                return;
            }
            case VALUE_ENUM: {
                EnumEncodedValueAdaptor.writeTo(writer, ((EnumEncodedValue)encodedValue).value);
                return;
            }
            case VALUE_FIELD: {
                ReferenceFormatter.writeFieldReference(writer, ((FieldEncodedValue)encodedValue).value);
                return;
            }
            case VALUE_FLOAT: {
                FloatRenderer.writeTo(writer, ((FloatEncodedValue)encodedValue).value);
                return;
            }
            case VALUE_INT: {
                IntegerRenderer.writeTo(writer, ((IntEncodedValue)encodedValue).value);
                return;
            }
            case VALUE_LONG: {
                LongRenderer.writeTo(writer, ((LongEncodedValue)encodedValue).value);
                return;
            }
            case VALUE_METHOD: {
                ReferenceFormatter.writeMethodReference(writer, ((MethodEncodedValue)encodedValue).value);
                return;
            }
            case VALUE_NULL: {
                writer.write("null");
                return;
            }
            case VALUE_SHORT: {
                ShortRenderer.writeTo(writer, ((ShortEncodedValue)encodedValue).value);
                return;
            }
            case VALUE_STRING: {
                ReferenceFormatter.writeStringReference(writer, ((StringEncodedValue)encodedValue).value);
                return;
            }
            case VALUE_TYPE: {
                ReferenceFormatter.writeTypeReference(writer, ((TypeEncodedValue)encodedValue).value);
            }
        }
    }
}

