/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data.value;

import brut.androlib.AndrolibException;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.value.ResBagValue;
import brut.androlib.res.data.value.ResReferenceValue;
import brut.androlib.res.data.value.ResScalarValue;
import brut.androlib.res.xml.ResValuesXmlSerializable;
import brut.util.Duo;
import java.io.IOException;
import org.xmlpull.v1.XmlSerializer;

public class ResArrayValue
extends ResBagValue
implements ResValuesXmlSerializable {
    private final ResScalarValue[] mItems;
    public static final int BAG_KEY_ARRAY_START = 0x2000000;

    ResArrayValue(ResReferenceValue parent, Duo<Integer, ResScalarValue>[] items) {
        super(parent);
        this.mItems = new ResScalarValue[items.length];
        for (int i = 0; i < items.length; ++i) {
            this.mItems[i] = (ResScalarValue)items[i].m2;
        }
    }

    public ResArrayValue(ResReferenceValue parent, ResScalarValue[] items) {
        super(parent);
        this.mItems = items;
    }

    @Override
    public void serializeToResValuesXml(XmlSerializer serializer, ResResource res) throws IOException, AndrolibException {
        String type = this.getType();
        type = (type == null ? "" : type + "-") + "array";
        serializer.startTag(null, type);
        serializer.attribute(null, "name", res.getResSpec().getName());
        for (int i = 0; i < this.mItems.length; ++i) {
            serializer.startTag(null, "item");
            serializer.text(this.mItems[i].encodeAsResXmlItemValue());
            serializer.endTag(null, "item");
        }
        serializer.endTag(null, type);
    }

    public String getType() {
        if (this.mItems.length == 0) {
            return null;
        }
        String type = this.mItems[0].getType();
        if (!"string".equals(type) && !"integer".equals(type)) {
            return null;
        }
        for (int i = 1; i < this.mItems.length; ++i) {
            if (type.equals(this.mItems[i].getType())) continue;
            return null;
        }
        return type;
    }
}

