/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data;

import brut.androlib.AndrolibException;
import brut.androlib.err.UndefinedResObject;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.data.ResTable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class ResType {
    private final String mName;
    private final Map<String, ResResSpec> mResSpecs = new LinkedHashMap<String, ResResSpec>();
    private final ResTable mResTable;
    private final ResPackage mPackage;

    public ResType(String name, ResTable resTable, ResPackage package_) {
        this.mName = name;
        this.mResTable = resTable;
        this.mPackage = package_;
    }

    public String getName() {
        return this.mName;
    }

    public Set<ResResSpec> listResSpecs() {
        return new LinkedHashSet<ResResSpec>(this.mResSpecs.values());
    }

    public ResResSpec getResSpec(String name) throws AndrolibException {
        ResResSpec spec = this.mResSpecs.get(name);
        if (spec == null) {
            throw new UndefinedResObject(String.format("resource spec: %s/%s", this.getName(), name));
        }
        return spec;
    }

    public void addResSpec(ResResSpec spec) throws AndrolibException {
        if (this.mResSpecs.put(spec.getName(), spec) != null) {
            throw new AndrolibException(String.format("Multiple res specs: %s/%s", this.getName(), spec.getName()));
        }
    }

    public String toString() {
        return this.mName;
    }
}

