/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.ts;

import com.googlecode.dex2jar.ir.Constant;
import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.Value;
import com.googlecode.dex2jar.ir.expr.CastExpr;
import com.googlecode.dex2jar.ir.expr.FieldExpr;
import com.googlecode.dex2jar.ir.expr.InvokeExpr;
import com.googlecode.dex2jar.ir.expr.NewExpr;
import com.googlecode.dex2jar.ir.expr.RefExpr;
import com.googlecode.dex2jar.ir.expr.TypeExpr;
import com.googlecode.dex2jar.ir.expr.UnopExpr;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.ts.Transformer;
import org.objectweb.asm.Type;

public class LocalType
implements Transformer {
    static TypeBox get(Value v) {
        TypeBox tb = (TypeBox)v._lt_type;
        if (tb == null) {
            tb = new TypeBox();
        }
        tb = LocalType.trimTypeBox(tb);
        v._lt_type = tb;
        return tb;
    }

    public static Type merge(Type t2, Type t1) {
        if (t1.getSort() == 9) {
            return t1;
        }
        return t2;
    }

    static TypeBox trimTypeBox(TypeBox tb) {
        while (tb != tb.xtype.tb) {
            tb = tb.xtype.tb;
        }
        return tb;
    }

    private static void type(TypeBox tb, Type t) {
        if (tb.xtype.type == null) {
            tb.xtype.type = t;
            tb.xtype.tb.xtype.type = t;
            return;
        }
        tb.xtype.tb.xtype.type = tb.xtype.type = LocalType.merge(tb.xtype.type, t);
    }

    public static Type typeOf(Value v) {
        return LocalType.get((Value)v).xtype.type;
    }

    public static void type(Value v, Type t) {
        LocalType.type(LocalType.get(v), t);
    }

    public TypeBox exec(Value v) {
        if (v == null) {
            return null;
        }
        TypeBox tb = LocalType.get(v);
        block0 : switch (v.et) {
            case E0: {
                switch (v.vt) {
                    case CONSTANT: {
                        Type cstType = ((Constant)v).type;
                        if (!cstType.equals((Object)Type.getType(Class.class)) && !cstType.equals((Object)Type.getType(String.class))) break;
                        LocalType.type(tb, ((Constant)v).type);
                        break;
                    }
                    case LOCAL: {
                        break;
                    }
                    case THIS_REF: 
                    case PARAMETER_REF: {
                        LocalType.type(tb, ((RefExpr)v).type);
                        break;
                    }
                    case EXCEPTION_REF: {
                        Type type = ((RefExpr)v).type;
                        LocalType.type(tb, type == null ? Type.getType(Throwable.class) : type);
                        break;
                    }
                    case NEW: {
                        LocalType.type(tb, ((NewExpr)v).type);
                    }
                }
                break;
            }
            case E1: {
                switch (v.vt) {
                    case FIELD: {
                        FieldExpr fe = (FieldExpr)v;
                        LocalType.type(tb, fe.fieldType);
                        if (fe.op == null) break;
                        LocalType.type(this.exec(fe.op.value), fe.fieldOwnerType);
                        break;
                    }
                    case NEW_ARRAY: {
                        TypeExpr te = (TypeExpr)v;
                        LocalType.type(this.exec(te.op.value), Type.INT_TYPE);
                        LocalType.type(tb, Type.getType((String)("[" + te.type.getDescriptor())));
                        break;
                    }
                    case CHECK_CAST: {
                        TypeExpr te = (TypeExpr)v;
                        LocalType.type(this.exec(te.op.value), Type.getType(Object.class));
                        LocalType.type(tb, te.type);
                        break;
                    }
                    case CAST: {
                        CastExpr te = (CastExpr)v;
                        LocalType.type(this.exec(te.op.value), te.from);
                        LocalType.type(tb, te.to);
                        break;
                    }
                    case INSTANCE_OF: {
                        TypeExpr te = (TypeExpr)v;
                        LocalType.type(this.exec(te.op.value), Type.getType(Object.class));
                        LocalType.type(tb, Type.BOOLEAN_TYPE);
                        break;
                    }
                    case LENGTH: {
                        UnopExpr te = (UnopExpr)v;
                        this.exec(te.op.value);
                        LocalType.type(te.op.value, Type.getType(Object.class));
                        LocalType.type(tb, Type.INT_TYPE);
                        break;
                    }
                    case NEG: {
                        UnopExpr te = (UnopExpr)v;
                        this.merge(tb, this.exec(te.op.value));
                    }
                }
                break;
            }
            case E2: {
                TypeBox tb1 = this.exec(((Value.E2Expr)v).op1.value);
                TypeBox tb2 = this.exec(((Value.E2Expr)v).op2.value);
                switch (v.vt) {
                    case ARRAY: {
                        LocalType.type(tb2, Type.INT_TYPE);
                        break;
                    }
                    case ADD: 
                    case SUB: 
                    case MUL: 
                    case DIV: 
                    case REM: 
                    case AND: 
                    case OR: 
                    case XOR: {
                        this.merge(tb1, tb2);
                        this.merge(tb1, tb);
                        break;
                    }
                    case SHL: 
                    case SHR: 
                    case USHR: {
                        this.merge(tb, tb1);
                        LocalType.type(tb2, Type.INT_TYPE);
                        break;
                    }
                    case LCMP: {
                        this.merge(tb1, tb2);
                        LocalType.type(tb1, Type.LONG_TYPE);
                        LocalType.type(tb, Type.INT_TYPE);
                        break;
                    }
                    case FCMPG: 
                    case FCMPL: {
                        this.merge(tb1, tb2);
                        LocalType.type(tb1, Type.FLOAT_TYPE);
                        LocalType.type(tb, Type.INT_TYPE);
                        break;
                    }
                    case DCMPG: 
                    case DCMPL: {
                        this.merge(tb1, tb2);
                        LocalType.type(tb1, Type.DOUBLE_TYPE);
                        LocalType.type(tb, Type.INT_TYPE);
                        break;
                    }
                    case GE: 
                    case GT: 
                    case LE: 
                    case LT: 
                    case EQ: 
                    case NE: {
                        this.merge(tb1, tb2);
                        LocalType.type(tb, Type.BOOLEAN_TYPE);
                    }
                }
            }
            case En: {
                switch (v.vt) {
                    case INVOKE_NEW: 
                    case INVOKE_STATIC: {
                        InvokeExpr ie = (InvokeExpr)v;
                        for (int i = 0; i < ie.ops.length; ++i) {
                            LocalType.type(this.exec(ie.ops[i].value), ie.argmentTypes[i]);
                        }
                        if (v.vt == Value.VT.INVOKE_NEW) {
                            LocalType.type(tb, ie.methodOwnerType);
                            break block0;
                        }
                        LocalType.type(tb, ie.methodReturnType);
                        break block0;
                    }
                    case INVOKE_INTERFACE: 
                    case INVOKE_SPECIAL: 
                    case INVOKE_VIRTUAL: {
                        InvokeExpr ie = (InvokeExpr)v;
                        LocalType.type(this.exec(ie.ops[0].value), ie.methodOwnerType);
                        for (int i = 1; i < ie.ops.length; ++i) {
                            LocalType.type(this.exec(ie.ops[i].value), ie.argmentTypes[i - 1]);
                        }
                        LocalType.type(tb, ie.methodReturnType);
                        break block0;
                    }
                    case NEW_MUTI_ARRAY: {
                        throw new RuntimeException();
                    }
                }
            }
        }
        return tb;
    }

    private void merge(TypeBox tb1, TypeBox tb2) {
        tb1 = LocalType.trimTypeBox(tb1);
        tb2 = LocalType.trimTypeBox(tb2);
        if (tb1.xtype.type == null) {
            tb1.xtype.tb = tb2;
            tb1.xtype = tb2.xtype;
            return;
        }
        if (tb2.xtype.type == null) {
            tb2.xtype.tb = tb1;
            tb2.xtype = tb1.xtype;
            return;
        }
        Type nt = LocalType.merge(tb1.xtype.type, tb2.xtype.type);
        tb1.xtype.tb = tb2;
        tb1.xtype = tb2.xtype;
        tb2.xtype.type = nt;
    }

    @Override
    public void transform(IrMethod irMethod) {
        for (Stmt st : irMethod.stmts) {
            block0 : switch (st.et) {
                case E0: 
                case En: {
                    break;
                }
                case E1: {
                    Stmt.E1Stmt s1 = (Stmt.E1Stmt)st;
                    switch (st.st) {
                        case GOTO: {
                            break block0;
                        }
                        case IF: {
                            LocalType.type(this.exec(s1.op.value), Type.BOOLEAN_TYPE);
                            break block0;
                        }
                        case THROW: {
                            LocalType.type(this.exec(s1.op.value), Type.getType(Throwable.class));
                            break block0;
                        }
                        case RETURN: {
                            LocalType.type(this.exec(s1.op.value), irMethod.ret);
                            break block0;
                        }
                        case LOCK: 
                        case UNLOCK: {
                            LocalType.type(this.exec(s1.op.value), Type.getType(Object.class));
                            break block0;
                        }
                        case LOOKUP_SWITCH: 
                        case TABLE_SWITCH: {
                            LocalType.type(this.exec(s1.op.value), Type.INT_TYPE);
                        }
                    }
                    break;
                }
                case E2: {
                    Stmt.E2Stmt s2 = (Stmt.E2Stmt)st;
                    TypeBox tb1 = this.exec(s2.op1.value);
                    TypeBox tb2 = this.exec(s2.op2.value);
                    this.merge(tb1, tb2);
                }
            }
        }
    }

    static class XType {
        TypeBox tb;
        Type type;

        public XType(TypeBox tb) {
            this.tb = tb;
        }

        public String toString() {
            return "" + this.type;
        }
    }

    static class TypeBox {
        XType xtype = new XType(this);

        TypeBox() {
        }

        public String toString() {
            return "" + LocalType.trimTypeBox((TypeBox)this).xtype;
        }
    }
}

