/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import org.jf.dexlib.DexFile;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.ReadContext;
import org.jf.dexlib.StringDataItem;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.Input;
import org.jf.dexlib.Util.Utf8Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringIdItem
extends Item<StringIdItem> {
    private StringDataItem stringDataItem;

    protected StringIdItem(DexFile dexFile) {
        super(dexFile);
    }

    protected StringIdItem(DexFile dexFile, StringDataItem stringDataItem) {
        super(dexFile);
        this.stringDataItem = stringDataItem;
    }

    public static StringIdItem internStringIdItem(DexFile dexFile, String stringValue) {
        StringDataItem stringDataItem = StringDataItem.internStringDataItem(dexFile, stringValue);
        if (stringDataItem == null) {
            return null;
        }
        StringIdItem stringIdItem = new StringIdItem(dexFile, stringDataItem);
        return dexFile.StringIdsSection.intern(stringIdItem);
    }

    public static StringIdItem lookupStringIdItem(DexFile dexFile, String stringValue) {
        StringDataItem stringDataItem = StringDataItem.lookupStringDataItem(dexFile, stringValue);
        if (stringDataItem == null) {
            return null;
        }
        StringIdItem stringIdItem = new StringIdItem(dexFile, stringDataItem);
        return dexFile.StringIdsSection.getInternedItem(stringIdItem);
    }

    @Override
    protected void readItem(Input in, ReadContext readContext) {
        int stringDataOffset = in.readInt();
        this.stringDataItem = (StringDataItem)readContext.getOffsettedItemByOffset(ItemType.TYPE_STRING_DATA_ITEM, stringDataOffset);
    }

    @Override
    protected int placeItem(int offset) {
        return offset + 4;
    }

    @Override
    protected void writeItem(AnnotatedOutput out) {
        if (out.annotates()) {
            out.annotate(4, this.stringDataItem.getConciseIdentity());
        }
        out.writeInt(this.stringDataItem.getOffset());
    }

    @Override
    public ItemType getItemType() {
        return ItemType.TYPE_STRING_ID_ITEM;
    }

    @Override
    public String getConciseIdentity() {
        return "string_id_item: " + Utf8Utils.escapeString(this.getStringValue());
    }

    @Override
    public int compareTo(StringIdItem o) {
        return this.getStringValue().compareTo(o.getStringValue());
    }

    public String getStringValue() {
        return this.stringDataItem.getStringValue();
    }

    public int hashCode() {
        return this.stringDataItem.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        StringIdItem other = (StringIdItem)o;
        return this.stringDataItem == other.stringDataItem;
    }
}

