/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import java.util.Iterator;
import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.MultiOffsetInstruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.NumberUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseSwitchDataPseudoInstruction
extends Instruction
implements MultiOffsetInstruction {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private int[] keys;
    private int[] targets;

    @Override
    public int getSize(int codeAddress) {
        return this.getTargetCount() * 4 + 2 + codeAddress % 2;
    }

    public SparseSwitchDataPseudoInstruction(int[] keys, int[] targets) {
        super(Opcode.NOP);
        if (keys.length != targets.length) {
            throw new RuntimeException("The number of keys and targets don't match");
        }
        if (targets.length == 0) {
            throw new RuntimeException("The sparse-switch data must contain at least 1 key/target");
        }
        if (targets.length > 65535) {
            throw new RuntimeException("The sparse-switch data contains too many elements. The maximum number of switch elements is 65535");
        }
        this.keys = keys;
        this.targets = targets;
    }

    public SparseSwitchDataPseudoInstruction(byte[] buffer, int bufferIndex) {
        super(Opcode.NOP);
        byte opcodeByte = buffer[bufferIndex];
        if (opcodeByte != 0) {
            throw new RuntimeException("Invalid opcode byte for a SparseSwitchData pseudo-instruction");
        }
        byte subopcodeByte = buffer[bufferIndex + 1];
        if (subopcodeByte != 2) {
            throw new RuntimeException("Invalid sub-opcode byte for a SparseSwitchData pseudo-instruction");
        }
        int targetCount = NumberUtils.decodeUnsignedShort(buffer, bufferIndex + 2);
        this.keys = new int[targetCount];
        this.targets = new int[targetCount];
        for (int i = 0; i < targetCount; ++i) {
            this.keys[i] = NumberUtils.decodeInt(buffer, bufferIndex + 4 + i * 4);
            this.targets[i] = NumberUtils.decodeInt(buffer, bufferIndex + 4 + targetCount * 4 + i * 4);
        }
    }

    @Override
    protected void writeInstruction(AnnotatedOutput out, int currentCodeAddress) {
        out.alignTo(4);
        out.writeByte(0);
        out.writeByte(2);
        out.writeShort(this.targets.length);
        if (this.targets.length > 0) {
            int key = this.keys[0];
            out.writeInt(key);
            for (int i = 1; i < this.keys.length; ++i) {
                key = this.keys[i];
                assert (key >= this.keys[i - 1]);
                out.writeInt(key);
            }
            for (int target : this.targets) {
                out.writeInt(target);
            }
        }
    }

    @Override
    protected void annotateInstruction(AnnotatedOutput out, int currentCodeAddress) {
        out.annotate(this.getSize(currentCodeAddress) * 2, "[0x" + Integer.toHexString(currentCodeAddress) + "] " + "sparse-switch-data instruction");
    }

    @Override
    public void updateTarget(int targetIndex, int targetAddressOffset) {
        this.targets[targetIndex] = targetAddressOffset;
    }

    @Override
    public Format getFormat() {
        return Format.SparseSwitchData;
    }

    public int getTargetCount() {
        return this.targets.length;
    }

    @Override
    public int[] getTargets() {
        return this.targets;
    }

    public Iterator<SparseSwitchTarget> iterateKeysAndTargets() {
        return new Iterator<SparseSwitchTarget>(){
            final int targetCount;
            int i;
            SparseSwitchTarget sparseSwitchTarget;
            {
                this.targetCount = SparseSwitchDataPseudoInstruction.this.getTargetCount();
                this.i = 0;
                this.sparseSwitchTarget = new SparseSwitchTarget();
            }

            @Override
            public boolean hasNext() {
                return this.i < this.targetCount;
            }

            @Override
            public SparseSwitchTarget next() {
                this.sparseSwitchTarget.key = SparseSwitchDataPseudoInstruction.this.keys[this.i];
                this.sparseSwitchTarget.targetAddressOffset = SparseSwitchDataPseudoInstruction.this.targets[this.i];
                ++this.i;
                return this.sparseSwitchTarget;
            }

            @Override
            public void remove() {
            }
        };
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] buffer, int bufferIndex) {
            if (opcode != Opcode.NOP) {
                throw new RuntimeException("The opcode for a SparseSwitchDataPseudoInstruction must be NOP");
            }
            return new SparseSwitchDataPseudoInstruction(buffer, bufferIndex);
        }
    }

    public static class SparseSwitchTarget {
        public int key;
        public int targetAddressOffset;
    }
}

