/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.Code.SingleRegisterInstruction;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.NumberUtils;

public class Instruction11x
extends Instruction
implements SingleRegisterInstruction {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private byte regA;

    public Instruction11x(Opcode opcode, short regA) {
        super(opcode);
        if (regA >= 256) {
            throw new RuntimeException("The register number must be less than v256");
        }
        this.regA = (byte)regA;
    }

    private Instruction11x(Opcode opcode, byte[] buffer, int bufferIndex) {
        super(opcode);
        this.regA = (byte)NumberUtils.decodeUnsignedByte(buffer[bufferIndex + 1]);
    }

    public void writeInstruction(AnnotatedOutput out, int currentCodeAddress) {
        out.writeByte(this.opcode.value);
        out.writeByte(this.regA);
    }

    public Format getFormat() {
        return Format.Format11x;
    }

    public int getRegisterA() {
        return this.regA & 0xFF;
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] buffer, int bufferIndex) {
            return new Instruction11x(opcode, buffer, bufferIndex);
        }
    }
}

