/*
 * Decompiled with CFR 0.152.
 */
package ds.tree;

import ds.tree.DuplicateKeyException;
import ds.tree.RadixTree;
import ds.tree.RadixTreeNode;
import ds.tree.Visitor;
import ds.tree.VisitorImpl;
import java.util.ArrayList;
import java.util.Formattable;
import java.util.Formatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RadixTreeImpl<T>
implements RadixTree<T>,
Formattable {
    protected RadixTreeNode<T> root = new RadixTreeNode();
    protected long size;

    public RadixTreeImpl() {
        this.root.setKey("");
        this.size = 0L;
    }

    @Override
    public T find(String key) {
        VisitorImpl visitor = new VisitorImpl<T, T>(){

            @Override
            public void visit(String key, RadixTreeNode<T> parent, RadixTreeNode<T> node) {
                if (node.isReal()) {
                    this.result = node.getValue();
                }
            }
        };
        this.visit(key, visitor);
        return (T)visitor.getResult();
    }

    @Override
    public boolean replace(String key, final T value) {
        VisitorImpl visitor = new VisitorImpl<T, T>(){

            @Override
            public void visit(String key, RadixTreeNode<T> parent, RadixTreeNode<T> node) {
                if (node.isReal()) {
                    node.setValue(value);
                    this.result = value;
                } else {
                    this.result = null;
                }
            }
        };
        this.visit(key, visitor);
        return visitor.getResult() != null;
    }

    @Override
    public void insert(String key, T value) throws DuplicateKeyException {
        try {
            this.insert(key, this.root, value);
        }
        catch (DuplicateKeyException e) {
            throw new DuplicateKeyException("Duplicate key: '" + key + "'");
        }
        ++this.size;
    }

    private void insert(String key, RadixTreeNode<T> node, T value) throws DuplicateKeyException {
        int numberOfMatchingCharacters = node.getNumberOfMatchingCharacters(key);
        if (node.getKey().equals("") || numberOfMatchingCharacters == 0 || numberOfMatchingCharacters < key.length() && numberOfMatchingCharacters >= node.getKey().length()) {
            boolean flag = false;
            String newText = key.substring(numberOfMatchingCharacters, key.length());
            for (RadixTreeNode<T> child : node.getChildern()) {
                if (!child.getKey().startsWith(newText.charAt(0) + "")) continue;
                flag = true;
                this.insert(newText, child, value);
                break;
            }
            if (!flag) {
                RadixTreeNode<T> n = new RadixTreeNode<T>();
                n.setKey(newText);
                n.setReal(true);
                n.setValue(value);
                node.getChildern().add(n);
            }
        } else if (numberOfMatchingCharacters == key.length() && numberOfMatchingCharacters == node.getKey().length()) {
            if (node.isReal()) {
                throw new DuplicateKeyException("Duplicate key");
            }
            node.setReal(true);
            node.setValue(value);
        } else if (numberOfMatchingCharacters > 0 && numberOfMatchingCharacters < node.getKey().length()) {
            RadixTreeNode<T> n1 = new RadixTreeNode<T>();
            n1.setKey(node.getKey().substring(numberOfMatchingCharacters, node.getKey().length()));
            n1.setReal(node.isReal());
            n1.setValue(node.getValue());
            n1.setChildern(node.getChildern());
            node.setKey(key.substring(0, numberOfMatchingCharacters));
            node.setReal(false);
            node.setChildern(new ArrayList());
            node.getChildern().add(n1);
            if (numberOfMatchingCharacters < key.length()) {
                RadixTreeNode<T> n2 = new RadixTreeNode<T>();
                n2.setKey(key.substring(numberOfMatchingCharacters, key.length()));
                n2.setReal(true);
                n2.setValue(value);
                node.getChildern().add(n2);
            } else {
                node.setValue(value);
                node.setReal(true);
            }
        } else {
            RadixTreeNode<T> n = new RadixTreeNode<T>();
            n.setKey(node.getKey().substring(numberOfMatchingCharacters, node.getKey().length()));
            n.setChildern(node.getChildern());
            n.setReal(node.isReal());
            n.setValue(node.getValue());
            node.setKey(key);
            node.setReal(true);
            node.setValue(value);
            node.getChildern().add(n);
        }
    }

    public <R> void visit(String key, Visitor<T, R> visitor) {
        if (this.root != null) {
            this.visit(key, visitor, null, this.root);
        }
    }

    private <R> void visit(String prefix, Visitor<T, R> visitor, RadixTreeNode<T> parent, RadixTreeNode<T> node) {
        int numberOfMatchingCharacters = node.getNumberOfMatchingCharacters(prefix);
        if (numberOfMatchingCharacters == prefix.length() && numberOfMatchingCharacters == node.getKey().length()) {
            visitor.visit(prefix, parent, node);
        } else if (node.getKey().equals("") || numberOfMatchingCharacters < prefix.length() && numberOfMatchingCharacters >= node.getKey().length()) {
            String newText = prefix.substring(numberOfMatchingCharacters, prefix.length());
            for (RadixTreeNode<T> child : node.getChildern()) {
                if (!child.getKey().startsWith(newText.charAt(0) + "")) continue;
                this.visit(newText, visitor, node, child);
                break;
            }
        }
    }

    @Override
    public long getSize() {
        return this.size;
    }

    private void formatNodeTo(Formatter f, int level, RadixTreeNode<T> node) {
        int i;
        for (i = 0; i < level; ++i) {
            f.format(" ", new Object[0]);
        }
        f.format("|", new Object[0]);
        for (i = 0; i < level; ++i) {
            f.format("-", new Object[0]);
        }
        if (node.isReal()) {
            f.format("%s[%s]*%n", node.getKey(), node.getValue());
        } else {
            f.format("%s%n", node.getKey());
        }
        for (RadixTreeNode<T> child : node.getChildern()) {
            this.formatNodeTo(f, level + 1, child);
        }
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        this.formatNodeTo(formatter, 0, this.root);
    }
}

