/*
 * Decompiled with CFR 0.152.
 */
package brut.directory;

import brut.directory.AbstractDirectory;
import brut.directory.DirectoryException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;

public class FileDirectory
extends AbstractDirectory {
    private File mDir;

    public FileDirectory(File dir) throws DirectoryException {
        if (!dir.isDirectory()) {
            throw new DirectoryException("file must be a directory: " + dir);
        }
        this.mDir = dir;
    }

    protected AbstractDirectory createDirLocal(String name) throws DirectoryException {
        File dir = new File(this.generatePath(name));
        dir.mkdir();
        return new FileDirectory(dir);
    }

    protected InputStream getFileInputLocal(String name) throws DirectoryException {
        try {
            return new FileInputStream(this.generatePath(name));
        }
        catch (FileNotFoundException e) {
            throw new DirectoryException(e);
        }
    }

    protected OutputStream getFileOutputLocal(String name) throws DirectoryException {
        try {
            return new FileOutputStream(this.generatePath(name));
        }
        catch (FileNotFoundException e) {
            throw new DirectoryException(e);
        }
    }

    protected void loadDirs() {
        this.loadAll();
    }

    protected void loadFiles() {
        this.loadAll();
    }

    protected void removeFileLocal(String name) {
        new File(this.generatePath(name)).delete();
    }

    private String generatePath(String name) {
        return this.getDir().getPath() + '/' + name;
    }

    private void loadAll() {
        this.mFiles = new LinkedHashSet();
        this.mDirs = new LinkedHashMap();
        File[] files = this.getDir().listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isFile()) {
                this.mFiles.add(file.getName());
                continue;
            }
            try {
                this.mDirs.put(file.getName(), new FileDirectory(file));
                continue;
            }
            catch (DirectoryException e) {
                // empty catch block
            }
        }
    }

    private File getDir() {
        return this.mDir;
    }
}

